/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.jmx.compliance.modelmbean;

import javax.management.Descriptor;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import javax.management.modelmbean.ModelMBeanConstructorInfo;
import javax.management.modelmbean.ModelMBeanInfo;
import javax.management.modelmbean.ModelMBeanInfoSupport;
import javax.management.modelmbean.ModelMBeanOperationInfo;
import javax.management.modelmbean.RequiredModelMBean;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;

public class ModelMBeanInfoSupportTEST
extends TestCase {
    public ModelMBeanInfoSupportTEST(String s) {
        super(s);
    }

    public void testSetDescriptors() throws Exception {
        boolean READABLE = true;
        boolean WRITABLE = true;
        boolean ISIS = true;
        RequiredModelMBean mbean = new RequiredModelMBean();
        ModelMBeanAttributeInfo attr1 = new ModelMBeanAttributeInfo("Kissa", String.class.getName(), "Some attribute description", false, false, false);
        ModelMBeanAttributeInfo attr2 = new ModelMBeanAttributeInfo("Koira", String.class.getName(), "Another attribute description", false, false, false);
        ModelMBeanConstructorInfo constr1 = new ModelMBeanConstructorInfo("FirstConstructor", "Description of the first constructor", null);
        ModelMBeanConstructorInfo constr2 = new ModelMBeanConstructorInfo("SecondConstructor", "Description of the second constructor", null);
        ModelMBeanConstructorInfo constr3 = new ModelMBeanConstructorInfo("ThirdConstructor", "Description of the 3rd constructor", null);
        ModelMBeanOperationInfo operation = new ModelMBeanOperationInfo("AnOperation", "The description", null, "AType", 1);
        ModelMBeanInfoSupport info = new ModelMBeanInfoSupport(mbean.getClass().getName(), "some description", new ModelMBeanAttributeInfo[]{attr1, attr2}, new ModelMBeanConstructorInfo[]{constr1, constr2, constr3}, new ModelMBeanOperationInfo[]{operation}, null);
        Descriptor descr1 = info.getDescriptor("SecondConstructor", "constructor");
        ModelMBeanInfoSupportTEST.assertEquals((Object)"SecondConstructor", (Object)descr1.getFieldValue("name"));
        ModelMBeanInfoSupportTEST.assertEquals((Object)"constructor", (Object)descr1.getFieldValue("role"));
        Object descr2 = null;
        Descriptor[] descr3 = info.getDescriptors("operation");
        ModelMBeanInfoSupportTEST.assertEquals((Object)"operation", (Object)descr3[0].getFieldValue("descriptorType"));
        ModelMBeanInfoSupportTEST.assertEquals((Object)"AnOperation", (Object)descr3[0].getFieldValue("name"));
        descr1.setField("someField", "someValue");
        descr3[0].setField("Yksi", "Kaksi");
        info.setDescriptors(new Descriptor[]{descr1, descr2, descr3[0]});
        descr1 = info.getDescriptor("SecondConstructor", "constructor");
        ModelMBeanInfoSupportTEST.assertEquals((Object)"SecondConstructor", (Object)descr1.getFieldValue("name"));
        ModelMBeanInfoSupportTEST.assertEquals((Object)"constructor", (Object)descr1.getFieldValue("role"));
        ModelMBeanInfoSupportTEST.assertEquals((String)"FAILS IN JBOSSMX", (Object)"someValue", (Object)descr1.getFieldValue("someField"));
        descr1 = info.getDescriptor("AnOperation", "operation");
        ModelMBeanInfoSupportTEST.assertEquals((Object)"AnOperation", (Object)descr1.getFieldValue("name"));
        ModelMBeanInfoSupportTEST.assertEquals((Object)"Kaksi", (Object)descr1.getFieldValue("Yksi"));
    }

    public void testGetDescriptor() throws Exception {
        boolean READABLE = true;
        boolean WRITABLE = true;
        boolean ISIS = true;
        RequiredModelMBean mbean = new RequiredModelMBean();
        ModelMBeanAttributeInfo attr1 = new ModelMBeanAttributeInfo("Kissa", String.class.getName(), "Some attribute description", false, false, false);
        ModelMBeanAttributeInfo attr2 = new ModelMBeanAttributeInfo("Koira", String.class.getName(), "Another attribute description", false, false, false);
        ModelMBeanConstructorInfo constr1 = new ModelMBeanConstructorInfo("FirstConstructor", "Description of the first constructor", null);
        ModelMBeanConstructorInfo constr2 = new ModelMBeanConstructorInfo("SecondConstructor", "Description of the second constructor", null);
        ModelMBeanConstructorInfo constr3 = new ModelMBeanConstructorInfo("ThirdConstructor", "Description of the 3rd constructor", null);
        ModelMBeanOperationInfo operation = new ModelMBeanOperationInfo("AnOperation", "The description", null, "AType", 1);
        ModelMBeanInfoSupport info = new ModelMBeanInfoSupport(mbean.getClass().getName(), "some description", new ModelMBeanAttributeInfo[]{attr1, attr2}, new ModelMBeanConstructorInfo[]{constr1, constr2, constr3}, new ModelMBeanOperationInfo[]{operation}, null);
        Descriptor descr = info.getDescriptor("SecondConstructor", "constructor");
        try {
            ModelMBeanInfoSupportTEST.assertTrue((boolean)descr.getFieldValue("descriptorType").equals("operation"));
        }
        catch (AssertionFailedError e) {
            throw new AssertionFailedError("FAILS IN JBOSSMX: We incorrectly return descriptor type 'constructor' here -- should be 'operation'");
        }
    }

    public void testClone() throws Exception {
        boolean READABLE = true;
        boolean WRITABLE = true;
        boolean ISIS = true;
        RequiredModelMBean mbean = new RequiredModelMBean();
        ModelMBeanAttributeInfo attr1 = new ModelMBeanAttributeInfo("Kissa", String.class.getName(), "Some attribute description", false, false, false);
        ModelMBeanAttributeInfo attr2 = new ModelMBeanAttributeInfo("Koira", String.class.getName(), "Another attribute description", false, false, false);
        ModelMBeanConstructorInfo constr1 = new ModelMBeanConstructorInfo("FirstConstructor", "Description of the first constructor", null);
        ModelMBeanConstructorInfo constr2 = new ModelMBeanConstructorInfo("SecondConstructor", "Description of the second constructor", null);
        ModelMBeanConstructorInfo constr3 = new ModelMBeanConstructorInfo("ThirdConstructor", "Description of the 3rd constructor", null);
        ModelMBeanOperationInfo operation = new ModelMBeanOperationInfo("AnOperation", "The description", null, "AType", 1);
        ModelMBeanInfoSupport info = new ModelMBeanInfoSupport(mbean.getClass().getName(), "some description", new ModelMBeanAttributeInfo[]{attr1, attr2}, new ModelMBeanConstructorInfo[]{constr1, constr2, constr3}, new ModelMBeanOperationInfo[]{operation}, null);
        ModelMBeanInfo clone = (ModelMBeanInfo)info.clone();
        ModelMBeanInfoSupportTEST.assertTrue((clone.getDescriptors(null).length == info.getDescriptors(null).length ? 1 : 0) != 0);
        ModelMBeanInfoSupportTEST.assertTrue((boolean)clone.getDescriptor("AnOperation", "operation").getFieldValue("descriptorType").equals(info.getDescriptor("AnOperation", "operation").getFieldValue("descriptorType")));
        ModelMBeanInfoSupportTEST.assertTrue((boolean)clone.getDescriptor("AnOperation", "operation").getFieldValue("name").equals(info.getDescriptor("AnOperation", "operation").getFieldValue("name")));
    }
}

