/*
 * JBoss, Home of Professional Open Source
 * Copyright 2010, Red Hat, Inc. and/or its affiliates,
 * and individual contributors as indicated by the @author tags.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 *
 * (C) 2010,
 * @author JBoss, by Red Hat.
 */
package com.arjuna.orbportability.logging;

import org.jboss.logging.Logger;

import static org.jboss.logging.Logger.Level.*;
/**
 * i18n log messages for the orbportability module.
 * This class is autogenerated. Don't mess with it.
 *
 * @author Jonathan Halliday (jonathan.halliday@redhat.com) 2010-06
 */
public class orbportabilityI18NLoggerImpl implements orbportabilityI18NLogger {

	private final Logger logger;

	orbportabilityI18NLoggerImpl(Logger logger) {
		this.logger = logger;
	}

	public void warn_OA_caughtexception(String arg0, Throwable arg1) {
		logger.logv(WARN, arg1, "ARJUNA-21001 {0} caught exception whilst initialising Object Adapter.", arg0);
	}

	public void warn_OA_exceptioncaughtforobj(String arg0, String arg1, Throwable arg2) {
		logger.logv(WARN, arg2, "ARJUNA-21002 {0}: exception caught for {1}", arg0, arg1);
	}

	public void warn_OA_initialize() {
		logger.logv(WARN, "ARJUNA-21003 caught org.omg.CORBA.INITIALIZE whilst initialising Object Adapter. Check another ORB/service is not active on same port.", (Object)null);
	}

	public void warn_OA_invalidpoa(String arg0, String arg1) {
		logger.logv(WARN, "ARJUNA-21004 {0} - invalid POA: {1}", arg0, arg1);
	}

	public void warn_OA_oanotinitialised() {
		logger.logv(WARN, "ARJUNA-21005 OA.createPOA - createPOA called without OA being initialised", (Object)null);
	}

	public String get_OA_uninitialsedorb() {
		return "ARJUNA-21006 OA.initPOA called without initialised ORB.";
	}

	public void fatal_ORBInfo_creationfailed(Throwable arg0) {
		logger.logv(FATAL, arg0, "ARJUNA-21010 ORBInfo ORB specific class creation failed with exception", (Object)null);
	}

	public void fatal_ORBInfo_unsupportedorb(Throwable arg0) {
		logger.logv(FATAL, arg0, "ARJUNA-21011 ORBInfo ORB specific class creation failed - unable to find supported ORB", (Object)null);
	}

	public void warn_Services_optionnotsupported(String arg0, String arg1) {
		logger.logv(WARN, "ARJUNA-21013 {0} - {1} option not supported by ORB.", arg0, arg1);
	}

	public void warn_Services_servicenotfound(String arg0, String arg1) {
		logger.logv(WARN, "ARJUNA-21015 Services.getService - could not find service: {0} in configuration file: {1}", arg0, arg1);
	}

	public void warn_Services_suspectentry(String arg0, String arg1) {
		logger.logv(WARN, "ARJUNA-21016 {0} Suspect entry in configuration file: {1}", arg0, arg1);
	}

	public void warn_Services_unexpectedexception(String arg0, Throwable arg1) {
		logger.logv(WARN, arg1, "ARJUNA-21017 {0} - caught unexpected exception", arg0);
	}

	public void warn_Services_unsupportedoption(String arg0) {
		logger.logv(WARN, "ARJUNA-21018 Services.getService - {0} option not supported by ORB.", arg0);
	}

	public void warn_common_Configuration_bindDefault_invalidbind(String arg0) {
		logger.logv(WARN, "ARJUNA-21019 {0} - invalid bind mechanism in properties file", arg0);
	}

	public void warn_event_EventManager_caughtexceptionfor(String arg0, String arg1, Throwable arg2) {
		logger.logv(WARN, arg2, "ARJUNA-21020 {0} - caught exception for {1}", arg0, arg1);
	}

	public void warn_event_EventManager_forhandlethrewexception(String arg0, String arg1, Throwable arg2) {
		logger.logv(WARN, arg2, "ARJUNA-21021 {0} - for: {1} threw exception", arg0, arg1);
	}

	public void warn_internal_orbspecific_oa_implementations(String arg0) {
		logger.logv(WARN, "ARJUNA-21023 {0} called without root POA.", arg0);
	}

	public void warn_internal_utils_InitLoader_couldnotfindclass(String arg0, String arg1) {
		logger.logv(WARN, "ARJUNA-21024 {0} - could not find class {1}", arg0, arg1);
	}

	public void warn_internal_utils_InitLoader_exception(String arg0, Throwable arg1) {
		logger.logv(WARN, arg1, "ARJUNA-21025 Exception whilst loading {1}", arg0);
	}

	public void warn_internal_utils_InitLoader_initfailed(String arg0, String arg1) {
		logger.logv(WARN, "ARJUNA-21026 {0} - attempt to initialise {1} with null class name!", arg0, arg1);
	}

	public void info_internal_utils_InitLoader_loading(String arg0, String arg1) {
		logger.logv(INFO, "ARJUNA-21027 Loading {0} class - {1}", arg0, arg1);
	}
}
