/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xb.binding;

import java.io.InputStream;
import java.io.Reader;
import org.jboss.xb.binding.JBossXBException;
import org.jboss.xb.binding.ObjectModelBuilder;
import org.jboss.xb.binding.ObjectModelFactory;
import org.jboss.xb.binding.Unmarshaller;
import org.jboss.xb.binding.metadata.unmarshalling.DocumentBinding;
import org.jboss.xb.binding.parser.JBossXBParser;
import org.jboss.xb.binding.parser.sax.SaxJBossXBParser;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBinding;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBindingResolver;
import org.jboss.xb.binding.sunday.unmarshalling.SundayContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;

public class UnmarshallerImpl
implements Unmarshaller {
    private ObjectModelBuilder builder;
    private final JBossXBParser parser = new SaxJBossXBParser();

    public void setValidation(boolean validation) throws JBossXBException {
        this.parser.setFeature("http://xml.org/sax/features/validation", validation);
        if (!validation) {
            this.parser.setFeature("http://apache.org/xml/features/validation/dynamic", false);
        }
    }

    public void setSchemaValidation(boolean validation) throws JBossXBException {
        this.parser.setFeature("http://apache.org/xml/features/validation/schema", validation);
    }

    public void setFeature(String feature, boolean value) throws JBossXBException {
        this.parser.setFeature(feature, value);
    }

    public void setNamespaceAware(boolean namespaces) throws JBossXBException {
        this.parser.setFeature("http://xml.org/sax/features/namespaces", namespaces);
    }

    public void setEntityResolver(EntityResolver entityResolver) throws JBossXBException {
        this.parser.setEntityResolver(entityResolver);
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
    }

    public void mapFactoryToNamespace(ObjectModelFactory factory, String namespaceUri) {
        if (this.builder == null) {
            this.builder = new ObjectModelBuilder();
        }
        this.builder.mapFactoryToNamespace(factory, namespaceUri);
    }

    public Object unmarshal(String xmlFile) throws JBossXBException {
        throw new UnsupportedOperationException();
    }

    public Object unmarshal(String xmlFile, JBossXBParser.ContentHandler handler) throws JBossXBException {
        this.parser.parse(xmlFile, handler);
        return handler.getRoot();
    }

    public Object unmarshal(String xml, SchemaBinding schemaBinding) throws JBossXBException {
        SundayContentHandler cHandler = new SundayContentHandler(schemaBinding);
        this.parser.parse(xml, (JBossXBParser.ContentHandler)cHandler);
        return cHandler.getRoot();
    }

    public Object unmarshal(Reader xmlReader, SchemaBinding schemaBinding) throws JBossXBException {
        SundayContentHandler cHandler = new SundayContentHandler(schemaBinding);
        this.parser.parse(xmlReader, (JBossXBParser.ContentHandler)cHandler);
        return cHandler.getRoot();
    }

    public Object unmarshal(InputStream xmlStream, SchemaBinding schemaBinding) throws JBossXBException {
        SundayContentHandler cHandler = new SundayContentHandler(schemaBinding);
        this.parser.parse(xmlStream, (JBossXBParser.ContentHandler)cHandler);
        return cHandler.getRoot();
    }

    public Object unmarshal(InputSource source, SchemaBinding schemaBinding) throws JBossXBException {
        SundayContentHandler cHandler = new SundayContentHandler(schemaBinding);
        this.parser.parse(source, (JBossXBParser.ContentHandler)cHandler);
        return cHandler.getRoot();
    }

    public Object unmarshal(String xml, SchemaBindingResolver schemaResolver) throws JBossXBException {
        SundayContentHandler cHandler = new SundayContentHandler(schemaResolver);
        this.parser.parse(xml, (JBossXBParser.ContentHandler)cHandler);
        return cHandler.getRoot();
    }

    public Object unmarshal(Reader xmlReader, SchemaBindingResolver schemaResolver) throws JBossXBException {
        SundayContentHandler cHandler = new SundayContentHandler(schemaResolver);
        this.parser.parse(xmlReader, (JBossXBParser.ContentHandler)cHandler);
        return cHandler.getRoot();
    }

    public Object unmarshal(InputStream xmlStream, SchemaBindingResolver schemaResolver) throws JBossXBException {
        SundayContentHandler cHandler = new SundayContentHandler(schemaResolver);
        this.parser.parse(xmlStream, (JBossXBParser.ContentHandler)cHandler);
        return cHandler.getRoot();
    }

    public Object unmarshal(InputSource source, SchemaBindingResolver schemaResolver) throws JBossXBException {
        SundayContentHandler cHandler = new SundayContentHandler(schemaResolver);
        this.parser.parse(source, (JBossXBParser.ContentHandler)cHandler);
        return cHandler.getRoot();
    }

    public Object unmarshal(Reader reader, ObjectModelFactory factory, Object root) throws JBossXBException {
        if (this.builder == null) {
            this.builder = new ObjectModelBuilder();
        }
        this.builder.init(factory, root);
        this.parser.parse(reader, (JBossXBParser.ContentHandler)this.builder);
        return this.builder.getRoot();
    }

    public Object unmarshal(InputStream is, ObjectModelFactory factory, Object root) throws JBossXBException {
        if (this.builder == null) {
            this.builder = new ObjectModelBuilder();
        }
        this.builder.init(factory, root);
        this.parser.parse(is, (JBossXBParser.ContentHandler)this.builder);
        return this.builder.getRoot();
    }

    public Object unmarshal(String systemId, ObjectModelFactory factory, Object root) throws JBossXBException {
        if (this.builder == null) {
            this.builder = new ObjectModelBuilder();
        }
        this.builder.init(factory, root);
        this.parser.parse(systemId, (JBossXBParser.ContentHandler)this.builder);
        return this.builder.getRoot();
    }

    public Object unmarshal(InputSource is, ObjectModelFactory factory, Object root) throws JBossXBException {
        if (this.builder == null) {
            this.builder = new ObjectModelBuilder();
        }
        this.builder.init(factory, root);
        this.parser.parse(is, (JBossXBParser.ContentHandler)this.builder);
        return this.builder.getRoot();
    }

    public Object unmarshal(String systemId, ObjectModelFactory factory, DocumentBinding binding) throws JBossXBException {
        if (binding != null) {
            throw new IllegalStateException("DocumentBinding API is not supported anymore!");
        }
        return this.unmarshal(systemId, factory, (Object)null);
    }

    public Object unmarshal(Reader reader, ObjectModelFactory factory, DocumentBinding binding) throws JBossXBException {
        if (binding != null) {
            throw new IllegalStateException("DocumentBinding API is not supported anymore!");
        }
        return this.unmarshal(reader, factory, (Object)null);
    }

    JBossXBParser getParser() {
        return this.parser;
    }
}

