/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.jdk;

import java.security.AccessController;
import java.security.PrivilegedAction;

class SecurityActions {
    SecurityActions() {
    }

    static String getProperty(String name) {
        String value = System.getSecurityManager() == null ? Actions.NON_PRIVILEGED.getProperty(name) : Actions.PRIVILEGED.getProperty(name);
        return value;
    }

    static String getProperty(String name, String def) {
        String value = System.getSecurityManager() == null ? Actions.NON_PRIVILEGED.getProperty(name, def) : Actions.PRIVILEGED.getProperty(name, def);
        return value;
    }

    static interface Actions {
        public static final Actions NON_PRIVILEGED = new Actions(){

            public String getProperty(String name) {
                return System.getProperty(name);
            }

            public String getProperty(String name, String def) {
                return System.getProperty(name, def);
            }
        };
        public static final Actions PRIVILEGED = new Actions(){

            public String getProperty(final String name) {
                return AccessController.doPrivileged(new PrivilegedAction<String>(){

                    @Override
                    public String run() {
                        return System.getProperty(name);
                    }
                });
            }

            public String getProperty(final String name, final String def) {
                return AccessController.doPrivileged(new PrivilegedAction<String>(){

                    @Override
                    public String run() {
                        return System.getProperty(name, def);
                    }
                });
            }
        };

        public String getProperty(String var1);

        public String getProperty(String var1, String var2);
    }
}

