/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.log4j;

import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Level;

public final class JDKLevel
extends Level {
    private static final long serialVersionUID = -2456662804627419121L;
    public static final Level SEVERE = new JDKLevel(40000, "SEVERE", 3);
    public static final Level WARNING = new JDKLevel(30000, "WARNING", 4);
    public static final Level INFO = new JDKLevel(20000, "INFO", 5);
    public static final Level CONFIG = new JDKLevel(15000, "CONFIG", 6);
    public static final Level FINE = new JDKLevel(10000, "FINE", 7);
    public static final Level FINER = new JDKLevel(7500, "FINER", 7);
    public static final Level FINEST = new JDKLevel(5000, "FINEST", 7);
    private static final Map<String, Level> levelMapping = new HashMap<String, Level>();

    protected JDKLevel(int level, String levelStr, int syslogEquivalent) {
        super(level, levelStr, syslogEquivalent);
    }

    private static void add(Level lvl) {
        levelMapping.put(lvl.toString(), lvl);
    }

    public static Level toLevel(String name) {
        Level level = levelMapping.get(name.trim().toUpperCase());
        return level != null ? level : Level.toLevel((String)name);
    }

    static {
        JDKLevel.add(SEVERE);
        JDKLevel.add(WARNING);
        JDKLevel.add(INFO);
        JDKLevel.add(CONFIG);
        JDKLevel.add(FINE);
        JDKLevel.add(FINER);
        JDKLevel.add(FINEST);
    }
}

