/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.marshalling.serial;

import java.io.IOException;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.util.Map;
import java.util.TreeMap;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.MarshallerObjectOutputStream;
import org.jboss.marshalling.reflect.SerializableClass;
import org.jboss.marshalling.reflect.SerializableField;
import org.jboss.marshalling.serial.BlockMarshaller;
import org.jboss.marshalling.serial.SerialMarshaller;
import org.jboss.marshalling.util.BooleanFieldPutter;
import org.jboss.marshalling.util.ByteFieldPutter;
import org.jboss.marshalling.util.CharFieldPutter;
import org.jboss.marshalling.util.DoubleFieldPutter;
import org.jboss.marshalling.util.FieldPutter;
import org.jboss.marshalling.util.FloatFieldPutter;
import org.jboss.marshalling.util.IntFieldPutter;
import org.jboss.marshalling.util.Kind;
import org.jboss.marshalling.util.LongFieldPutter;
import org.jboss.marshalling.util.ObjectFieldPutter;
import org.jboss.marshalling.util.ShortFieldPutter;

public final class SerialObjectOutputStream
extends MarshallerObjectOutputStream {
    private final SerialMarshaller serialMarshaller;
    private State state = State.OFF;
    private Object currentObject;
    private SerializableClass currentSerializableClass;
    private Map<String, FieldPutter> currentFieldMap;

    protected SerialObjectOutputStream(SerialMarshaller serialMarshaller, BlockMarshaller blockMarshaller) throws IOException, SecurityException {
        super((Marshaller)blockMarshaller);
        this.serialMarshaller = serialMarshaller;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    State saveState() {
        try {
            State state = this.state;
            return state;
        }
        finally {
            this.state = State.NEW;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    State restoreState(State state) {
        try {
            State state2 = this.state;
            return state2;
        }
        finally {
            this.state = state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object saveCurrentObject(Object currentObject) {
        try {
            Object object = this.currentObject;
            return object;
        }
        finally {
            this.currentObject = currentObject;
        }
    }

    void setCurrentObject(Object currentObject) {
        this.currentObject = currentObject;
    }

    Map<String, FieldPutter> saveCurrentFieldMap() {
        return this.currentFieldMap;
    }

    void setCurrentFieldMap(Map<String, FieldPutter> map) {
        this.currentFieldMap = map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SerializableClass saveCurrentSerializableClass(SerializableClass currentSerializableClass) {
        try {
            SerializableClass serializableClass = this.currentSerializableClass;
            return serializableClass;
        }
        finally {
            this.currentSerializableClass = currentSerializableClass;
        }
    }

    void setCurrentSerializableClass(SerializableClass currentSerializableClass) {
        this.currentSerializableClass = currentSerializableClass;
    }

    public void writeFields() throws IOException {
        if (this.state == State.FIELDS) {
            for (FieldPutter putter : this.currentFieldMap.values()) {
                if (putter.getKind() == Kind.OBJECT) continue;
                putter.write((Marshaller)this.serialMarshaller);
            }
            for (FieldPutter putter : this.currentFieldMap.values()) {
                if (putter.getKind() != Kind.OBJECT) continue;
                putter.write((Marshaller)this.serialMarshaller);
            }
        } else {
            throw new IllegalStateException("fields may not be written now");
        }
        this.state = State.ON;
    }

    public ObjectOutputStream.PutField putFields() throws IOException {
        if (this.state == State.NEW) {
            final TreeMap<String, FieldPutter> map = new TreeMap<String, FieldPutter>();
            this.currentFieldMap = map;
            block11: for (SerializableField serializableField : this.currentSerializableClass.getFields()) {
                BooleanFieldPutter putter;
                switch (serializableField.getKind()) {
                    case BOOLEAN: {
                        putter = new BooleanFieldPutter();
                        break;
                    }
                    case BYTE: {
                        putter = new ByteFieldPutter();
                        break;
                    }
                    case CHAR: {
                        putter = new CharFieldPutter();
                        break;
                    }
                    case DOUBLE: {
                        putter = new DoubleFieldPutter();
                        break;
                    }
                    case FLOAT: {
                        putter = new FloatFieldPutter();
                        break;
                    }
                    case INT: {
                        putter = new IntFieldPutter();
                        break;
                    }
                    case LONG: {
                        putter = new LongFieldPutter();
                        break;
                    }
                    case OBJECT: {
                        putter = new ObjectFieldPutter(serializableField.isUnshared());
                        break;
                    }
                    case SHORT: {
                        putter = new ShortFieldPutter();
                        break;
                    }
                    default: {
                        continue block11;
                    }
                }
                map.put(serializableField.getName(), (FieldPutter)putter);
            }
            this.state = State.FIELDS;
            return new ObjectOutputStream.PutField(){

                @Override
                public void put(String name, boolean val) {
                    this.find(name).setBoolean(val);
                }

                @Override
                public void put(String name, byte val) {
                    this.find(name).setByte(val);
                }

                @Override
                public void put(String name, char val) {
                    this.find(name).setChar(val);
                }

                @Override
                public void put(String name, short val) {
                    this.find(name).setShort(val);
                }

                @Override
                public void put(String name, int val) {
                    this.find(name).setInt(val);
                }

                @Override
                public void put(String name, long val) {
                    this.find(name).setLong(val);
                }

                @Override
                public void put(String name, float val) {
                    this.find(name).setFloat(val);
                }

                @Override
                public void put(String name, double val) {
                    this.find(name).setDouble(val);
                }

                @Override
                public void put(String name, Object val) {
                    this.find(name).setObject(val);
                }

                @Override
                @Deprecated
                public void write(ObjectOutput out) throws IOException {
                    throw new UnsupportedOperationException("write(ObjectOutput)");
                }

                private FieldPutter find(String name) {
                    FieldPutter putter = (FieldPutter)map.get(name);
                    if (putter == null) {
                        throw new IllegalArgumentException("No field named '" + name + "' found");
                    }
                    return putter;
                }
            };
        }
        throw new IllegalStateException("putFields() may not be called now");
    }

    public void defaultWriteObject() throws IOException {
        if (this.state != State.NEW && this.state != State.FIELDS) {
            throw new IllegalStateException("fields may not be written now");
        }
        this.serialMarshaller.doWriteFields(this.currentSerializableClass, this.currentObject);
        this.state = State.ON;
    }

    protected static enum State {
        OFF,
        NEW,
        FIELDS,
        ON;

    }
}

