/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.process.processor.ejb.jboss;

import javax.ejb.EJBLocalObject;
import org.jboss.logging.Logger;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeanMetaData;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeansMetaData;
import org.jboss.metadata.ejb.jboss.JBossMetaData;
import org.jboss.metadata.ejb.jboss.JBossSessionBeanMetaData;
import org.jboss.metadata.ejb.spec.BusinessLocalsMetaData;
import org.jboss.metadata.lang.ClassHelper;
import org.jboss.metadata.process.ProcessingException;
import org.jboss.metadata.process.processor.JBossMetaDataProcessor;

public class SetDefaultLocalBusinessInterfaceProcessor<T extends JBossMetaData>
implements JBossMetaDataProcessor<T> {
    private static final Logger log = Logger.getLogger(SetDefaultLocalBusinessInterfaceProcessor.class);
    private ClassLoader cl;

    public SetDefaultLocalBusinessInterfaceProcessor(ClassLoader cl) {
        assert (cl != null) : "Specified ClassLoader was null";
        this.setCl(cl);
    }

    @Override
    public T process(T metadata) throws ProcessingException {
        assert (metadata != null) : "Specified metadata was null";
        JBossEnterpriseBeansMetaData ejbs = ((JBossMetaData)metadata).getEnterpriseBeans();
        for (JBossEnterpriseBeanMetaData ejb : ejbs) {
            Class businessInterface;
            if (!ejb.isSession()) continue;
            JBossSessionBeanMetaData smd = (JBossSessionBeanMetaData)ejb;
            String ejbImplementationClassName = smd.getEjbClass();
            assert (ejbImplementationClassName != null && ejbImplementationClassName.trim().length() > 0) : "EJB Implementation Class for EJB " + smd.getName() + " was not specified";
            ClassLoader cl = this.getCl();
            Class<?> ejbImplementationClass = null;
            try {
                ejbImplementationClass = Class.forName(ejbImplementationClassName, false, cl);
            }
            catch (ClassNotFoundException e) {
                throw new ProcessingException("Could not load EJB Implementation Class " + ejbImplementationClassName + " from the specified ClassLoader: " + cl);
            }
            if (smd.getBusinessLocals() != null && smd.getBusinessLocals().size() > 0 || smd.getBusinessRemotes() != null && smd.getBusinessRemotes().size() > 0 || (businessInterface = ClassHelper.extractInterface((Class[])ejbImplementationClass.getInterfaces())) == null) continue;
            if (EJBLocalObject.class.isAssignableFrom(businessInterface)) {
                throw new IllegalStateException("EJB 3.0 Core Specification Violation (4.6.6): The session bean\u2019s business interface " + businessInterface + " must not extend the javax.ejb.EJBLocalObject interface.");
            }
            if (smd.getBusinessLocals() == null) {
                smd.setBusinessLocals(new BusinessLocalsMetaData());
            }
            smd.getBusinessLocals().add(businessInterface.getName());
        }
        return metadata;
    }

    public ClassLoader getCl() {
        return this.cl;
    }

    protected void setCl(ClassLoader cl) {
        this.cl = cl;
    }
}

