/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.mw.wst11.service;

import com.arjuna.mw.wst11.service.JaxBaseHeaderContextProcessor;
import com.arjuna.mw.wstx.logging.wstxLogger;
import jakarta.xml.soap.SOAPMessage;
import jakarta.xml.ws.handler.MessageContext;
import jakarta.xml.ws.handler.soap.SOAPHandler;
import jakarta.xml.ws.handler.soap.SOAPMessageContext;
import java.util.HashSet;
import java.util.Set;
import javax.xml.namespace.QName;

public class JaxWSHeaderContextProcessor
extends JaxBaseHeaderContextProcessor
implements SOAPHandler<SOAPMessageContext> {
    public boolean handleMessage(SOAPMessageContext msgContext) {
        Boolean outbound = (Boolean)msgContext.get((Object)"jakarta.xml.ws.handler.message.outbound");
        if (outbound == null) {
            throw new IllegalStateException("Cannot obtain required property: jakarta.xml.ws.handler.message.outbound");
        }
        return outbound != false ? this.handleOutbound(msgContext) : this.handleInbound(msgContext);
    }

    public boolean handleFault(SOAPMessageContext messageContext) {
        if (wstxLogger.logger.isTraceEnabled()) {
            wstxLogger.logger.trace((Object)"service/JaxWSHeaderContextProcessor.handleFault()");
            wstxLogger.traceMessage((SOAPMessageContext)messageContext);
        }
        this.suspendTransaction();
        return true;
    }

    public void close(MessageContext messageContext) {
    }

    public Set<QName> getHeaders() {
        HashSet<QName> headerSet = new HashSet<QName>();
        headerSet.add(new QName("http://docs.oasis-open.org/ws-tx/wscoor/2006/06", "CoordinationContext"));
        return headerSet;
    }

    public void setHeaders(Set headers) {
    }

    protected boolean handleInbound(SOAPMessageContext msgContext) {
        if (wstxLogger.logger.isTraceEnabled()) {
            wstxLogger.logger.trace((Object)"service/JaxWSHeaderContextProcessor.handleInbound()");
            wstxLogger.traceMessage((SOAPMessageContext)msgContext);
        }
        SOAPMessageContext soapMessageContext = msgContext;
        SOAPMessage soapMessage = soapMessageContext.getMessage();
        return this.handleInboundMessage(soapMessage);
    }

    protected boolean handleOutbound(SOAPMessageContext messageContext) {
        if (wstxLogger.logger.isTraceEnabled()) {
            wstxLogger.logger.trace((Object)"service/JaxWSHeaderContextProcessor.handleOutbound()");
            wstxLogger.traceMessage((SOAPMessageContext)messageContext);
        }
        this.suspendTransaction();
        return true;
    }
}

