/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.mw.wst11.service;

import com.arjuna.mw.wst.TxContext;
import com.arjuna.mw.wst.common.SOAPUtil;
import com.arjuna.mw.wst11.BusinessActivityManager;
import com.arjuna.mw.wst11.BusinessActivityManagerFactory;
import com.arjuna.mw.wst11.TransactionManager;
import com.arjuna.mw.wst11.TransactionManagerFactory;
import com.arjuna.mw.wst11.common.CoordinationContextHelper;
import com.arjuna.mw.wstx.logging.wstxLogger;
import com.arjuna.mwlabs.wst11.at.SubordinateImporter;
import com.arjuna.mwlabs.wst11.at.context.TxContextImple;
import jakarta.xml.soap.Name;
import jakarta.xml.soap.SOAPElement;
import jakarta.xml.soap.SOAPEnvelope;
import jakarta.xml.soap.SOAPException;
import jakarta.xml.soap.SOAPFactory;
import jakarta.xml.soap.SOAPHeader;
import jakarta.xml.soap.SOAPHeaderElement;
import jakarta.xml.soap.SOAPMessage;
import java.util.Iterator;
import org.oasis_open.docs.ws_tx.wscoor._2006._06.CoordinationContextType;
import org.w3c.dom.Element;

class JaxBaseHeaderContextProcessor {
    JaxBaseHeaderContextProcessor() {
    }

    protected boolean handleInboundMessage(SOAPMessage soapMessage) {
        return this.handleInboundMessage(soapMessage, false);
    }

    protected boolean handleInboundMessage(SOAPMessage soapMessage, boolean installSubordinateTx) {
        if (soapMessage != null) {
            try {
                SOAPEnvelope soapEnvelope = soapMessage.getSOAPPart().getEnvelope();
                SOAPHeader soapHeader = soapEnvelope.getHeader();
                SOAPHeaderElement soapHeaderElement = this.getHeaderElement(soapHeader, "http://docs.oasis-open.org/ws-tx/wscoor/2006/06", "CoordinationContext");
                if (soapHeaderElement != null) {
                    CoordinationContextType cc = CoordinationContextHelper.deserialise((Element)soapHeaderElement);
                    String coordinationType = cc.getCoordinationType();
                    if ("http://docs.oasis-open.org/ws-tx/wsat/2006/06".equals(coordinationType)) {
                        this.clearMustUnderstand(soapHeader, soapHeaderElement);
                        TxContext txContext = new TxContextImple(cc);
                        if (installSubordinateTx) {
                            txContext = SubordinateImporter.importContext(cc);
                        }
                        TransactionManagerFactory.transactionManager().resume(txContext);
                    } else if ("http://docs.oasis-open.org/ws-tx/wsba/2006/06/AtomicOutcome".equals(coordinationType)) {
                        this.clearMustUnderstand(soapHeader, soapHeaderElement);
                        TxContext txContext = new com.arjuna.mwlabs.wst11.ba.context.TxContextImple(cc);
                        if (installSubordinateTx) {
                            txContext = com.arjuna.mwlabs.wst11.ba.SubordinateImporter.importContext(cc);
                        }
                        BusinessActivityManagerFactory.businessActivityManager().resume(txContext);
                    } else {
                        wstxLogger.i18NLogger.warn_mw_wst11_service_JaxHC11P_2("com.arjuna.mw.wst11.service.JaxBaseHeaderContextProcessor.handleRequest(MessageContext context)", coordinationType);
                    }
                }
            }
            catch (Throwable th) {
                wstxLogger.i18NLogger.warn_mw_wst11_service_JaxHC11P_1("com.arjuna.mw.wst11.service.JaxBaseHeaderContextProcessor.handleRequest(MessageContext context)", th);
            }
        }
        return true;
    }

    protected void suspendTransaction() {
        try {
            TransactionManager transactionManager = TransactionManagerFactory.transactionManager();
            BusinessActivityManager businessActivityManager = BusinessActivityManagerFactory.businessActivityManager();
            if (transactionManager != null) {
                transactionManager.suspend();
            }
            if (businessActivityManager != null) {
                businessActivityManager.suspend();
            }
        }
        catch (Throwable th) {
            wstxLogger.i18NLogger.warn_mw_wst11_service_JaxHC11P_1("com.arjuna.mw.wst11.service.JaxBaseHeaderContextProcessor.suspendTransaction()", th);
        }
    }

    private void clearMustUnderstand(SOAPHeader soapHeader, SOAPHeaderElement soapHeaderElement) throws SOAPException {
        Name headerName = soapHeader.getElementName();
        SOAPFactory factory = SOAPFactory.newInstance();
        Name attributeName = factory.createName("mustUnderstand", headerName.getPrefix(), headerName.getURI());
        soapHeaderElement.removeAttribute(attributeName);
    }

    private SOAPHeaderElement getHeaderElement(SOAPHeader soapHeader, String uri, String name) throws SOAPException {
        if (soapHeader != null) {
            Iterator headerIter = SOAPUtil.getChildElements((SOAPElement)soapHeader);
            while (headerIter.hasNext()) {
                SOAPHeaderElement current = (SOAPHeaderElement)headerIter.next();
                Name currentName = current.getElementName();
                if (currentName == null || !this.match(name, currentName.getLocalName()) || !this.match(uri, currentName.getURI())) continue;
                return current;
            }
        }
        return null;
    }

    private boolean match(Object lhs, Object rhs) {
        if (lhs == null) {
            return rhs == null;
        }
        return lhs.equals(rhs);
    }
}

