/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.metadata.internal;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import org.jboss.osgi.metadata.Parameter;
import org.jboss.osgi.metadata.internal.CollectionValueCreator;
import org.jboss.osgi.metadata.internal.ValueCreator;
import org.jboss.osgi.metadata.internal.ValueCreatorUtil;
import org.osgi.framework.VersionRange;

public class OSGiParameters {
    static final Logger LOGGER = Logger.getLogger(OSGiParameters.class.getName());
    protected Map<String, Parameter> parameters;
    protected Map<String, Object> cachedAttributes;

    public OSGiParameters(Map<String, Parameter> parameters) {
        this.parameters = Collections.unmodifiableMap(parameters);
        this.cachedAttributes = new ConcurrentHashMap<String, Object>();
    }

    protected Map<String, Parameter> getParameters() {
        return this.parameters;
    }

    public VersionRange getVersion() {
        return this.get("version", ValueCreatorUtil.VERSION_RANGE_VC);
    }

    public String getBundleSymbolicName() {
        return this.get("bundle-symbolic-name", ValueCreatorUtil.STRING_VC);
    }

    public VersionRange getBundleVersion() {
        return this.get("bundle-version", ValueCreatorUtil.VERSION_RANGE_VC);
    }

    public String getVisibility() {
        return this.get("visibility", ValueCreatorUtil.STRING_VC, "private");
    }

    public String getResolution() {
        return this.get("resolution", ValueCreatorUtil.STRING_VC, "mandatory");
    }

    protected <T> T get(String key, ValueCreator<T> creator) {
        return this.get(key, creator, null);
    }

    protected <T> T get(String key, ValueCreator<T> creator, T defaultValue) {
        Object value = this.cachedAttributes.get(key);
        if (value == null) {
            Parameter parameter = this.parameters.get(key);
            if (parameter != null) {
                Object paramValue = parameter.getValue();
                if (parameter.isCollection()) {
                    if (creator instanceof CollectionValueCreator) {
                        CollectionValueCreator cvc = (CollectionValueCreator)creator;
                        value = cvc.createValue((Collection)paramValue);
                    } else {
                        LOGGER.warning("Cannot create value from " + creator + " for parameter: " + parameter);
                    }
                } else {
                    value = creator.createValue(paramValue.toString());
                }
            } else if (defaultValue != null) {
                value = defaultValue;
            }
            if (value != null) {
                this.cachedAttributes.put(key, value);
            }
        }
        return (T)value;
    }
}

