/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.resolver.spi;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.jboss.osgi.resolver.XCapability;
import org.jboss.osgi.resolver.XEnvironment;
import org.jboss.osgi.resolver.XHostRequirement;
import org.jboss.osgi.resolver.XIdentityCapability;
import org.jboss.osgi.resolver.XPackageCapability;
import org.jboss.osgi.resolver.XPackageRequirement;
import org.jboss.osgi.resolver.XRequirement;
import org.jboss.osgi.resolver.XResource;
import org.jboss.osgi.resolver.XWiring;
import org.jboss.osgi.resolver.internal.ResolverLogger;
import org.jboss.osgi.resolver.internal.ResolverMessages;
import org.jboss.osgi.resolver.spi.AbstractWiring;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;
import org.osgi.resource.Wire;
import org.osgi.resource.Wiring;

public class AbstractEnvironment
implements XEnvironment {
    private static final String[] ALL_IDENTITY_TYPES = new String[]{"osgi.bundle", "osgi.fragment", "unknown"};
    private final AtomicLong resourceIndex = new AtomicLong();
    private final Map<CacheKey, Set<Capability>> capabilityCache = new ConcurrentHashMap<CacheKey, Set<Capability>>();
    private final Map<String, Set<XResource>> resourceTypeCache = new ConcurrentHashMap<String, Set<XResource>>();
    private final Map<Long, XResource> resourceIndexCache = new ConcurrentHashMap<Long, XResource>();
    private final Map<Resource, Wiring> wirings = new HashMap<Resource, Wiring>();

    @Override
    public synchronized void installResources(XResource ... resources) {
        for (XResource res : resources) {
            XIdentityCapability icap = res.getIdentityCapability();
            if (this.getCachedCapabilities(CacheKey.create(icap)).contains(icap)) {
                throw ResolverMessages.MESSAGES.illegalStateResourceAlreadyInstalled(res);
            }
            ResolverLogger.LOGGER.debugf("Install resource: %s", res);
            Long index = this.resourceIndex.getAndIncrement();
            res.addAttachment(Long.class, index);
            this.resourceIndexCache.put(index, res);
            this.getCachedResources(icap.getType()).add(res);
            for (Capability cap : res.getCapabilities(null)) {
                this.getCachedCapabilities(CacheKey.create(cap)).add(cap);
                ResolverLogger.LOGGER.debugf("   %s", cap);
            }
            if (!ResolverLogger.LOGGER.isDebugEnabled()) continue;
            for (Requirement req : res.getRequirements(null)) {
                ResolverLogger.LOGGER.debugf("   %s", req);
            }
        }
    }

    @Override
    public synchronized void uninstallResources(XResource ... resources) {
        for (XResource res : resources) {
            Long index = res.getAttachment(Long.class);
            if (index == null || this.resourceIndexCache.remove(index) == null) {
                ResolverLogger.LOGGER.debugf("Unknown resource: %s", res);
                continue;
            }
            ResolverLogger.LOGGER.debugf("Uninstall resource: %s", res);
            XIdentityCapability icap = res.getIdentityCapability();
            this.getCachedResources(icap.getType()).remove(res);
            for (Capability cap : res.getCapabilities(null)) {
                CacheKey cachekey = CacheKey.create(cap);
                Set<Capability> capset = this.getCachedCapabilities(cachekey);
                capset.remove(cap);
                if (!capset.isEmpty()) continue;
                this.capabilityCache.remove(cachekey);
            }
            this.wirings.remove(res);
        }
    }

    @Override
    public void refreshResources(XResource ... resources) {
        for (XResource res : resources) {
            this.wirings.remove(res);
        }
    }

    @Override
    public synchronized Collection<XResource> getResources(Set<String> types) {
        HashSet<XResource> result = new HashSet<XResource>();
        for (String type : types != null ? types : Arrays.asList(ALL_IDENTITY_TYPES)) {
            result.addAll(this.getCachedResources(type));
        }
        return result;
    }

    @Override
    public synchronized List<Capability> findProviders(Requirement req) {
        CacheKey cachekey = CacheKey.create(req);
        ArrayList<Capability> result = new ArrayList<Capability>();
        for (Capability cap : this.getCachedCapabilities(cachekey)) {
            if (!((XRequirement)req).matches((XCapability)cap)) continue;
            boolean ignoreCapability = false;
            XResource res = (XResource)cap.getResource();
            Wiring wiring = this.getWirings().get(res);
            if (wiring != null && cap instanceof XPackageCapability) {
                String pkgname = ((XPackageCapability)cap).getPackageName();
                for (Wire wire : wiring.getRequiredResourceWires(cap.getNamespace())) {
                    XPackageRequirement wirereq = (XPackageRequirement)wire.getRequirement();
                    if (!pkgname.equals(wirereq.getPackageName())) continue;
                    ignoreCapability = true;
                    break;
                }
            }
            List<Requirement> hostreqs = res.getRequirements("osgi.wiring.host");
            if (wiring == null && !hostreqs.isEmpty()) {
                XHostRequirement hostreq = (XHostRequirement)hostreqs.get(0);
                boolean unresolvedHost = false;
                for (Capability hostcap : this.capabilityCache.get(CacheKey.create(hostreq))) {
                    if (!hostreq.matches((XCapability)hostcap)) continue;
                    Resource host = hostcap.getResource();
                    if (this.getWirings().get(host) != null) continue;
                    unresolvedHost = true;
                    break;
                }
                boolean bl = ignoreCapability = !unresolvedHost;
            }
            if (ignoreCapability) continue;
            result.add(cap);
        }
        ResolverLogger.LOGGER.tracef("findProviders: %s => %s", req, result);
        return result;
    }

    @Override
    public synchronized Map<Resource, Wiring> updateWiring(Map<Resource, List<Wire>> wiremap) {
        HashMap<Resource, XWiring> result = new HashMap<Resource, XWiring>();
        for (Map.Entry<Resource, List<Wire>> entry : wiremap.entrySet()) {
            Resource res = entry.getKey();
            List<Wire> wires = entry.getValue();
            XWiring reswiring = (XWiring)this.wirings.get(res);
            if (reswiring == null) {
                reswiring = (XWiring)this.createWiring(res, wires);
                this.wirings.put(res, reswiring);
            }
            for (Wire wire : wires) {
                XResource provider = (XResource)wire.getProvider();
                XWiring provwiring = (XWiring)this.wirings.get(provider);
                if (provwiring == null) {
                    provwiring = (XWiring)this.createWiring(provider, null);
                    this.wirings.put(provider, provwiring);
                }
                ((AbstractWiring)provwiring).addProvidedWire(wire);
            }
            result.put(res, reswiring);
        }
        return Collections.unmodifiableMap(result);
    }

    protected Wiring createWiring(Resource res, List<Wire> wires) {
        return new AbstractWiring(res, wires);
    }

    @Override
    public Long getResourceIndex(XResource res) {
        return res.getAttachment(Long.class);
    }

    @Override
    public synchronized Map<Resource, Wiring> getWirings() {
        return Collections.unmodifiableMap(this.wirings);
    }

    private synchronized Set<Capability> getCachedCapabilities(CacheKey key) {
        Set<Capability> capset = this.capabilityCache.get(key);
        if (capset == null) {
            capset = new LinkedHashSet<Capability>();
            this.capabilityCache.put(key, capset);
        }
        return capset;
    }

    private synchronized Set<XResource> getCachedResources(String type) {
        Set<XResource> typeset = this.resourceTypeCache.get(type);
        if (typeset == null) {
            typeset = new LinkedHashSet<XResource>();
            this.resourceTypeCache.put(type, typeset);
        }
        return typeset;
    }

    private static class CacheKey {
        private final String key;

        static CacheKey create(Capability cap) {
            String namespace = cap.getNamespace();
            return new CacheKey(namespace, (String)cap.getAttributes().get(namespace));
        }

        static CacheKey create(Requirement req) {
            String namespace = req.getNamespace();
            return new CacheKey(namespace, (String)req.getAttributes().get(namespace));
        }

        private CacheKey(String namespace, String value) {
            this.key = namespace + ":" + value;
        }

        public int hashCode() {
            return this.key.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CacheKey other = (CacheKey)obj;
            return this.key.equals(other.key);
        }

        public String toString() {
            return "[" + this.key + "]";
        }
    }
}

