/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.resolver.spi;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.osgi.metadata.OSGiMetaData;
import org.jboss.osgi.metadata.PackageAttribute;
import org.jboss.osgi.metadata.Parameter;
import org.jboss.osgi.metadata.ParameterizedAttribute;
import org.jboss.osgi.resolver.ResourceBuilderException;
import org.jboss.osgi.resolver.XBundleCapability;
import org.jboss.osgi.resolver.XBundleRequirement;
import org.jboss.osgi.resolver.XCapability;
import org.jboss.osgi.resolver.XHostCapability;
import org.jboss.osgi.resolver.XHostRequirement;
import org.jboss.osgi.resolver.XIdentityCapability;
import org.jboss.osgi.resolver.XPackageCapability;
import org.jboss.osgi.resolver.XPackageRequirement;
import org.jboss.osgi.resolver.XRequirement;
import org.jboss.osgi.resolver.XResource;
import org.jboss.osgi.resolver.XResourceBuilder;
import org.jboss.osgi.resolver.XResourceBuilderFactory;
import org.jboss.osgi.resolver.internal.ResolverMessages;
import org.jboss.osgi.resolver.spi.AbstractBundleCapability;
import org.jboss.osgi.resolver.spi.AbstractBundleRequirement;
import org.jboss.osgi.resolver.spi.AbstractCapability;
import org.jboss.osgi.resolver.spi.AbstractHostCapability;
import org.jboss.osgi.resolver.spi.AbstractHostRequirement;
import org.jboss.osgi.resolver.spi.AbstractIdentityCapability;
import org.jboss.osgi.resolver.spi.AbstractPackageCapability;
import org.jboss.osgi.resolver.spi.AbstractPackageRequirement;
import org.jboss.osgi.resolver.spi.AbstractRequirement;
import org.jboss.osgi.resolver.spi.AbstractResource;
import org.osgi.framework.Version;

public class AbstractResourceBuilder
implements XResourceBuilder {
    private final XResource resource;

    public AbstractResourceBuilder(XResourceBuilderFactory factory) {
        this.resource = factory.createResource();
    }

    @Override
    public XIdentityCapability addIdentityCapability(String symbolicName, Version version, String type, Map<String, Object> atts, Map<String, String> dirs) {
        this.assertResourceCreated();
        atts = this.mutableAttributes(atts);
        dirs = this.mutableDirectives(dirs);
        atts.put("osgi.identity", symbolicName);
        atts.put("version", version != null ? version : Version.emptyVersion);
        atts.put("type", type != null ? type : "unknown");
        AbstractIdentityCapability cap = new AbstractIdentityCapability(this.resource, atts, dirs);
        this.addCapability(cap);
        return cap;
    }

    @Override
    public XBundleRequirement addBundleRequirement(String symbolicName, Map<String, Object> atts, Map<String, String> dirs) {
        this.assertResourceCreated();
        atts = this.mutableAttributes(atts);
        dirs = this.mutableDirectives(dirs);
        atts.put("osgi.wiring.bundle", symbolicName);
        AbstractBundleRequirement req = new AbstractBundleRequirement(this.resource, atts, dirs);
        this.addRequirement(req);
        return req;
    }

    @Override
    public XBundleCapability addBundleCapability(String symbolicName, Version version, Map<String, Object> atts, Map<String, String> dirs) {
        this.assertResourceCreated();
        atts = this.mutableAttributes(atts);
        dirs = this.mutableDirectives(dirs);
        atts.put("osgi.wiring.bundle", symbolicName);
        atts.put("bundle-version", version != null ? version : Version.emptyVersion);
        AbstractBundleCapability cap = new AbstractBundleCapability(this.resource, atts, dirs);
        this.addCapability(cap);
        return cap;
    }

    @Override
    public XHostCapability addHostCapability(String symbolicName, Version version, Map<String, Object> atts, Map<String, String> dirs) {
        this.assertResourceCreated();
        atts = this.mutableAttributes(atts);
        dirs = this.mutableDirectives(dirs);
        atts.put("osgi.wiring.host", symbolicName);
        atts.put("bundle-version", version != null ? version : Version.emptyVersion);
        AbstractHostCapability cap = new AbstractHostCapability(this.resource, atts, dirs);
        this.addCapability(cap);
        return cap;
    }

    @Override
    public XHostRequirement addHostRequirement(String symbolicName, Map<String, Object> atts, Map<String, String> dirs) {
        this.assertResourceCreated();
        atts = this.mutableAttributes(atts);
        dirs = this.mutableDirectives(dirs);
        atts.put("osgi.wiring.host", symbolicName);
        AbstractHostRequirement req = new AbstractHostRequirement(this.resource, atts, dirs);
        this.addRequirement(req);
        return req;
    }

    @Override
    public XPackageCapability addPackageCapability(String packageName, Map<String, Object> atts, Map<String, String> dirs) {
        this.assertResourceCreated();
        atts = this.mutableAttributes(atts);
        dirs = this.mutableDirectives(dirs);
        atts.put("osgi.wiring.package", packageName);
        AbstractPackageCapability cap = new AbstractPackageCapability(this.resource, atts, dirs);
        this.addCapability(cap);
        return cap;
    }

    @Override
    public XPackageRequirement addPackageRequirement(String packageName, Map<String, Object> atts, Map<String, String> dirs) {
        this.assertResourceCreated();
        atts = this.mutableAttributes(atts);
        dirs = this.mutableDirectives(dirs);
        atts.put("osgi.wiring.package", packageName);
        AbstractPackageRequirement req = new AbstractPackageRequirement(this.resource, atts, dirs);
        this.addRequirement(req);
        return req;
    }

    @Override
    public XPackageRequirement addDynamicPackageRequirement(String packageName, Map<String, Object> atts, Map<String, String> dirs) {
        this.assertResourceCreated();
        atts = this.mutableAttributes(atts);
        dirs = this.mutableDirectives(dirs);
        atts.put("osgi.wiring.package", packageName);
        dirs.put("resolution", "dynamic");
        AbstractPackageRequirement req = new AbstractPackageRequirement(this.resource, atts, dirs);
        this.addRequirement(req);
        return req;
    }

    @Override
    public XCapability addGenericCapability(String namespace, Map<String, Object> atts, Map<String, String> dirs) {
        this.assertResourceCreated();
        atts = this.mutableAttributes(atts);
        dirs = this.mutableDirectives(dirs);
        AbstractCapability cap = "osgi.identity".equals(namespace) ? new AbstractIdentityCapability(this.resource, atts, dirs) : ("osgi.wiring.package".equals(namespace) ? new AbstractPackageCapability(this.resource, atts, dirs) : ("osgi.wiring.host".equals(namespace) ? new AbstractHostCapability(this.resource, atts, dirs) : new AbstractCapability(this.resource, namespace, atts, dirs)));
        this.addCapability(cap);
        return cap;
    }

    @Override
    public XRequirement addGenericRequirement(String namespace, Map<String, Object> atts, Map<String, String> dirs) {
        this.assertResourceCreated();
        atts = this.mutableAttributes(atts);
        dirs = this.mutableDirectives(dirs);
        AbstractRequirement req = "osgi.identity".equals(namespace) ? new AbstractBundleRequirement(this.resource, atts, dirs) : ("osgi.wiring.package".equals(namespace) ? new AbstractPackageRequirement(this.resource, atts, dirs) : ("osgi.wiring.host".equals(namespace) ? new AbstractHostRequirement(this.resource, atts, dirs) : new AbstractRequirement(this.resource, namespace, atts, dirs)));
        this.addRequirement(req);
        return req;
    }

    @Override
    public XResourceBuilder loadFrom(OSGiMetaData metadata) throws ResourceBuilderException {
        this.assertResourceCreated();
        try {
            List dynamicImports;
            List imports;
            List exports;
            Map<String, String> dirs;
            Map<String, Object> atts;
            ParameterizedAttribute fragmentHost;
            String symbolicName = metadata.getBundleSymbolicName();
            Version bundleVersion = metadata.getBundleVersion();
            ParameterizedAttribute idparams = metadata.getBundleParameters();
            Map<String, Object> idatts = this.getAttributes(idparams);
            Map<String, String> iddirs = this.getDirectives(idparams);
            if (symbolicName == null) {
                symbolicName = "anonymous-bundle-symbolic-name";
            }
            String identityType = (fragmentHost = metadata.getFragmentHost()) != null ? "osgi.fragment" : "osgi.bundle";
            this.addIdentityCapability(symbolicName, bundleVersion, identityType, idatts, iddirs);
            if ("osgi.bundle".equals(identityType)) {
                atts = this.getAttributes(idparams);
                dirs = this.getDirectives(idparams);
                this.addBundleCapability(symbolicName, bundleVersion, atts, dirs);
            }
            if (fragmentHost != null) {
                String hostName = fragmentHost.getAttribute();
                Map<String, Object> atts2 = this.getAttributes(fragmentHost);
                Map<String, String> dirs2 = this.getDirectives(fragmentHost);
                this.addHostRequirement(hostName, atts2, dirs2);
            } else if (!"system.bundle".equals(symbolicName)) {
                atts = this.getAttributes(idparams);
                dirs = this.getDirectives(idparams);
                this.addHostCapability(symbolicName, bundleVersion, atts, dirs);
            }
            List requireBundles = metadata.getRequireBundles();
            if (requireBundles != null && !requireBundles.isEmpty()) {
                for (ParameterizedAttribute attr : requireBundles) {
                    String name = attr.getAttribute();
                    Map<String, Object> atts3 = this.getAttributes(attr);
                    Map<String, String> dirs3 = this.getDirectives(attr);
                    this.addBundleRequirement(name, atts3, dirs3);
                }
            }
            if ((exports = metadata.getExportPackages()) != null && !exports.isEmpty()) {
                for (PackageAttribute attr : exports) {
                    String name = attr.getAttribute();
                    Map<String, Object> atts4 = this.getAttributes((ParameterizedAttribute)attr);
                    Map<String, String> dirs4 = this.getDirectives((ParameterizedAttribute)attr);
                    this.addPackageCapability(name, atts4, dirs4);
                }
            }
            if ((imports = metadata.getImportPackages()) != null && !imports.isEmpty()) {
                for (PackageAttribute attr : imports) {
                    String name = attr.getAttribute();
                    Map<String, Object> atts5 = this.getAttributes((ParameterizedAttribute)attr);
                    Map<String, String> dirs5 = this.getDirectives((ParameterizedAttribute)attr);
                    this.addPackageRequirement(name, atts5, dirs5);
                }
            }
            if ((dynamicImports = metadata.getDynamicImports()) != null && !dynamicImports.isEmpty()) {
                for (PackageAttribute attr : dynamicImports) {
                    String name = attr.getAttribute();
                    Map<String, Object> atts6 = this.getAttributes((ParameterizedAttribute)attr);
                    Map<String, String> dirs6 = this.getDirectives((ParameterizedAttribute)attr);
                    this.addDynamicPackageRequirement(name, atts6, dirs6);
                }
            }
        }
        catch (RuntimeException ex) {
            String cachedAttributes = metadata.getCachedAttributes().toString();
            throw ResolverMessages.MESSAGES.resourceBuilderCannotInitializeResource(ex, cachedAttributes);
        }
        return this;
    }

    @Override
    public XResourceBuilder loadFrom(Module module) throws ResourceBuilderException {
        Version version;
        this.assertResourceCreated();
        ModuleIdentifier identifier = module.getIdentifier();
        String symbolicName = identifier.getName();
        try {
            version = Version.parseVersion((String)identifier.getSlot());
        }
        catch (IllegalArgumentException ex) {
            version = Version.emptyVersion;
        }
        this.addIdentityCapability(symbolicName, version, "unknown", null, null);
        this.resource.addAttachment(Module.class, module);
        for (String path : module.getExportedPaths()) {
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            if (path.endsWith("/")) {
                path = path.substring(0, path.length() - 1);
            }
            if (path.isEmpty() || path.startsWith("META-INF")) continue;
            String packageName = path.replace('/', '.');
            this.addPackageCapability(packageName, null, null);
        }
        return this;
    }

    @Override
    public XResource getResource() {
        return this.resource;
    }

    private void addCapability(XCapability cap) {
        if (this.resource instanceof AbstractResource) {
            ((AbstractResource)this.resource).addCapability(cap);
        }
    }

    private void addRequirement(XRequirement req) {
        if (this.resource instanceof AbstractResource) {
            ((AbstractResource)this.resource).addRequirement(req);
        }
    }

    private Map<String, Object> getAttributes(ParameterizedAttribute patts) {
        HashMap<String, Object> atts = new HashMap<String, Object>();
        if (patts != null) {
            for (String key : patts.getAttributes().keySet()) {
                Parameter param = patts.getAttribute(key);
                atts.put(key.trim(), param.getValue().toString().trim());
            }
        }
        return atts;
    }

    private Map<String, String> getDirectives(ParameterizedAttribute patts) {
        HashMap<String, String> dirs = new HashMap<String, String>();
        if (patts != null) {
            for (String key : patts.getDirectives().keySet()) {
                String value = (String)patts.getDirectiveValue(key, String.class);
                dirs.put(key.trim(), value.trim());
            }
        }
        return dirs;
    }

    private Map<String, Object> mutableAttributes(Map<String, Object> atts) {
        return new HashMap<String, Object>(atts != null ? atts : EMPTY_ATTRIBUTES);
    }

    private Map<String, String> mutableDirectives(Map<String, String> dirs) {
        return new HashMap<String, String>(dirs != null ? dirs : EMPTY_DIRECTIVES);
    }

    private void assertResourceCreated() {
        if (this.resource == null) {
            throw ResolverMessages.MESSAGES.illegalStateResourceNotCreated();
        }
    }
}

