/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.resolver.spi;

import java.util.Map;
import org.jboss.osgi.resolver.XBundleCapability;
import org.jboss.osgi.resolver.XEnvironment;
import org.jboss.osgi.resolver.XPackageCapability;
import org.jboss.osgi.resolver.spi.ResourceIndexComparator;
import org.osgi.framework.Version;
import org.osgi.resource.Capability;
import org.osgi.resource.Resource;
import org.osgi.resource.Wiring;

class FrameworkPreferencesComparator
extends ResourceIndexComparator {
    public FrameworkPreferencesComparator(XEnvironment environment) {
        super(environment);
    }

    @Override
    public int compare(Capability o1, Capability o2) {
        Version v2;
        Version v1;
        Resource res1 = o1.getResource();
        Resource res2 = o2.getResource();
        Long in1 = this.getResourceIndex(o1.getResource());
        Long in2 = this.getResourceIndex(o2.getResource());
        if (in1 == 0L || in2 == 0L) {
            return (int)(in1 - in2);
        }
        Map<Resource, Wiring> wirings = this.getEnvironment().getWirings();
        Wiring w1 = wirings.get(res1);
        Wiring w2 = wirings.get(res2);
        if (w1 != null && w2 == null) {
            return -1;
        }
        if (w1 == null && w2 != null) {
            return 1;
        }
        if (o1 instanceof XPackageCapability && o2 instanceof XPackageCapability && !(v1 = ((XPackageCapability)o1).getVersion()).equals((Object)(v2 = ((XPackageCapability)o2).getVersion()))) {
            return v2.compareTo((Object)v1);
        }
        if (o1 instanceof XBundleCapability && o2 instanceof XBundleCapability && !(v1 = ((XBundleCapability)o1).getVersion()).equals((Object)(v2 = ((XBundleCapability)o2).getVersion()))) {
            return v2.compareTo((Object)v1);
        }
        return in1.compareTo(in2);
    }
}

