/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.resolver.spi;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.jboss.osgi.resolver.ResolverLogger;
import org.jboss.osgi.resolver.XEnvironment;
import org.jboss.osgi.resolver.XResolveContext;
import org.jboss.osgi.resolver.spi.FrameworkPreferencesComparator;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;
import org.osgi.resource.Wiring;
import org.osgi.service.resolver.HostedCapability;

public class AbstractResolveContext
extends XResolveContext {
    private final XEnvironment environment;

    public AbstractResolveContext(XEnvironment environment) {
        this.environment = environment;
    }

    protected Comparator<Capability> getComparator() {
        return new FrameworkPreferencesComparator(this.environment);
    }

    @Override
    public XEnvironment getEnvironment() {
        return this.environment;
    }

    @Override
    public List<Capability> findProviders(Requirement req) {
        List<Capability> providers = this.environment.findProviders(req);
        Collections.sort(providers, this.getComparator());
        ResolverLogger.LOGGER.tracef("Ctx provides: %s => %s", req, providers);
        return providers;
    }

    @Override
    public int insertHostedCapability(List<Capability> caps, HostedCapability hostedCapability) {
        caps.add(hostedCapability);
        Collections.sort(caps, this.getComparator());
        ResolverLogger.LOGGER.tracef("Insert hosted capability: %s => %s", hostedCapability, caps);
        return caps.indexOf(hostedCapability);
    }

    @Override
    public boolean isEffective(Requirement requirement) {
        return true;
    }

    @Override
    public Map<Resource, Wiring> getWirings() {
        return this.environment.getWirings();
    }
}

