/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.resolver.spi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jboss.osgi.resolver.ResolverMessages;
import org.jboss.osgi.resolver.XCapability;
import org.jboss.osgi.resolver.XResource;
import org.jboss.osgi.resolver.spi.AbstractHostedCapability;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;
import org.osgi.resource.Wire;
import org.osgi.resource.Wiring;
import org.osgi.service.resolver.HostedCapability;

public class AbstractWiring
implements Wiring {
    private final XResource resource;
    private final List<Wire> required;
    private final List<Wire> provided;

    public AbstractWiring(XResource resource, List<Wire> required, List<Wire> provided) {
        if (resource == null) {
            throw ResolverMessages.MESSAGES.illegalArgumentNull("resource");
        }
        this.resource = resource;
        List emptywires = Collections.emptyList();
        this.required = required != null ? required : emptywires;
        this.provided = provided != null ? provided : emptywires;
    }

    @Override
    public List<Capability> getResourceCapabilities(String namespace) {
        ArrayList<Capability> caps = new ArrayList<Capability>(this.resource.getCapabilities(namespace));
        for (Wire wire : this.getProvidedResourceWires("osgi.wiring.host")) {
            for (Capability cap : wire.getRequirer().getCapabilities(null)) {
                if ("osgi.identity".equals(cap.getNamespace()) || namespace != null && !namespace.equals(cap.getNamespace())) continue;
                caps.add(this.getHostedCapability((XCapability)cap));
            }
        }
        Iterator capit = caps.iterator();
        while (capit.hasNext()) {
            Capability cap = (Capability)capit.next();
            String effdir = cap.getDirectives().get("effective");
            if (effdir != null && !effdir.equals("resolve")) {
                capit.remove();
            }
            String capns = cap.getNamespace();
            Object capval = cap.getAttributes().get(capns);
            for (Wire wire : this.required) {
                Capability wirecap = wire.getCapability();
                Object wirecapval = wirecap.getAttributes().get(wirecap.getNamespace());
                if (!capns.equals(wirecap.getNamespace()) || !capval.equals(wirecapval)) continue;
                capit.remove();
            }
        }
        return caps;
    }

    protected HostedCapability getHostedCapability(XCapability cap) {
        return new AbstractHostedCapability(this.resource, cap);
    }

    @Override
    public List<Requirement> getResourceRequirements(String namespace) {
        ArrayList<Requirement> reqs = new ArrayList<Requirement>(this.resource.getRequirements(namespace));
        Iterator reqit = reqs.iterator();
        while (reqit.hasNext()) {
            String resdir;
            Requirement req = (Requirement)reqit.next();
            String effdir = req.getDirectives().get("effective");
            if (effdir != null && !"resolve".equals(effdir)) {
                reqit.remove();
            }
            if (!"optional".equals(resdir = req.getDirectives().get("resolution"))) continue;
            String reqns = req.getNamespace();
            Object reqval = req.getAttributes().get(reqns);
            boolean packageWireFound = false;
            for (Wire wire : this.required) {
                Capability wirecap = wire.getCapability();
                Object wirecapval = wirecap.getAttributes().get(wirecap.getNamespace());
                if (!reqns.equals(wirecap.getNamespace()) || !reqval.equals(wirecapval)) continue;
                packageWireFound = true;
                break;
            }
            if (packageWireFound) continue;
            reqit.remove();
        }
        return reqs;
    }

    @Override
    public List<Wire> getProvidedResourceWires(String namespace) {
        ArrayList<Wire> result = new ArrayList<Wire>();
        for (Wire wire : this.provided) {
            Capability cap = wire.getCapability();
            if (namespace != null && !namespace.equals(cap.getNamespace())) continue;
            result.add(wire);
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public List<Wire> getRequiredResourceWires(String namespace) {
        ArrayList<Wire> result = new ArrayList<Wire>();
        for (Wire wire : this.required) {
            Requirement req = wire.getRequirement();
            if (namespace != null && !namespace.equals(req.getNamespace())) continue;
            result.add(wire);
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public Resource getResource() {
        return this.resource;
    }

    public String toString() {
        return "Wiring[" + this.resource + "]";
    }
}

