/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.resolver.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.felix.resolver.FelixResolveContext;
import org.apache.felix.resolver.impl.HostedCapability;
import org.apache.felix.resolver.impl.HostedRequirement;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;

class HostResource
implements Resource {
    private final FelixResolveContext m_env;
    private final Resource m_host;
    private final List<Resource> m_fragments;
    private List<Capability> m_cachedCapabilities = null;
    private List<Requirement> m_cachedRequirements = null;

    public HostResource(FelixResolveContext env, Resource host, List<Resource> fragments) {
        this.m_env = env;
        this.m_host = host;
        this.m_fragments = fragments;
    }

    public Resource getHost() {
        return this.m_host;
    }

    public List<Resource> getFragments() {
        return this.m_fragments;
    }

    public List<Capability> getCapabilities(String namespace) {
        if (this.m_cachedCapabilities == null) {
            ArrayList<HostedCapability> caps = new ArrayList<HostedCapability>();
            for (Capability cap : this.m_host.getCapabilities(null)) {
                caps.add(new HostedCapability(this, cap));
            }
            if (this.m_fragments != null) {
                for (Resource fragment : this.m_fragments) {
                    for (Capability cap : fragment.getCapabilities(null)) {
                        caps.add(new HostedCapability(this, cap));
                    }
                }
            }
            this.m_cachedCapabilities = Collections.unmodifiableList(caps);
        }
        return this.m_cachedCapabilities;
    }

    public List<Requirement> getRequirements(String namespace) {
        if (this.m_cachedRequirements == null) {
            ArrayList<HostedRequirement> reqs = new ArrayList<HostedRequirement>();
            for (Requirement req : this.m_host.getRequirements(null)) {
                reqs.add(new HostedRequirement(this.m_env, this, req));
            }
            if (this.m_fragments != null) {
                for (Resource fragment : this.m_fragments) {
                    for (Requirement req : fragment.getRequirements(null)) {
                        if (req.getNamespace().equals("osgi.wiring.host")) continue;
                        reqs.add(new HostedRequirement(this.m_env, this, req));
                    }
                }
            }
            this.m_cachedRequirements = Collections.unmodifiableList(reqs);
        }
        return this.m_cachedRequirements;
    }

    public String toString() {
        return this.m_host.toString();
    }
}

