/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portletbridge.richfaces.context;

import java.io.File;
import javax.faces.FacesException;
import javax.faces.FacesWrapper;
import javax.faces.context.FacesContext;
import javax.faces.context.FacesContextFactory;
import javax.faces.context.FacesContextWrapper;
import javax.faces.lifecycle.Lifecycle;
import javax.portlet.ClientDataRequest;
import javax.portlet.PortletContext;
import javax.portlet.PortletRequest;
import javax.portlet.ResourceRequest;
import javax.servlet.http.HttpServletRequest;
import org.jboss.portletbridge.richfaces.request.HttpServletRequestAdapter;
import org.jboss.portletbridge.richfaces.request.MultipartResourceRequest25;
import org.jboss.portletbridge.richfaces.request.MultipartResourceRequestSizeExceeded;
import org.richfaces.request.MultipartRequest;
import org.richfaces.request.MultipartRequestParser;
import org.richfaces.request.ProgressControl;

public class FileUploadFacesContextFactory
extends FacesContextFactory
implements FacesWrapper<FacesContextFactory> {
    private FacesContextFactory wrappedFactory;

    public FileUploadFacesContextFactory(FacesContextFactory wrappedFactory) {
        this.wrappedFactory = wrappedFactory;
    }

    public FacesContextFactory getWrapped() {
        return this.wrappedFactory;
    }

    public FacesContext getFacesContext(Object context, Object request, Object response, Lifecycle lifecycle) throws FacesException {
        String uid;
        ClientDataRequest clientRequest;
        if (request instanceof ClientDataRequest && null != (clientRequest = (ClientDataRequest)request).getContentType() && clientRequest.getContentType().startsWith("multipart/") && null != (uid = clientRequest.getParameter("rf_fu_uid"))) {
            long contentLength = clientRequest.getContentLength();
            ProgressControl progressControl = new ProgressControl(uid, contentLength);
            HttpServletRequest wrappedRequest = this.wrapMultipartRequestServlet25((PortletContext)context, clientRequest, uid, contentLength, progressControl);
            FacesContext facesContext = this.wrappedFactory.getFacesContext(context, (Object)wrappedRequest, response, lifecycle);
            progressControl.setContextMap(facesContext.getExternalContext().getSessionMap());
            return new FileUploadFacesContext(facesContext);
        }
        return this.wrappedFactory.getFacesContext(context, request, response, lifecycle);
    }

    private HttpServletRequest wrapMultipartRequestServlet25(PortletContext portletContext, ClientDataRequest request, String uploadId, long contentLength, ProgressControl progressControl) {
        MultipartResourceRequestSizeExceeded multipartRequest;
        HttpServletRequestAdapter adapter = new HttpServletRequestAdapter((PortletRequest)request);
        long maxRequestSize = this.getMaxRequestSize(portletContext);
        if (maxRequestSize == 0L || contentLength <= maxRequestSize) {
            boolean createTempFiles = this.isCreateTempFiles(portletContext);
            String tempFilesDirectory = this.getTempFilesDirectory(portletContext);
            MultipartRequestParser requestParser = new MultipartRequestParser((HttpServletRequest)adapter, createTempFiles, tempFilesDirectory, progressControl);
            multipartRequest = new MultipartResourceRequest25((ResourceRequest)request, adapter, uploadId, progressControl, requestParser);
        } else {
            multipartRequest = new MultipartResourceRequestSizeExceeded((ResourceRequest)request, adapter, uploadId, progressControl);
        }
        request.setAttribute(MultipartRequest.REQUEST_ATTRIBUTE_NAME, (Object)multipartRequest);
        return multipartRequest;
    }

    private long getMaxRequestSize(PortletContext portletContext) {
        String param = portletContext.getInitParameter("org.richfaces.fileUpload.maxRequestSize");
        if (param != null) {
            return Long.parseLong(param);
        }
        return 0L;
    }

    private boolean isCreateTempFiles(PortletContext portletContext) {
        String param = portletContext.getInitParameter("org.richfaces.fileUpload.createTempFiles");
        if (param != null) {
            return Boolean.parseBoolean(param);
        }
        return true;
    }

    private String getTempFilesDirectory(PortletContext portletContext) {
        File servletTempDir;
        String result = portletContext.getInitParameter("org.richfaces.fileUpload.tempFilesDirectory");
        if (result == null && (servletTempDir = (File)portletContext.getAttribute("javax.servlet.context.tempdir")) != null) {
            result = servletTempDir.getAbsolutePath();
        }
        if (result == null) {
            result = new File(System.getProperty("java.io.tmpdir")).getAbsolutePath();
        }
        return result;
    }

    private static final class FileUploadFacesContext
    extends FacesContextWrapper {
        private FacesContext wrappedContext;

        public FileUploadFacesContext(FacesContext facesContext) {
            this.wrappedContext = facesContext;
        }

        public FacesContext getWrapped() {
            return this.wrappedContext;
        }

        public void release() {
            MultipartRequest multipartRequest = (MultipartRequest)this.getExternalContext().getRequestMap().get(MultipartRequest.REQUEST_ATTRIBUTE_NAME);
            if (multipartRequest != null) {
                multipartRequest.release();
            }
            super.release();
        }
    }
}

