/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portletbridge;

import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELContext;
import javax.el.ELContextEvent;
import javax.el.ExpressionFactory;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.application.Application;
import javax.faces.application.ApplicationFactory;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.context.FacesContextFactory;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.lifecycle.LifecycleFactory;
import javax.faces.render.RenderKitFactory;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.Event;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletMode;
import javax.portlet.PortletModeException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletResponse;
import javax.portlet.PortletSession;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.portlet.StateAwareResponse;
import javax.portlet.WindowState;
import javax.portlet.WindowStateException;
import javax.portlet.faces.Bridge;
import javax.portlet.faces.BridgeEventHandler;
import javax.portlet.faces.BridgeException;
import javax.portlet.faces.BridgePublicRenderParameterHandler;
import javax.portlet.faces.event.EventNavigationResult;
import org.jboss.portletbridge.BridgeConfig;
import org.jboss.portletbridge.BridgeRequestScope;
import org.jboss.portletbridge.BridgeStrategy;
import org.jboss.portletbridge.ExceptionHandler;
import org.jboss.portletbridge.ExceptionHandlerImpl;
import org.jboss.portletbridge.ExcludedRequestAttribute;
import org.jboss.portletbridge.RequestScopeManager;
import org.jboss.portletbridge.StateId;
import org.jboss.portletbridge.context.InitFacesContext;
import org.jboss.portletbridge.context.PortalActionURL;
import org.jboss.portletbridge.context.PortletBridgeContext;
import org.jboss.portletbridge.util.BridgeLogger;
import org.jboss.portletbridge.util.FacesConfig;
import org.jboss.portletbridge.util.WebXML;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AjaxPortletBridge
implements Bridge,
BridgeConfig {
    public static final String VIEWID_HISTORY_PREFIX = "javax.portlet.faces.viewIdHistory.";
    private static final Logger log = BridgeLogger.BRIDGE.getLogger();
    private static final String EXCEPTION_HANDLER_CLASS_PARAMETER = ExceptionHandler.class.getName();
    public static final String AJAX_NAMESPACE_PARAMETER = "org.ajax4jsf.portlet.NAMESPACE";
    public static final String VIEW_ID_PARAMETERS = "org.jboss.portletbridge.VIEW_ID_PARAMETERS";
    private boolean initialized = false;
    private PortletConfig portletConfig;
    private ExceptionHandler exceptionHandler;
    private Lifecycle lifecycle;
    private FacesContextFactory facesContextFactory;
    private List<String> facesServletMappings;
    Map<String, Map<String, String>> filterInitParams;
    private Set<ExcludedRequestAttribute> excludedAttributes;
    private boolean preserveActionParams;
    private int numberOfRequestScopes = 1000;
    private Map<String, String> defaultViewIdMap;
    private Map<Class<? extends Throwable>, String> errorPages;
    private Application application;
    private BridgeEventHandler eventHandler;
    private BridgePublicRenderParameterHandler publicParameterHandler;
    private BridgeStrategy strategy;
    private Map<String, String> publicParameterMapping;

    public void destroy() {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Destroy portletbridge " + this.getPortletConfig().getPortletName());
        }
        this.lifecycle = null;
        this.facesContextFactory = null;
        this.application = null;
        this.initialized = false;
    }

    public void init(PortletConfig config) throws BridgeException {
        String maxScopesParameter;
        if (null == config) {
            throw new NullPointerException("No PortletConfig at the bridge initialization");
        }
        if (this.initialized) {
            throw new BridgeException("JSF portlet bridge already initialized");
        }
        String portletName = config.getPortletName();
        if (log.isLoggable(Level.FINE)) {
            log.fine("Start portletbridge initialization for " + portletName);
        }
        this.portletConfig = config;
        PortletContext portletContext = config.getPortletContext();
        WebXML webXml = new WebXML();
        webXml.parse(portletContext);
        this.filterInitParams = webXml.getFilterInitParams();
        this.initFaces(portletContext);
        this.transferLocales(config);
        this.exceptionHandler = this.createExceptionHandler();
        this.facesServletMappings = webXml.getFacesServletMappings();
        this.errorPages = webXml.getErrorViews();
        this.excludedAttributes = new HashSet<ExcludedRequestAttribute>();
        String bridgeParametersPrefix = "javax.portlet.faces." + portletName + ".";
        List<String> excluded = (List<String>)portletContext.getAttribute(bridgeParametersPrefix + "excludedRequestAttributes");
        if (null != excluded) {
            for (String name : excluded) {
                this.excludedAttributes.add(new ExcludedRequestAttribute(name));
            }
        }
        if (null != (maxScopesParameter = portletContext.getInitParameter("javax.portlet.faces.MAX_MANAGED_REQUEST_SCOPES"))) {
            this.numberOfRequestScopes = Integer.parseInt(maxScopesParameter);
        }
        FacesConfig facesConfig = new FacesConfig();
        facesConfig.parse(portletContext);
        excluded = facesConfig.getExcludedAttributes();
        if (null != excluded) {
            for (String name : excluded) {
                this.excludedAttributes.add(new ExcludedRequestAttribute(name));
            }
        }
        this.publicParameterMapping = facesConfig.getParameterMapping();
        Boolean preserveParams = (Boolean)portletContext.getAttribute(bridgeParametersPrefix + "preserveActionParams");
        this.preserveActionParams = Boolean.TRUE.equals(preserveParams);
        this.defaultViewIdMap = (Map)portletContext.getAttribute(bridgeParametersPrefix + "defaultViewIdMap");
        if (null == this.defaultViewIdMap || 0 == this.defaultViewIdMap.size()) {
            throw new BridgeException("No JSF view id's defined in portlet");
        }
        this.eventHandler = (BridgeEventHandler)portletContext.getAttribute(bridgeParametersPrefix + "bridgeEventHandler");
        this.publicParameterHandler = (BridgePublicRenderParameterHandler)portletContext.getAttribute(bridgeParametersPrefix + "bridgePublicRenderParameterHandler");
        this.initialized = true;
        if (log.isLoggable(Level.FINE)) {
            log.fine("Done portletbridge initialization for " + portletName);
        }
    }

    protected void initFaces(PortletContext portletContext) {
        try {
            this.strategy = BridgeStrategy.getCurrentStrategy(this);
            LifecycleFactory factory = (LifecycleFactory)FactoryFinder.getFactory((String)"javax.faces.lifecycle.LifecycleFactory");
            String lifecycleId = portletContext.getInitParameter("javax.faces.LIFECYCLE_ID");
            if (null == lifecycleId) {
                lifecycleId = "DEFAULT";
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine("Create instance of a JSF lifecycle " + lifecycleId);
            }
            this.lifecycle = factory.getLifecycle(lifecycleId);
            this.facesContextFactory = (FacesContextFactory)FactoryFinder.getFactory((String)"javax.faces.context.FacesContextFactory");
            this.lifecycle.getPhaseListeners();
            ApplicationFactory appFactory = (ApplicationFactory)FactoryFinder.getFactory((String)"javax.faces.application.ApplicationFactory");
            this.application = appFactory.getApplication();
            RenderKitFactory renderKitFactory = (RenderKitFactory)FactoryFinder.getFactory((String)"javax.faces.render.RenderKitFactory");
            InitFacesContext context = new InitFacesContext(this.application, portletContext);
            this.strategy.init(context, renderKitFactory);
            context.release();
        }
        catch (FacesException e) {
            throw new BridgeException("JSF Initialization error", (Throwable)e);
        }
    }

    protected Application getApplication() {
        return this.application;
    }

    protected void transferLocales(PortletConfig config) {
        Iterator supportedLocales = this.getApplication().getSupportedLocales();
        HashSet<Object> facesLocales = new HashSet<Object>();
        while (supportedLocales.hasNext()) {
            facesLocales.add(supportedLocales.next());
        }
        ArrayList portletLocales = Collections.list(config.getSupportedLocales());
        if (!facesLocales.containsAll(portletLocales)) {
            facesLocales.addAll(portletLocales);
            this.getApplication().setSupportedLocales(facesLocales);
        }
    }

    protected ExceptionHandler createExceptionHandler() {
        ExceptionHandler handler = (ExceptionHandler)this.createInstance(EXCEPTION_HANDLER_CLASS_PARAMETER);
        if (null == handler) {
            handler = new ExceptionHandlerImpl();
        }
        return handler;
    }

    protected <E> E createInstance(String classNameParameter) {
        String className = this.getPortletConfig().getPortletContext().getInitParameter(classNameParameter);
        E instance = null;
        if (null != className) {
            ClassLoader classLoader = this.getClassLoader();
            try {
                Class<?> clazz = classLoader.loadClass(className);
                instance = (E)clazz.newInstance();
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Class load error: " + className, e);
            }
        }
        return instance;
    }

    protected ClassLoader getClassLoader() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (null == classLoader) {
            classLoader = this.getClass().getClassLoader();
        }
        return classLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFacesRequest(ActionRequest request, ActionResponse response) throws BridgeException {
        this.assertParameters((PortletRequest)request, (PortletResponse)response);
        if (log.isLoggable(Level.FINE)) {
            log.fine("Start bridge action request processing for portlet " + this.getPortletName());
        }
        PortletBridgeContext bridgeContext = this.initRequest((PortletRequest)request, (PortletResponse)response, Bridge.PortletPhase.ACTION_PHASE);
        RequestScopeManager requestStateManager = RequestScopeManager.getInstance((PortletRequest)request, this.numberOfRequestScopes);
        StateId stateId = requestStateManager.getStateId(request, response);
        bridgeContext.setStateId(stateId);
        BridgeRequestScope windowState = new BridgeRequestScope();
        bridgeContext.setRequestScope(windowState);
        FacesContext facesContext = this.createFacesContext(request, response);
        try {
            this.strategy.beforeActionRequest(facesContext);
            this.processIncomingParameters(facesContext, (PortletRequest)request);
            this.execute(facesContext);
            this.strategy.afterActionRequestExecute(facesContext);
            if (!facesContext.getResponseComplete()) {
                Map<String, String[]> viewIdParameters = bridgeContext.getViewIdParameters();
                if (null != viewIdParameters && viewIdParameters.size() > 0) {
                    this.processPortletParameters(response, stateId, facesContext, facesContext.getViewRoot().getViewId(), viewIdParameters);
                }
                this.processOutgoingParameters(facesContext, (PortletRequest)request, (StateAwareResponse)response);
                facesContext.getApplication().getStateManager().saveView(facesContext);
                windowState.saveRequest(facesContext, true);
            } else {
                windowState.reset();
                String redirectViewId = bridgeContext.getRedirectViewId();
                if (null != redirectViewId) {
                    windowState.setViewId(redirectViewId);
                    Map<String, String[]> newRequestParameters = bridgeContext.getRedirectRequestParameters();
                    windowState.setRequestParameters(newRequestParameters);
                    this.processPortletParameters(response, stateId, facesContext, redirectViewId, newRequestParameters);
                    this.processOutgoingParameters(facesContext, (PortletRequest)request, (StateAwareResponse)response);
                }
            }
        }
        catch (Exception e) {
            this.exceptionHandler.processActionException(facesContext, windowState, e);
        }
        finally {
            if (null != bridgeContext.getRedirectViewId() || !facesContext.getResponseComplete()) {
                requestStateManager.saveRequestScope(stateId, windowState);
                response.setRenderParameter("javax.faces.portletbridge.STATE_ID", stateId.toString());
            }
            this.strategy.afterActionRequest(facesContext);
            facesContext.release();
        }
    }

    private void processOutgoingParameters(FacesContext facesContext, PortletRequest request, final StateAwareResponse response) {
        Enumeration parameterNames = this.getPortletConfig().getPublicRenderParameterNames();
        if (null != this.publicParameterMapping && this.publicParameterMapping.size() > 0 && parameterNames.hasMoreElements()) {
            ParameterFunction outgoingFunction = new ParameterFunction(){

                @Override
                public boolean processParameter(ELContext elContext, Map<String, String[]> publicParameters, String name, ValueExpression valueExpression) {
                    boolean valueChanged = false;
                    String modelValue = (String)valueExpression.getValue(elContext);
                    if (null != modelValue) {
                        String parameterValue;
                        String[] values = publicParameters.get(name);
                        String string = parameterValue = null != values && values.length > 0 ? values[0] : null;
                        if (null == parameterValue || !modelValue.equals(parameterValue)) {
                            response.setRenderParameter(name, modelValue);
                            valueChanged = true;
                        }
                    } else if (publicParameters.containsKey(name)) {
                        response.removePublicRenderParameter(name);
                        valueChanged = true;
                    }
                    return valueChanged;
                }
            };
            this.processPublicParameters(facesContext, request, parameterNames, outgoingFunction);
        }
    }

    private void processIncomingParameters(FacesContext facesContext, PortletRequest request) {
        ParameterFunction incomingFunction;
        boolean valueChanged;
        Enumeration parameterNames = this.getPortletConfig().getPublicRenderParameterNames();
        if (null != this.publicParameterMapping && this.publicParameterMapping.size() > 0 && parameterNames.hasMoreElements() && (valueChanged = this.processPublicParameters(facesContext, request, parameterNames, incomingFunction = new ParameterFunction(){

            @Override
            public boolean processParameter(ELContext elContext, Map<String, String[]> publicParameters, String name, ValueExpression valueExpression) {
                boolean valueChanged = false;
                Object oldValue = valueExpression.getValue(elContext);
                if (publicParameters.containsKey(name)) {
                    String newValue;
                    String[] values = publicParameters.get(name);
                    String string = newValue = null != values && values.length > 0 ? values[0] : null;
                    if (null == oldValue || !oldValue.equals(newValue)) {
                        valueExpression.setValue(elContext, (Object)newValue);
                        valueChanged = true;
                    }
                } else if (null != oldValue) {
                    valueExpression.setValue(elContext, null);
                    valueChanged = true;
                }
                return valueChanged;
            }
        })) && null != this.publicParameterHandler) {
            this.publicParameterHandler.processUpdates(facesContext);
        }
    }

    private boolean processPublicParameters(FacesContext facesContext, PortletRequest request, Enumeration<String> parameterNames, ParameterFunction function) {
        boolean valueChanged = false;
        ExpressionFactory expressionFactory = facesContext.getApplication().getExpressionFactory();
        ELContext elContext = facesContext.getELContext();
        StringBuilder preffixedName = new StringBuilder(this.getPortletName()).append(':');
        int preffixLength = preffixedName.length();
        Map publicParameters = request.getPublicParameterMap();
        while (parameterNames.hasMoreElements()) {
            String name = parameterNames.nextElement();
            String mappingEl = this.publicParameterMapping.get(name);
            if (null == mappingEl) {
                preffixedName.setLength(preffixLength);
                mappingEl = this.publicParameterMapping.get(preffixedName.append(name).toString());
            }
            if (null == mappingEl) continue;
            ValueExpression valueExpression = expressionFactory.createValueExpression(elContext, mappingEl, Object.class);
            valueChanged = function.processParameter(elContext, publicParameters, name, valueExpression) ? true : valueChanged;
        }
        return valueChanged;
    }

    public void processPortletParameters(ActionResponse response, StateId stateId, FacesContext facesContext, String redirectViewId, Map<String, String[]> newRequestParameters) throws MalformedURLException, PortletModeException {
        for (Map.Entry<String, String[]> entry : newRequestParameters.entrySet()) {
            String key = entry.getKey();
            if ("javax.portlet.faces.PortletMode".equals(key)) {
                String portletModeName = entry.getValue()[0];
                PortletMode mode = new PortletMode(portletModeName);
                PortalActionURL historyViewId = new PortalActionURL(redirectViewId);
                stateId.setMode(mode);
                historyViewId.setParameter("javax.faces.portletbridge.STATE_ID", stateId.toString());
                historyViewId.setParameter("javax.portlet.faces.PortletMode", portletModeName);
                facesContext.getExternalContext().getSessionMap().put(VIEWID_HISTORY_PREFIX + portletModeName, historyViewId.toString());
                response.setPortletMode(mode);
                continue;
            }
            if (!"javax.portlet.faces.WindowState".equals(key)) continue;
            try {
                WindowState state = new WindowState(entry.getValue()[0]);
                response.setWindowState(state);
            }
            catch (WindowStateException e) {}
        }
    }

    private PortletBridgeContext createBridgeContext(PortletRequest request) {
        PortletBridgeContext bridgeContext = new PortletBridgeContext(this);
        request.setAttribute(PortletBridgeContext.REQUEST_PARAMETER_NAME, (Object)bridgeContext);
        bridgeContext.setInitialRequestAttributeNames(request.getAttributeNames());
        return bridgeContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFacesRequest(RenderRequest request, RenderResponse response) throws BridgeException {
        this.assertParameters((PortletRequest)request, (PortletResponse)response);
        if (log.isLoggable(Level.FINE)) {
            log.fine("Start bridge render request processing for portlet " + this.getPortletName());
        }
        Object renderPartAttribute = request.getAttribute("javax.portlet.render_part");
        RenderResponse wrappedResponse = this.strategy.createResponseWrapper(response);
        PortletBridgeContext bridgeContext = this.initRequest((PortletRequest)request, (PortletResponse)wrappedResponse, Bridge.PortletPhase.RENDER_PHASE);
        RequestScopeManager requestStateManager = RequestScopeManager.getInstance((PortletRequest)request, this.numberOfRequestScopes);
        String namespace = wrappedResponse.getNamespace();
        StateId stateId = requestStateManager.getStateId(request, response);
        bridgeContext.setStateId(stateId);
        BridgeRequestScope windowState = requestStateManager.getRequestScope(stateId);
        if (null == windowState) {
            windowState = new BridgeRequestScope();
            requestStateManager.saveRequestScope(stateId, windowState);
        }
        bridgeContext.setRequestScope(windowState);
        FacesContext facesContext = this.createFacesContext(request, wrappedResponse);
        try {
            windowState.restoreRequest(facesContext, true);
            ResourceBundle bundle = this.portletConfig.getResourceBundle(request.getLocale());
            if (bundle != null) {
                String title = null;
                try {
                    title = bundle.getString("javax.portlet.title");
                    wrappedResponse.setTitle(title);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            try {
                this.strategy.beforeRenderRequest(facesContext);
                this.processIncomingParameters(facesContext, (PortletRequest)request);
                String redirectViewId = bridgeContext.getRedirectViewId();
                if (null == redirectViewId) {
                    if (null == facesContext.getViewRoot()) {
                        this.execute(facesContext);
                    }
                    if (!facesContext.getResponseComplete()) {
                        this.render(facesContext);
                    }
                    redirectViewId = bridgeContext.getRedirectViewId();
                }
                if (null != redirectViewId) {
                    windowState.reset();
                    windowState.setViewId(redirectViewId);
                    Map<String, String[]> redirectParams = bridgeContext.getRedirectRequestParameters();
                    facesContext.release();
                    bridgeContext.resetRequestAttributes((PortletRequest)request);
                    wrappedResponse.resetBuffer();
                    if (redirectParams != null) {
                        windowState.setRequestParameters(redirectParams);
                    }
                    facesContext = this.createFacesContext(request, wrappedResponse);
                    ViewHandler viewHandler = facesContext.getApplication().getViewHandler();
                    UIViewRoot viewRoot = viewHandler.createView(facesContext, redirectViewId);
                    facesContext.setViewRoot(viewRoot);
                    this.render(facesContext);
                }
                windowState.setViewId(facesContext.getViewRoot().getViewId());
            }
            catch (Exception e) {
                wrappedResponse.resetBuffer();
                log.log(Level.SEVERE, "Error processing execute lifecycle", e);
                this.exceptionHandler.processRenderException(facesContext, windowState, e);
                facesContext = FacesContext.getCurrentInstance();
            }
            String viewId = facesContext.getViewRoot().getViewId();
            windowState.setNamespace(namespace);
            String portletModeName = request.getPortletMode().toString();
            PortalActionURL historyViewId = new PortalActionURL(viewId);
            historyViewId.setParameter("javax.faces.portletbridge.STATE_ID", stateId.toString());
            historyViewId.setParameter("javax.portlet.faces.PortletMode", portletModeName);
            facesContext.getExternalContext().getSessionMap().put(VIEWID_HISTORY_PREFIX + portletModeName, historyViewId.toString());
            if (log.isLoggable(Level.FINE)) {
                log.fine("Finish rendering portletbridge for namespace " + namespace);
            }
        }
        catch (Exception e) {
            this.throwBridgeException(e);
        }
        finally {
            this.strategy.afterRenderRequest(facesContext, wrappedResponse);
            facesContext.release();
        }
    }

    protected void assertParameters(PortletRequest request, PortletResponse response) {
        if (null == request) {
            throw new NullPointerException("Request parameter is null");
        }
        if (null == response) {
            throw new NullPointerException("Response parameter is null");
        }
        if (!this.isInitialized()) {
            throw new BridgeException("JSF Portlet bridge is not initialized");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void doFacesRequest(ResourceRequest request, ResourceResponse response) throws BridgeException {
        this.assertParameters((PortletRequest)request, (PortletResponse)response);
        if (log.isLoggable(Level.FINE)) {
            log.fine("Start bridge resource request processing for portlet " + this.getPortletName());
        }
        PortletBridgeContext bridgeContext = this.initRequest((PortletRequest)request, (PortletResponse)response, Bridge.PortletPhase.RESOURCE_PHASE);
        if (this.strategy.serveResource(request, response)) return;
        if (null == request.getParameter("_jsfBridgeViewId") && null == request.getParameter("_jsfBridgeViewPath")) {
            String target = request.getResourceID();
            if (null == target) throw new BridgeException("Unable to serve resource");
            try {
                PortletContext portletContext = this.getPortletConfig().getPortletContext();
                PortletRequestDispatcher dispatcher = portletContext.getRequestDispatcher(target);
                if (null == dispatcher) return;
                String serverInfo = portletContext.getServerInfo();
                if (null != serverInfo && (serverInfo.startsWith("JBossPortletContainer") || serverInfo.startsWith("GateInPortletContainer"))) {
                    String mimeType = portletContext.getMimeType(target);
                    if (null == mimeType) {
                        int indexOfQuestion;
                        int lastIndexOfSlash = target.lastIndexOf(47);
                        if (lastIndexOfSlash >= 0) {
                            target = target.substring(lastIndexOfSlash + 1);
                        }
                        if ((indexOfQuestion = target.indexOf(63)) >= 0) {
                            target = target.substring(0, indexOfQuestion);
                        }
                        mimeType = portletContext.getMimeType(target);
                    }
                    if (null != mimeType) {
                        response.setContentType(mimeType);
                    }
                    dispatcher.include((PortletRequest)request, (PortletResponse)response);
                    return;
                }
                dispatcher.forward((PortletRequest)request, (PortletResponse)response);
                return;
            }
            catch (Exception e) {
                this.throwBridgeException(e);
            }
            return;
        }
        ResourceResponse wrappedResponse = this.strategy.createResponseWrapper(response);
        RequestScopeManager requestStateManager = RequestScopeManager.getInstance((PortletRequest)request, this.numberOfRequestScopes);
        FacesContext facesContext = this.createFacesContext(request, wrappedResponse);
        StateId stateId = requestStateManager.getStateId(request, wrappedResponse);
        bridgeContext.setStateId(stateId);
        BridgeRequestScope windowState = requestStateManager.getRequestScope(stateId);
        if (null == windowState) {
            windowState = new BridgeRequestScope();
            requestStateManager.saveRequestScope(stateId, windowState);
        } else {
            windowState.reset();
        }
        bridgeContext.setRequestScope(windowState);
        try {
            this.strategy.beforeResourceRequest(facesContext);
            this.processIncomingParameters(facesContext, (PortletRequest)request);
            this.execute(facesContext);
            this.strategy.afterResourceRequestExecute(facesContext);
            windowState.saveRequest(facesContext, false);
            if (facesContext.getResponseComplete()) return;
            this.render(facesContext);
            return;
        }
        catch (Exception e) {
            wrappedResponse.resetBuffer();
            log.log(Level.SEVERE, "Error processing execute lifecycle", e);
            this.exceptionHandler.processResourceException(facesContext, windowState, e);
            facesContext = FacesContext.getCurrentInstance();
            return;
        }
        finally {
            this.strategy.afterResourceRequest(facesContext, wrappedResponse);
            facesContext.release();
        }
    }

    private void throwBridgeException(Exception e) throws BridgeException {
        if (!(e instanceof BridgeException)) {
            e = new BridgeException((Throwable)e);
        }
        throw (BridgeException)e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFacesRequest(EventRequest request, EventResponse response) throws BridgeException {
        this.assertParameters((PortletRequest)request, (PortletResponse)response);
        if (log.isLoggable(Level.FINE)) {
            log.fine("Start bridge event request processing for portlet " + this.getPortletName());
        }
        PortletBridgeContext bridgeContext = this.initRequest((PortletRequest)request, (PortletResponse)response, Bridge.PortletPhase.EVENT_PHASE);
        RequestScopeManager requestStateManager = RequestScopeManager.getInstance((PortletRequest)request, this.numberOfRequestScopes);
        StateId stateId = requestStateManager.getStateId(request, response);
        bridgeContext.setStateId(stateId);
        BridgeRequestScope windowState = requestStateManager.getRequestScope(stateId);
        if (null == windowState) {
            windowState = new BridgeRequestScope();
        } else {
            windowState.reset();
        }
        FacesContext facesContext = this.createFacesContext(request, response);
        try {
            Event event;
            EventNavigationResult result;
            this.strategy.beforeEventRequest(facesContext);
            response.setRenderParameters(request);
            this.processIncomingParameters(facesContext, (PortletRequest)request);
            this.execute(facesContext);
            if (null == this.eventHandler) {
                log.severe("The EventHandler is null for " + this.getPortletName() + ". Ensure " + "your portlet.xml settings are correct and that you have implemented the " + "BridgeEventHandler in your application.");
            }
            if ((result = this.eventHandler.handleEvent(facesContext, event = request.getEvent())) != null) {
                facesContext.getApplication().getNavigationHandler().handleNavigation(facesContext, result.getFromAction(), result.getOutcome());
                if (facesContext.getResponseComplete()) {
                    return;
                }
            }
            windowState.setViewRoot(facesContext.getViewRoot());
            bridgeContext.setRequestScope(windowState);
            this.processOutgoingParameters(facesContext, (PortletRequest)request, (StateAwareResponse)response);
            requestStateManager.saveRequestScope(stateId, windowState);
            response.setRenderParameter("javax.faces.portletbridge.STATE_ID", stateId.toString());
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Error processing event request", e);
            this.exceptionHandler.processEventException(facesContext, windowState, e);
        }
        finally {
            this.strategy.afterEventRequest(facesContext);
            facesContext.release();
        }
    }

    private void renderResponse(FacesContext facesContext, BridgeRequestScope windowState) throws FacesException {
        if (null == facesContext.getViewRoot()) {
            this.execute(facesContext);
        }
        if (!facesContext.getResponseComplete()) {
            this.render(facesContext);
        }
    }

    protected PortletBridgeContext initRequest(PortletRequest request, PortletResponse response, Bridge.PortletPhase currentPhase) throws BridgeException {
        request.setAttribute("javax.portlet.faces.phase", (Object)currentPhase);
        Map<String, String> viewIdMap = this.getDefaultViewIdMap();
        String firstMode = viewIdMap.keySet().iterator().next();
        PortletSession portletSession = request.getPortletSession();
        if (null == portletSession.getAttribute(VIEWID_HISTORY_PREFIX + firstMode)) {
            for (Map.Entry<String, String> entry : viewIdMap.entrySet()) {
                portletSession.setAttribute(VIEWID_HISTORY_PREFIX + entry.getKey(), (Object)this.encodeModeParam(entry.getKey(), entry.getValue()));
            }
        }
        return this.createBridgeContext(request);
    }

    protected void finishRequest(PortletRequest request, PortletResponse response) throws BridgeException {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (null != facesContext) {
            facesContext.release();
        }
        request.removeAttribute("javax.portlet.faces.phase");
        request.removeAttribute(PortletBridgeContext.REQUEST_PARAMETER_NAME);
    }

    private String encodeModeParam(String mode, String viewId) {
        try {
            PortalActionURL viewIdUrl = new PortalActionURL(viewId);
            viewIdUrl.addParameter("javax.portlet.faces.PortletMode", mode);
            return viewIdUrl.toString();
        }
        catch (MalformedURLException e) {
            throw new BridgeException("Malformed ViewId", (Throwable)e);
        }
    }

    @Override
    public PortletConfig getPortletConfig() {
        return this.portletConfig;
    }

    protected Object getContext() {
        return this.portletConfig.getPortletContext();
    }

    @Override
    public String getInitParameter(String name) {
        String initParameter = this.portletConfig.getInitParameter(name);
        if (null == initParameter) {
            initParameter = this.portletConfig.getPortletContext().getInitParameter(name);
        }
        return initParameter;
    }

    protected boolean isInitialized() {
        return this.initialized;
    }

    protected ExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    @Override
    public List<String> getFacesServletMappings() {
        return this.facesServletMappings;
    }

    @Override
    public Set<ExcludedRequestAttribute> getExcludedAttributes() {
        return this.excludedAttributes;
    }

    @Override
    public String getPortletName() {
        return this.portletConfig.getPortletName();
    }

    @Override
    public boolean isPreserveActionParams() {
        return this.preserveActionParams;
    }

    @Override
    public Map<String, String> getDefaultViewIdMap() {
        return this.defaultViewIdMap;
    }

    @Override
    public int getNumberOfRequestScopes() {
        return this.numberOfRequestScopes;
    }

    public void contextCreated(ELContextEvent event) {
        ELContext elContext = event.getELContext();
        if (elContext.getContext(PortletConfig.class) == null) {
            elContext.putContext(PortletConfig.class, (Object)this.portletConfig);
        }
    }

    @Override
    public Lifecycle getFacesLifecycle() {
        return this.lifecycle;
    }

    @Override
    public FacesContext createFacesContext(Object request, Object response) {
        FacesContext facesContext = this.facesContextFactory.getFacesContext(this.getContext(), request, response, this.getFacesLifecycle());
        return facesContext;
    }

    protected void execute(FacesContext context) throws FacesException {
        this.getFacesLifecycle().execute(context);
    }

    protected void render(FacesContext context) throws FacesException {
        this.getFacesLifecycle().render(context);
    }

    @Override
    public Map<Class<? extends Throwable>, String> getErrorPages() {
        return this.errorPages;
    }

    @Override
    public BridgeStrategy getStrategy() {
        return this.strategy;
    }

    @Override
    public Map<String, String> getFilterInitParams(String filterClassName) {
        if (this.filterInitParams != null) {
            return this.filterInitParams.get(filterClassName);
        }
        return new HashMap<String, String>();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface ParameterFunction {
        public boolean processParameter(ELContext var1, Map<String, String[]> var2, String var3, ValueExpression var4);
    }
}

