/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portletbridge;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.faces.application.ViewExpiredException;
import javax.faces.context.FacesContext;
import javax.portlet.PortletRequest;
import javax.portlet.ResourceResponse;
import javax.portlet.faces.BridgeException;
import org.jboss.portletbridge.BridgeRequestScope;
import org.jboss.portletbridge.ExceptionHandler;
import org.jboss.portletbridge.context.PortletBridgeContext;

public abstract class ExceptionHandlerBase
implements ExceptionHandler {
    private static final String HANDLE_VIEW_EXPIRED_ON_CLIENT = "org.ajax4jsf.handleViewExpiredOnClient";
    private static final String AJAX_FLAG_HEADER = "Ajax-Response";
    public static final String AJAX_EXPIRED = "Ajax-Expired";

    public void processRenderException(FacesContext context, BridgeRequestScope windowState, Exception e) throws BridgeException {
        String redirectViewId = this.processException(context, windowState, e);
        if (null == redirectViewId) {
            throw new BridgeException("Error processing render lifecycle", (Throwable)e);
        }
        PortletBridgeContext bridgeContext = PortletBridgeContext.getCurrentInstance(context);
        PortletRequest request = (PortletRequest)context.getExternalContext().getRequest();
        bridgeContext.resetRequestAttributes(request);
        windowState.restoreBeans(context);
        this.renderErrorPage(context, windowState, e, redirectViewId);
    }

    public void processResourceException(FacesContext facesContext, BridgeRequestScope windowState, Exception e) throws BridgeException {
        windowState.saveRequestParameters(facesContext);
        String redirectViewId = this.processException(facesContext, windowState, e);
        if (null != redirectViewId) {
            this.renderErrorPage(facesContext, windowState, e, redirectViewId);
        } else {
            boolean handleViewExpiredOnClient = Boolean.parseBoolean(facesContext.getExternalContext().getInitParameter(HANDLE_VIEW_EXPIRED_ON_CLIENT));
            if (handleViewExpiredOnClient && this.isViewExpired(e)) {
                this.sendAjaxViewExpired(facesContext, e);
            } else {
                throw new BridgeException("Error processing resource lifecycle", (Throwable)e);
            }
        }
    }

    private void sendAjaxViewExpired(FacesContext facesContext, Exception e) {
        ResourceResponse response = (ResourceResponse)facesContext.getExternalContext().getResponse();
        try {
            String message;
            response.reset();
            try {
                ResourceBundle resourceBundle = ResourceBundle.getBundle("org.ajax4jsf.messages", facesContext.getApplication().getViewHandler().calculateLocale(facesContext), Thread.currentThread().getContextClassLoader());
                message = resourceBundle.getString("AJAX_VIEW_EXPIRED");
            }
            catch (MissingResourceException e2) {
                message = "%AJAX_VIEW_EXPIRED%";
            }
            response.setProperty(AJAX_EXPIRED, message);
            response.setContentType("text/xml");
            PrintWriter output = response.getWriter();
            output.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<html xmlns=\"http://www.w3.org/1999/xhtml\"><head><meta name=\"Ajax-Response\" content=\"true\" /><meta name=\"Ajax-Expired\" content=\"" + message + "\" />" + "</head></html>");
            output.flush();
        }
        catch (IOException e1) {
            throw new BridgeException("Error render Ajax-expired content", (Throwable)e);
        }
    }

    public void processEventException(FacesContext facesContext, BridgeRequestScope windowState, Exception e) throws BridgeException {
        throw new BridgeException("Error processing faces lifecycle from event request", (Throwable)e);
    }

    public void processActionException(FacesContext context, BridgeRequestScope windowState, Exception e) throws BridgeException {
        String errorPage = this.processException(context, windowState, e);
        if (null == errorPage) {
            throw new BridgeException("Error processing render lifecycle", (Throwable)e);
        }
        windowState.reset();
        this.setupErrorParameters(context, e);
        windowState.setViewId(errorPage);
        windowState.saveRequestParameters(context);
        windowState.saveBeans(context);
    }

    protected void renderErrorPage(FacesContext context, BridgeRequestScope windowState, Exception e, String redirectViewId) {
        PortletBridgeContext bridgeContext = PortletBridgeContext.getCurrentInstance(context);
        PortletRequest request = (PortletRequest)context.getExternalContext().getRequest();
        Object response = context.getExternalContext().getResponse();
        context.release();
        request.setAttribute("javax.portlet.faces.viewId", (Object)redirectViewId);
        context = bridgeContext.getBridgeConfig().createFacesContext(request, response);
        windowState.restoreMessages(context);
        this.setupErrorParameters(context, e);
        bridgeContext.render(context);
    }

    protected abstract String processException(FacesContext var1, BridgeRequestScope var2, Exception var3);

    private boolean isViewExpired(Throwable e) {
        while (null != e) {
            if (e instanceof ViewExpiredException) {
                return true;
            }
            e = e.getCause();
        }
        return false;
    }

    protected void setupErrorParameters(FacesContext context, Throwable throwable) {
        Map requestMap = context.getExternalContext().getRequestMap();
        requestMap.put("javax.servlet.error.exception", throwable);
        requestMap.put("javax.servlet.error.status_code", 500);
        requestMap.put("javax.servlet.error.message", throwable.getLocalizedMessage());
        requestMap.put("javax.servlet.error.servlet_name", "Faces Servlet");
    }
}

