/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portletbridge;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.application.FacesMessage;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.portlet.faces.BridgeException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.portletbridge.BridgeRequestScope;
import org.jboss.portletbridge.ExceptionHandlerBase;
import org.jboss.portletbridge.context.PortletBridgeContext;
import org.jboss.portletbridge.seam.FacesMessages;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.contexts.FacesLifecycle;
import org.jboss.seam.core.ConversationPropagation;
import org.jboss.seam.core.Manager;
import org.jboss.seam.exception.Exceptions;
import org.jboss.seam.transaction.Transaction;
import org.jboss.seam.transaction.UserTransaction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SeamExceptionHandlerImpl
extends ExceptionHandlerBase {
    protected static final Log log = LogFactory.getLog(SeamExceptionHandlerImpl.class);

    @Override
    protected String processException(FacesContext context, BridgeRequestScope windowState, Exception e) {
        windowState.setMessages(this.handleException(context, e));
        PortletBridgeContext bridgeContext = PortletBridgeContext.getCurrentInstance(context);
        String redirectViewId = bridgeContext.getRedirectViewId();
        return redirectViewId;
    }

    public static Class<?> classForName(String name) throws ClassNotFoundException {
        try {
            return Thread.currentThread().getContextClassLoader().loadClass(name);
        }
        catch (Exception e) {
            return Class.forName(name);
        }
    }

    protected Map<String, List<FacesMessage>> handleException(FacesContext facesContext, Exception e) throws BridgeException {
        Manager manager = Contexts.isEventContextActive() ? (Manager)Contexts.getEventContext().get(Manager.class) : null;
        String conversationId = manager == null ? null : manager.getCurrentConversationId();
        FacesLifecycle.beginExceptionRecovery((ExternalContext)facesContext.getExternalContext());
        if (conversationId == null) {
            Manager.instance().initializeTemporaryConversation();
        } else {
            ConversationPropagation.instance().setConversationId(conversationId);
            Manager.instance().restoreConversation();
        }
        try {
            HashMap<String, List<FacesMessage>> windowMessageMap = new HashMap<String, List<FacesMessage>>();
            ArrayList<FacesMessage> messageList = new ArrayList<FacesMessage>();
            Exceptions.instance().handle(e);
            FacesMessages.afterPhase();
            FacesMessages messages = FacesMessages.instance();
            messageList.addAll(messages.getStatusMessages());
            windowMessageMap.put("", messageList);
            HashMap<String, List<FacesMessage>> hashMap = windowMessageMap;
            return hashMap;
        }
        catch (Exception ehe) {
            log.error((Object)"Unable to process exception with Seam exception handler", (Throwable)ehe);
            throw new BridgeException((Throwable)ehe);
        }
        finally {
            try {
                this.rollbackTransactionIfNecessary();
                log.debug((Object)"done running exception handlers");
            }
            catch (Exception ere) {
                log.error((Object)"could not destroy contexts", (Throwable)ere);
            }
        }
    }

    protected void rollbackTransactionIfNecessary() {
        try {
            UserTransaction transaction = Transaction.instance();
            if (transaction.isActiveOrMarkedRollback() || transaction.isRolledBack()) {
                log.debug((Object)"killing transaction");
                transaction.rollback();
            }
        }
        catch (Exception te) {
            log.error((Object)"could not roll back transaction", (Throwable)te);
        }
    }

    @Override
    public void processEventException(FacesContext facesContext, BridgeRequestScope windowState, Exception e) throws BridgeException {
        this.rollbackTransactionIfNecessary();
        super.processEventException(facesContext, windowState, e);
    }
}

