/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portletbridge.application;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.faces.application.StateManager;
import javax.faces.application.StateManagerWrapper;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.portlet.faces.BridgeUtil;
import org.jboss.portletbridge.context.PortletBridgeContext;

public class PortletStateManager
extends StateManagerWrapper {
    private StateManager parent;
    static final Pattern PATTERN = Pattern.compile(".*<input.*(?:\\svalue=[\"'](\\S*)[\"']\\s).*name=[\"']javax.faces.ViewState[\"'].*>");
    static final Pattern PATTERN2 = Pattern.compile(".*<input .*name=[\"']javax.faces.ViewState[\"'].*(?:\\svalue=[\"'](\\S*)[\"']\\s).*>");

    public PortletStateManager(StateManager parent) {
        this.parent = parent;
    }

    public void writeState(FacesContext context, final StateManager.SerializedView state) throws IOException {
        if (BridgeUtil.isPortletRequest()) {
            this.captureStateParameter(context, new StateWriter(){

                public void writeState(FacesContext context) throws IOException {
                    PortletStateManager.this.getWrapped().writeState(context, state);
                }
            });
        } else {
            super.writeState(context, state);
        }
    }

    public void writeState(FacesContext context, final Object state) throws IOException {
        if (BridgeUtil.isPortletRequest()) {
            this.captureStateParameter(context, new StateWriter(){

                public void writeState(FacesContext context) throws IOException {
                    PortletStateManager.this.getWrapped().writeState(context, state);
                }
            });
        } else {
            super.writeState(context, state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void captureStateParameter(FacesContext context, StateWriter delegate) throws IOException {
        ResponseWriter originalWriter = context.getResponseWriter();
        StringWriter buff = new StringWriter(128);
        try {
            ResponseWriter stateResponseWriter = originalWriter.cloneWithWriter((Writer)buff);
            context.setResponseWriter(stateResponseWriter);
            delegate.writeState(context);
            stateResponseWriter.flush();
            String stateString = buff.toString();
            originalWriter.write(stateString);
            String stateValue = PortletStateManager.getStateValue(stateString);
            PortletBridgeContext bridgeContext = PortletBridgeContext.getCurrentInstance(context);
            if (null != bridgeContext) {
                Map<String, String[]> requestParameters = bridgeContext.getRequestScope().getRequestParameters();
                if (null != stateValue) {
                    requestParameters.put("javax.faces.ViewState", new String[]{stateValue});
                } else {
                    requestParameters.remove("javax.faces.ViewState");
                }
            }
        }
        finally {
            context.setResponseWriter(originalWriter);
        }
    }

    static String getStateValue(String input) {
        Matcher matcher = PATTERN.matcher(input);
        if (!matcher.matches() && !(matcher = PATTERN2.matcher(input)).matches()) {
            return null;
        }
        return matcher.group(1);
    }

    protected StateManager getWrapped() {
        return this.parent;
    }

    public static interface StateWriter {
        public void writeState(FacesContext var1) throws IOException;
    }
}

