/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portletbridge.context;

import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import javax.faces.context.FacesContextFactory;
import javax.faces.lifecycle.Lifecycle;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.PortletContext;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.portlet.faces.Bridge;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.portletbridge.context.ActionRequestExternalContextImpl;
import org.jboss.portletbridge.context.EventRequestExternalContextImpl;
import org.jboss.portletbridge.context.FacesContextImpl;
import org.jboss.portletbridge.context.PortletExternalContextImpl;
import org.jboss.portletbridge.context.RenderPortletExternalContextImpl;
import org.jboss.portletbridge.context.ResourceRequestExternalContextImpl;

public class FacesContextFactoryImpl
extends FacesContextFactory {
    private FacesContextFactory defaultFacesContextFactory;
    private static final Log _log = LogFactory.getLog(FacesContextFactoryImpl.class);

    public FacesContextFactoryImpl(FacesContextFactory defaultFactory) {
        this.defaultFacesContextFactory = defaultFactory;
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Portal - specific FacesContextFactory has initialised");
        }
    }

    public FacesContext getFacesContext(Object context, Object request, Object response, Lifecycle lifecycle) throws FacesException {
        FacesContext facesContext;
        Object portletPhase;
        if (null == context || null == request || null == response || null == lifecycle) {
            throw new NullPointerException("One or more parameters for a faces context instantiation is null");
        }
        Object object = portletPhase = request instanceof PortletRequest ? ((PortletRequest)request).getAttribute("javax.portlet.faces.phase") : null;
        if (null != portletPhase) {
            PortletExternalContextImpl externalContext;
            if (Bridge.PortletPhase.ACTION_PHASE.equals(portletPhase) && context instanceof PortletContext && request instanceof ActionRequest && response instanceof ActionResponse) {
                externalContext = new ActionRequestExternalContextImpl((PortletContext)context, (ActionRequest)request, (ActionResponse)response);
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)"Portal request - create portal version of the ExternalContext for action request");
                }
            } else if (Bridge.PortletPhase.RENDER_PHASE.equals(portletPhase) && context instanceof PortletContext && request instanceof RenderRequest && response instanceof RenderResponse) {
                externalContext = new RenderPortletExternalContextImpl((PortletContext)context, (RenderRequest)request, (RenderResponse)response);
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)"Portal request - create portal version of the ExternalContext for render response");
                }
            } else if (Bridge.PortletPhase.RESOURCE_PHASE.equals(portletPhase) && context instanceof PortletContext && request instanceof ResourceRequest && response instanceof ResourceResponse) {
                externalContext = new ResourceRequestExternalContextImpl((PortletContext)context, (ResourceRequest)request, (ResourceResponse)response);
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)"Portal request - create portal version of the ExternalContext for resource response");
                }
            } else if (Bridge.PortletPhase.EVENT_PHASE.equals(portletPhase) && context instanceof PortletContext && request instanceof EventRequest && response instanceof EventResponse) {
                externalContext = new EventRequestExternalContextImpl((PortletContext)context, (EventRequest)request, (EventResponse)response);
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)"Portal request - create portal version of the ExternalContext for event request");
                }
            } else {
                throw new FacesException("Invalid types for portlet phase " + portletPhase.toString());
            }
            facesContext = new FacesContextImpl(externalContext, lifecycle);
        } else {
            facesContext = this.defaultFacesContextFactory.getFacesContext(context, request, response, lifecycle);
        }
        return facesContext;
    }
}

