/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portletbridge.context;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortalActionURL {
    private static final Pattern urlPattern = Pattern.compile("^(\\w*:)?(//[\\w\\._-]+[^/:])?((?:\\:)(\\d+))?([^?]*)?((?:\\?)(.*))?$");
    private static final String NULL = "";
    private String protocol;
    private String host;
    private int port = -1;
    private String authority;
    private transient String path;
    private transient String userInfo;
    private Map<String, String[]> parameters;
    private int _length;

    public PortalActionURL(String url) throws MalformedURLException {
        Matcher urlMatcher = urlPattern.matcher(url);
        if (!urlMatcher.matches()) {
            throw new MalformedURLException(url);
        }
        this._length = url.length();
        this.protocol = urlMatcher.group(1);
        this.host = urlMatcher.group(2);
        String portStr = urlMatcher.group(4);
        if (null != portStr && portStr.length() > 0) {
            this.port = Integer.parseInt(portStr);
        }
        this.path = urlMatcher.group(5);
        this.setQueryString(urlMatcher.group(7));
    }

    protected String decodeURL(String par) {
        try {
            return URLDecoder.decode(par, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return URLDecoder.decode(par);
        }
    }

    protected String encodeURL(String par) {
        try {
            return URLEncoder.encode(par, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return URLEncoder.encode(par);
        }
    }

    public PortalActionURL(PortalActionURL src) {
        if (null == src) {
            throw new NullPointerException("Source URL is null");
        }
        this._length = src._length;
        this.protocol = src.protocol;
        this.host = src.host;
        this.port = src.port;
        this.path = src.path;
        this.parameters = new LinkedHashMap<String, String[]>(src.parameters);
        this.authority = src.authority;
        this.userInfo = src.userInfo;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getAuthority() {
        return this.authority;
    }

    public String getPath() {
        return this.path;
    }

    public String getUserInfo() {
        return this.userInfo;
    }

    public String getQueryString() {
        if (null != this.parameters && this.parameters.size() > 0) {
            StringBuilder queryString = new StringBuilder();
            Iterator<Map.Entry<String, String[]>> iterator = this.parameters.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, String[]> param = iterator.next();
                String[] values = param.getValue();
                for (int i = 0; i < values.length; ++i) {
                    queryString.append(this.encodeURL(param.getKey()));
                    if (values[i] != NULL) {
                        queryString.append('=').append(this.encodeURL(values[i]));
                    }
                    if (i >= values.length - 1) continue;
                    queryString.append('&');
                }
                if (!iterator.hasNext()) continue;
                queryString.append('&');
            }
            return queryString.toString();
        }
        return null;
    }

    public String getParameter(String name) {
        String[] values = this.parameters.get(name);
        if (null != values && values.length > 0) {
            return values[0];
        }
        return null;
    }

    public void setParameter(String name, String value) {
        this.parameters.put(name, new String[]{value});
    }

    public void addParameter(String name, String value) {
        String[] values = this.parameters.get(name);
        if (null != values && values.length > 0) {
            ArrayList<String> valuesList = new ArrayList<String>(Arrays.asList(values));
            valuesList.add(value);
            values = valuesList.toArray(new String[valuesList.size()]);
        } else {
            values = new String[]{value};
        }
        this.parameters.put(name, values);
    }

    public String removeParameter(String name) {
        String[] values = this.parameters.remove(name);
        if (null != values && values.length > 0) {
            return values[0];
        }
        return null;
    }

    public int parametersSize() {
        return this.parameters.size();
    }

    public boolean isInContext(String context) {
        return this.host == null && this.protocol == null && this.port == -1 && (this.path.startsWith(context + "/") || !this.path.startsWith("/"));
    }

    public String toString() {
        StringBuilder url = new StringBuilder(this._length);
        if (null != this.protocol) {
            url.append(this.protocol);
        }
        if (null != this.host) {
            url.append(this.host);
        }
        if (this.port > 0) {
            url.append(':').append(this.port);
        }
        url.append(this.path);
        String queryString = this.getQueryString();
        if (null != queryString) {
            url.append('?').append(queryString);
        }
        return url.toString();
    }

    public Map<String, String[]> getParameters() {
        return this.parameters;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setAuthority(String authority) {
        this.authority = authority;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setUserInfo(String userInfo) {
        this.userInfo = userInfo;
    }

    public void setParameters(Map<String, String[]> parameters) {
        this.parameters = parameters;
    }

    public void setQueryString(String queryString) {
        this.parameters = new LinkedHashMap<String, String[]>(30);
        if (null != queryString && queryString.length() > 0) {
            String[] queryParams = queryString.split("&");
            for (int i = 0; i < queryParams.length; ++i) {
                String par = queryParams[i];
                int eqIndex = par.indexOf(61);
                if (eqIndex >= 0) {
                    String value = par.substring(eqIndex + 1);
                    String name = par.substring(0, eqIndex);
                    this.addParameter(this.decodeURL(name), this.decodeURL(value));
                    continue;
                }
                this.addParameter(par, NULL);
            }
        }
    }
}

