/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portletbridge.context;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.faces.FacesException;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletResponse;
import javax.portlet.PortletSession;
import javax.portlet.faces.BridgeDefaultViewNotSpecifiedException;
import org.jboss.portletbridge.BridgeRequestScope;
import org.jboss.portletbridge.context.AbstractExternalContext;
import org.jboss.portletbridge.context.EnumerationIterator;
import org.jboss.portletbridge.context.PortalActionURL;
import org.jboss.portletbridge.context.PortletBridgeContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PortletExternalContextImpl
extends AbstractExternalContext {
    public static final String SERVLET_PATH_ATTRIBUTE = "javax.servlet.include.servlet_path";
    public static final String PATH_INFO_ATTRIBUTE = "javax.servlet.include.path_info";
    public static final String ACTION_URL_DO_NOTHITG = "/JBossPortletBridge/actionUrl/do/nothing";
    public static final String RESOURCE_URL_DO_NOTHITG = "/JBossPortletBridge/resourceUrl/do/nothing";
    private String _pathInfo = null;
    private String _servletPath = null;
    private String servletMappingSuffix;
    private String defaultJsfSuffix;
    private String servletMappingPrefix;
    private String viewId;

    public PortletExternalContextImpl(PortletContext context, PortletRequest request, PortletResponse response) {
        super(context, request, response);
        this.portletBridgeContext = (PortletBridgeContext)request.getAttribute(PortletBridgeContext.REQUEST_PARAMETER_NAME);
        if (null == this.portletBridgeContext) {
            throw new FacesException("No portlet bridge context");
        }
        this.calculateViewId();
    }

    public void setResponseCharacterEncoding(String encoding) {
    }

    public String getResponseCharacterEncoding() {
        return null;
    }

    public String getResponseContentType() {
        return null;
    }

    public String getRequestContentType() {
        return null;
    }

    public PortletContext getContext() {
        return (PortletContext)super.getContext();
    }

    public PortletRequest getRequest() {
        return (PortletRequest)super.getRequest();
    }

    public PortletResponse getResponse() {
        return (PortletResponse)super.getResponse();
    }

    public String getInitParameter(String name) {
        return this.getContext().getInitParameter(name);
    }

    @Override
    protected String getNamespace() {
        return this.getResponse().getNamespace();
    }

    public URL getResource(String path) throws MalformedURLException {
        return this.getContext().getResource(path);
    }

    public InputStream getResourceAsStream(String path) {
        return this.getContext().getResourceAsStream(path);
    }

    public Set<String> getResourcePaths(String path) {
        return this.getContext().getResourcePaths(path);
    }

    @Override
    protected Enumeration<String> enumerateRequestParameterNames() {
        return this.getRequest().getParameterNames();
    }

    @Override
    protected Object getContextAttribute(String name) {
        return this.getContext().getAttribute(name);
    }

    @Override
    protected Enumeration<String> getContextAttributeNames() {
        return this.getContext().getAttributeNames();
    }

    @Override
    protected Enumeration<String> getInitParametersNames() {
        return this.getContext().getInitParameterNames();
    }

    @Override
    protected Object getRequestAttribute(String name) {
        if (PATH_INFO_ATTRIBUTE.equals(name)) {
            return this.getRequestPathInfo();
        }
        if (SERVLET_PATH_ATTRIBUTE.equals(name)) {
            return this.getRequestServletPath();
        }
        return this.getRequest().getAttribute(name);
    }

    @Override
    protected Enumeration<String> getRequestAttributeNames() {
        return this.getRequest().getAttributeNames();
    }

    @Override
    public Map<String, String[]> getRequestParameterValuesMap() {
        return this.getRequest().getParameterMap();
    }

    @Override
    protected String[] getRequestParameterValues(String name) {
        return this.getRequest().getParameterValues(name);
    }

    @Override
    protected String getRequestHeader(String name) {
        return this.getRequest().getProperty(name);
    }

    @Override
    protected Enumeration<String> getRequestHeaderNames() {
        return this.getRequest().getPropertyNames();
    }

    @Override
    protected String[] getRequestHeaderValues(String name) {
        Enumeration properties = this.getRequest().getProperties(name);
        ArrayList<String> values = new ArrayList<String>();
        while (properties.hasMoreElements()) {
            String value = (String)properties.nextElement();
            values.add(value);
        }
        return values.toArray(EMPTY_STRING_ARRAY);
    }

    @Override
    protected String getRequestParameter(String name) {
        return this.getRequest().getParameter(name);
    }

    @Override
    protected Object getSessionAttribute(String name) {
        return this.getSessionAttribute(name, this.getScopeForName(name));
    }

    protected int getScopeForName(String name) {
        return this.portletBridgeContext.getBridgeConfig().getStrategy().getPortletSessionScopeForName(name);
    }

    protected Object getSessionAttribute(String name, int scope) {
        return this.getRequest().getPortletSession(true).getAttribute(name, scope);
    }

    @Override
    protected Enumeration<String> getSessionAttributeNames() {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class AttributeEnumeration
        implements Enumeration<String> {
            int scope = 2;
            Enumeration<String> attributes;

            public AttributeEnumeration() {
                this.attributes = PortletExternalContextImpl.this.getSessionAttributeNames(this.scope);
                if (!this.attributes.hasMoreElements()) {
                    this.scope = 1;
                    this.attributes = PortletExternalContextImpl.this.getSessionAttributeNames(this.scope);
                }
            }

            @Override
            public boolean hasMoreElements() {
                return this.attributes.hasMoreElements();
            }

            @Override
            public String nextElement() {
                String result = this.attributes.nextElement();
                if (!this.attributes.hasMoreElements() && this.scope == 2) {
                    this.scope = 1;
                    this.attributes = PortletExternalContextImpl.this.getSessionAttributeNames(this.scope);
                }
                return result;
            }
        }
        return new AttributeEnumeration();
    }

    protected Enumeration<String> getSessionAttributeNames(int scope) {
        return this.getRequest().getPortletSession(true).getAttributeNames(scope);
    }

    @Override
    protected void removeContextAttribute(String name) {
        this.getContext().removeAttribute(name);
    }

    @Override
    protected void removeRequestAttribute(String name) {
        this.getRequest().removeAttribute(name);
    }

    @Override
    protected void removeSessionAttribute(String name) {
        this.removeSessionAttribute(name, this.getScopeForName(name));
    }

    protected void removeSessionAttribute(String name, int scope) {
        this.getRequest().getPortletSession(true).removeAttribute(name, scope);
    }

    @Override
    protected void setContextAttribute(String name, Object value) {
        this.getContext().setAttribute(name, value);
    }

    @Override
    protected void setRequestAttribute(String name, Object value) {
        this.getRequest().setAttribute(name, value);
    }

    @Override
    protected void setSessionAttribute(String name, Object value) {
        this.setSessionAttribute(name, value, this.getScopeForName(name));
    }

    protected void setSessionAttribute(String name, Object value, int scope) {
        this.getRequest().getPortletSession(true).setAttribute(name, value, scope);
    }

    @Override
    protected String encodeURL(String url) {
        return this.getResponse().encodeURL(url);
    }

    public String getAuthType() {
        return this.getRequest().getAuthType();
    }

    public String getRemoteUser() {
        Principal userPrincipal;
        String user = this.getRequest().getRemoteUser();
        if (user == null && null != (userPrincipal = this.getUserPrincipal())) {
            user = userPrincipal.getName();
        }
        return user;
    }

    public String getRequestContextPath() {
        return this.getRequest().getContextPath();
    }

    public Locale getRequestLocale() {
        return this.getRequest().getLocale();
    }

    public Iterator<Locale> getRequestLocales() {
        return new EnumerationIterator<Locale>(this.getRequest().getLocales());
    }

    public String getRequestPathInfo() {
        return this._pathInfo;
    }

    public String getRequestServletPath() {
        return this._servletPath;
    }

    public Object getSession(boolean create) {
        return this.getRequest().getPortletSession(create);
    }

    public Principal getUserPrincipal() {
        return this.getRequest().getUserPrincipal();
    }

    public boolean isUserInRole(String role) {
        return this.getRequest().isUserInRole(role);
    }

    public void log(String message) {
        this.getContext().log(message);
    }

    public void log(String message, Throwable exception) {
        this.getContext().log(message, exception);
    }

    protected void calculateViewId() {
        this.viewId = (String)this.getRequest().getAttribute("javax.portlet.faces.viewId");
        String portletModeName = this.getRequest().getPortletMode().toString();
        if (null == this.viewId) {
            String viewPath = (String)this.getRequest().getAttribute("javax.portlet.faces.viewPath");
            if (null != viewPath) {
                this.viewId = this.getViewIdFromPath(viewPath);
            } else {
                BridgeRequestScope windowState = this.portletBridgeContext.getRequestScope();
                String resetModeViewId = this.portletBridgeContext.getBridgeConfig().getPortletConfig().getInitParameter("javax.portlet.faces.extension.resetModeViewId");
                if (resetModeViewId != null && Boolean.parseBoolean(resetModeViewId)) {
                    this.viewId = this.calculateDefaultViewId(portletModeName);
                } else if (null != windowState) {
                    this.viewId = windowState.getViewId();
                }
                if (null == this.viewId) {
                    String historyViewId;
                    PortletSession portletSession = this.getRequest().getPortletSession(false);
                    if (null != portletSession && null != (historyViewId = (String)portletSession.getAttribute("javax.portlet.faces.viewIdHistory." + portletModeName))) {
                        try {
                            PortalActionURL viewIdUrl = new PortalActionURL(historyViewId);
                            this.viewId = viewIdUrl.getPath();
                        }
                        catch (MalformedURLException e) {
                            // empty catch block
                        }
                    }
                    if (null == this.viewId) {
                        this.viewId = this.calculateDefaultViewId(portletModeName);
                    }
                    if (null == this.viewId) {
                        throw new BridgeDefaultViewNotSpecifiedException();
                    }
                }
            }
        }
        List<String> servletMappings = this.portletBridgeContext.getBridgeConfig().getFacesServletMappings();
        this.calculateServletPath(this.viewId, servletMappings);
    }

    private String calculateDefaultViewId(String modeName) {
        return this.portletBridgeContext.getBridgeConfig().getDefaultViewIdMap().get(modeName);
    }

    protected void calculateServletPath(String viewId, List<String> servletMappings) {
        if (null != servletMappings && servletMappings.size() > 0) {
            String mapping = servletMappings.get(0);
            if (mapping.startsWith("*")) {
                int i;
                this.servletMappingSuffix = mapping.substring(mapping.indexOf(46));
                this.defaultJsfSuffix = this.getContext().getInitParameter("javax.faces.DEFAULT_SUFFIX");
                if (null == this.defaultJsfSuffix) {
                    this.defaultJsfSuffix = ".jsp";
                }
                if ((i = viewId.lastIndexOf(this.defaultJsfSuffix)) < 0) {
                    i = viewId.lastIndexOf(46);
                }
                if (i >= 0) {
                    viewId = viewId.substring(0, i) + this.servletMappingSuffix;
                }
                this._servletPath = viewId;
                this.getRequest().setAttribute(SERVLET_PATH_ATTRIBUTE, (Object)viewId);
                this.getRequest().setAttribute("com.sun.faces.INVOCATION_PATH", (Object)this.servletMappingSuffix);
                this._pathInfo = null;
            } else if (mapping.endsWith("*")) {
                if ((mapping = mapping.substring(0, mapping.length() - 1)).endsWith("/")) {
                    mapping = mapping.substring(0, mapping.length() - 1);
                }
                this.servletMappingPrefix = this._servletPath = mapping;
                this.getRequest().setAttribute("com.sun.faces.INVOCATION_PATH", (Object)mapping);
                this._pathInfo = viewId;
            } else {
                this._servletPath = null;
                this._pathInfo = viewId;
            }
        } else {
            this._servletPath = null;
            this._pathInfo = viewId;
        }
    }

    protected void internalRedirect(PortalActionURL actionURL) {
        String viewId = actionURL.getParameter("_jsfBridgeViewId");
        if (null != viewId) {
            this.portletBridgeContext.setRedirectViewId(viewId);
            Map<String, String[]> requestParameters = actionURL.getParameters();
            if (requestParameters.size() > 0) {
                this.portletBridgeContext.setRedirectRequestParameters(requestParameters);
            }
        }
    }

    public String getServletMappingSuffix() {
        return this.servletMappingSuffix;
    }

    public String getDefaultJsfSuffix() {
        return this.defaultJsfSuffix;
    }

    public String getServletMappingPrefix() {
        return this.servletMappingPrefix;
    }

    protected String getViewIdFromUrl(PortalActionURL url) {
        String viewId = url.getParameter("_jsfBridgeViewId");
        if (null == viewId) {
            viewId = url.getPath();
            if (viewId.startsWith(this.getRequestContextPath())) {
                viewId = viewId.substring(this.getRequestContextPath().length());
            }
            viewId = this.getViewIdFromPath(viewId);
        }
        return viewId;
    }

    protected String getViewIdFromPath(String viewId) {
        int i;
        if (null != this.getServletMappingPrefix() && viewId.startsWith(this.getServletMappingPrefix())) {
            viewId = viewId.substring(this.getServletMappingPrefix().length());
        } else if (null != this.getServletMappingSuffix() && (i = viewId.lastIndexOf(this.getServletMappingSuffix())) >= 0) {
            viewId = viewId.substring(0, i) + this.getDefaultJsfSuffix();
        }
        return viewId;
    }

    @Override
    protected String createResourceUrl(PortalActionURL portalUrl) {
        return RESOURCE_URL_DO_NOTHITG;
    }

    public void dispatch(String path) throws IOException {
        if (null == path) {
            throw new NullPointerException("Path to new view is null");
        }
        PortletRequestDispatcher dispatcher = this.getContext().getRequestDispatcher(path);
        if (null == dispatcher) {
            throw new IllegalStateException("Dispatcher for render request is not created");
        }
        try {
            dispatcher.forward(this.getRequest(), this.getResponse());
        }
        catch (PortletException e) {
            throw new FacesException((Throwable)e);
        }
    }
}

