/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portletbridge.io;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import javax.servlet.ServletOutputStream;
import org.jboss.portletbridge.io.ByteBuffer;
import org.jboss.portletbridge.io.CharBuffer;
import org.jboss.portletbridge.io.FastBufferOutputStream;

public class FastBufferWriter
extends Writer {
    CharBuffer firstBuffer;
    CharBuffer lastBuffer;
    int length;

    public FastBufferWriter() {
        this(256);
    }

    public FastBufferWriter(int initialSize) {
        this(new CharBuffer(initialSize));
    }

    public FastBufferWriter(CharBuffer firstBuffer) {
        this.firstBuffer = firstBuffer;
        this.lastBuffer = firstBuffer;
    }

    public void write(int c) throws IOException {
        this.lastBuffer = this.lastBuffer.append((char)c);
        ++this.length;
    }

    public void write(char[] cbuf) throws IOException {
        if (cbuf == null) {
            throw new NullPointerException();
        }
        this.lastBuffer = this.lastBuffer.append(cbuf, 0, cbuf.length);
        this.length += cbuf.length;
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        if (cbuf == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > cbuf.length || len < 0 || off + len > cbuf.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        this.lastBuffer = this.lastBuffer.append(cbuf, off, len);
        this.length += len;
    }

    public int getLength() {
        return this.length;
    }

    public CharBuffer getFirstBuffer() {
        return this.firstBuffer;
    }

    public void close() throws IOException {
    }

    public void flush() throws IOException {
    }

    public char[] toCharArray() {
        CharBuffer b = this.firstBuffer;
        if (b == null) {
            return new char[0];
        }
        CharBuffer l = b;
        while (l.getNext() != null) {
            l = l.getNext();
        }
        char[] result = new char[l.getTotalSize()];
        int index = 0;
        while (b != null) {
            int s = b.getUsedSize();
            System.arraycopy(b.getChars(), 0, result, index, s);
            index += s;
            b = b.getNext();
        }
        return result;
    }

    public String toString() {
        return new String(this.toCharArray());
    }

    public void writeTo(Writer writer) throws IOException {
        for (CharBuffer b = this.firstBuffer; b != null; b = b.getNext()) {
            writer.write(b.getChars(), 0, b.getUsedSize());
        }
    }

    public void printTo(ServletOutputStream outputStream) throws IOException {
        for (CharBuffer b = this.firstBuffer; b != null; b = b.getNext()) {
            outputStream.print(new String(b.getChars()));
        }
    }

    public FastBufferOutputStream convertToOutputStream(String encoding) throws UnsupportedEncodingException {
        ByteBuffer first;
        CharBuffer c = this.firstBuffer;
        ByteBuffer b = first = c.toByteBuffer(encoding);
        while (c != null && (c = c.getNext()) != null) {
            ByteBuffer n = c.toByteBuffer(encoding);
            b.setNext(n);
            b = n;
        }
        return new FastBufferOutputStream(first);
    }

    public FastBufferOutputStream convertToOutputStream() {
        ByteBuffer first;
        CharBuffer c = this.firstBuffer;
        ByteBuffer b = first = c.toByteBuffer();
        while (c != null && (c = c.getNext()) != null) {
            ByteBuffer n = c.toByteBuffer();
            b.setNext(n);
            b = n;
        }
        return new FastBufferOutputStream(first);
    }

    public void reset() {
        this.firstBuffer.reset();
        this.lastBuffer = this.firstBuffer;
        this.length = 0;
    }
}

