/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portletbridge.richfaces;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.logging.Logger;
import javax.faces.context.FacesContext;
import org.ajax4jsf.Messages;
import org.ajax4jsf.javascript.ScriptUtils;
import org.ajax4jsf.resource.InternetResource;
import org.ajax4jsf.resource.ResourceContext;
import org.ajax4jsf.resource.ResourceRenderer;
import org.jboss.portletbridge.richfaces.CountingOutputStream;
import org.jboss.portletbridge.richfaces.ResourceContextWrapper;
import org.jboss.portletbridge.util.BridgeLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletScriptRenderer
implements ResourceRenderer {
    private static final Logger _log = BridgeLogger.AJAX.getLogger();
    private static final String BRIDGE_WRAP_SCRIPTS = "org.jboss.portletbridge.WRAP_SCRIPTS";
    private final ResourceRenderer parent;

    public PortletScriptRenderer(ResourceRenderer parent) {
        this.parent = parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int send(InternetResource base, ResourceContext context) throws IOException {
        InputStream in = base.getResourceAsStream(context);
        if (null == in) {
            String message = Messages.getMessage((String)"NO_INPUT_STREAM_ERROR", (Object)base.getKey());
            throw new IOException(message);
        }
        boolean wrapScript = false;
        OutputStream out = context.getOutputStream();
        CountingOutputStream countingStream = new CountingOutputStream(out);
        try {
            if ("true".equalsIgnoreCase(context.getInitParameter(BRIDGE_WRAP_SCRIPTS))) {
                String scriptId = base.getKey();
                scriptId = "RF_" + ScriptUtils.getValidJavascriptName((String)scriptId);
                out.write(("if(!window." + scriptId + "){\nwindow." + scriptId + " = {};\n").getBytes());
                wrapScript = true;
            }
            this.parent.send(base, (ResourceContext)new ResourceContextWrapper(context, countingStream));
            if (wrapScript) {
                countingStream.write("\n}\n".getBytes());
            }
        }
        finally {
            in.close();
            out.flush();
            out.close();
        }
        return countingStream.getWritten();
    }

    public void encode(InternetResource resource, FacesContext context, Object data, Map<String, Object> attributes) throws IOException {
        this.parent.encode(resource, context, data, attributes);
    }

    public void encode(InternetResource resource, FacesContext context, Object data) throws IOException {
        this.parent.encode(resource, context, data);
    }

    public void encodeBegin(InternetResource resource, FacesContext context, Object data, Map<String, Object> attributes) throws IOException {
        this.parent.encodeBegin(resource, context, data, attributes);
    }

    public void encodeEnd(InternetResource resource, FacesContext context, Object data) throws IOException {
        this.parent.encodeEnd(resource, context, data);
    }

    public String getContentType() {
        return this.parent.getContentType();
    }

    public Object getData(InternetResource base, FacesContext context, Object data) {
        return this.parent.getData(base, context, data);
    }

    public boolean requireFacesContext() {
        return this.parent.requireFacesContext();
    }
}

