/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portletbridge.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.portlet.MimeResponse;
import javax.portlet.ResourceURL;
import org.jboss.portletbridge.util.BridgeLogger;

public class PlatformUtil {
    private static final Logger log = BridgeLogger.AJAX.getLogger();

    public static ResourceURL createResourceURL(MimeResponse response) {
        ResourceURL rurl = response.createResourceURL();
        Platform currentPlatform = PlatformUtil.getPlatform(response);
        if (currentPlatform == Platform.LIFERAY) {
            try {
                Method m = rurl.getClass().getMethod("setCopyCurrentRenderParameters", Boolean.TYPE);
                m.invoke((Object)rurl, false);
            }
            catch (SecurityException e) {
                log.log(Level.SEVERE, "Cannot disable parameter copy inside Liferay", e);
            }
            catch (NoSuchMethodException e) {
                log.log(Level.SEVERE, "Cannot disable parameter copy inside Liferay", e);
            }
            catch (IllegalArgumentException e) {
                log.log(Level.SEVERE, "Cannot disable parameter copy inside Liferay", e);
            }
            catch (IllegalAccessException e) {
                log.log(Level.SEVERE, "Cannot disable parameter copy inside Liferay", e);
            }
            catch (InvocationTargetException e) {
                log.log(Level.SEVERE, "Cannot disable parameter copy inside Liferay", e);
            }
        }
        return rurl;
    }

    private static Platform getPlatform(MimeResponse response) {
        if (response.getClass().getName().indexOf("liferay") > -1) {
            return Platform.LIFERAY;
        }
        return Platform.GENERAL;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Platform {
        NA,
        GENERAL,
        LIFERAY;

    }
}

