/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portletbridge.context.map;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jboss.portletbridge.context.map.EnumerationIterator;

abstract class ContextMap<K, V>
extends AbstractMap<K, V> {
    private volatile transient Set<K> keySet;
    private volatile transient Set<Map.Entry<K, V>> entrySet;

    ContextMap() {
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new AbstractSet<Map.Entry<K, V>>(){

                @Override
                public Iterator<Map.Entry<K, V>> iterator() {
                    return new Iterator<Map.Entry<K, V>>(){
                        private Enumeration<K> enumeration;
                        {
                            this.enumeration = ContextMap.this.getEnumeration();
                        }

                        @Override
                        public boolean hasNext() {
                            return this.enumeration.hasMoreElements();
                        }

                        @Override
                        public Map.Entry<K, V> next() {
                            Object key = this.enumeration.nextElement();
                            return new ContextEntry(key, ContextMap.this.get(key));
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException();
                        }
                    };
                }

                @Override
                public int size() {
                    return ContextMap.this.size();
                }
            };
        }
        return this.entrySet;
    }

    protected boolean isValidParameter(String paramName) {
        return true;
    }

    @Override
    public Set<K> keySet() {
        if (this.keySet == null) {
            this.keySet = new AbstractSet<K>(){

                @Override
                public Iterator<K> iterator() {
                    return new EnumerationIterator(ContextMap.this.getEnumeration());
                }

                @Override
                public int size() {
                    return ContextMap.this.size();
                }
            };
        }
        return this.keySet;
    }

    @Override
    public Collection<V> values() {
        return super.values();
    }

    protected abstract Enumeration<K> getEnumeration();

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public V remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        Enumeration<K> enumeration = this.getEnumeration();
        int size = 0;
        while (enumeration.hasMoreElements()) {
            enumeration.nextElement();
            ++size;
        }
        return size;
    }

    static class ContextEntry<K, V>
    implements Map.Entry<K, V> {
        private final K key;
        private final V value;

        ContextEntry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            throw new UnsupportedOperationException();
        }
    }
}

