/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portletbridge.renderkit.portlet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;
import javax.portlet.PortletRequest;
import org.jboss.portletbridge.bridge.context.BridgeContext;
import org.jboss.portletbridge.bridge.logger.BridgeLogger;
import org.jboss.portletbridge.bridge.logger.JULLoggerImpl;
import org.jboss.portletbridge.renderkit.portlet.HeadResources;
import org.jboss.portletbridge.renderkit.portlet.PortletHeadResponseWriter;
import org.jboss.portletbridge.util.RequestHelper;

public class PortletHeadRenderer
extends Renderer {
    private static BridgeLogger logger = new JULLoggerImpl(PortletHeadRenderer.class.getName());
    static final String HEAD = "head";
    static final String BODY = "body";
    static final String ORIGINAL_TARGET = "originalTarget";
    private static final String ADDED = UIComponentBase.class.getName() + ".ADDED";

    public void decode(FacesContext context, UIComponent component) {
    }

    public void encodeBegin(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        logger.log(BridgeLogger.Level.INFO, "PortletHeadRenderer encodeBegin()");
        List<UIComponent> sortedHeadComponents = this.buildComponentAddSequence(uiComponent, facesContext);
        ArrayList<UIComponent> addToHead = new ArrayList<UIComponent>();
        ArrayList<UIComponent> moveToBody = new ArrayList<UIComponent>();
        ExternalContext externalContext = facesContext.getExternalContext();
        PortletRequest portletRequest = (PortletRequest)externalContext.getRequest();
        boolean canMarkupHead = RequestHelper.canMarkupHead(portletRequest);
        HeadResources headBean = HeadResources.instance();
        HashSet<String> resourceIds = null != headBean ? headBean.getIds() : new HashSet<String>();
        this.splitResourcesBetweenHeadAndBody(addToHead, moveToBody, sortedHeadComponents, facesContext, resourceIds, canMarkupHead);
        if (canMarkupHead) {
            ResponseWriter existingWriter = facesContext.getResponseWriter();
            Object headWriter = (ResponseWriter)portletRequest.getAttribute("headWriter");
            if (null == headWriter) {
                headWriter = new PortletHeadResponseWriter(existingWriter, BridgeContext.getCurrentInstance().getPortletResponse());
            }
            portletRequest.setAttribute("headWriter", headWriter);
            facesContext.setResponseWriter(headWriter);
            for (UIComponent headResource : addToHead) {
                headResource.encodeAll(facesContext);
                resourceIds.add(this.generateComponentId(headResource));
            }
            facesContext.setResponseWriter(existingWriter);
        }
        UIViewRoot viewRoot = facesContext.getViewRoot();
        for (UIComponent componentResource : moveToBody) {
            componentResource.getAttributes().put(ORIGINAL_TARGET, HEAD);
            componentResource.getAttributes().put(ADDED, Boolean.TRUE);
            viewRoot.addComponentResource(facesContext, componentResource, BODY);
        }
    }

    protected void splitResourcesBetweenHeadAndBody(List<UIComponent> head, List<UIComponent> body, List<UIComponent> components, FacesContext facesContext, Set<String> resourceIds, boolean canMarkupHead) {
        boolean isAjax = facesContext.getPartialViewContext().isAjaxRequest();
        for (UIComponent component : components) {
            if (isAjax) {
                if (resourceIds.contains(this.generateComponentId(component))) continue;
                body.add(component);
                continue;
            }
            if (canMarkupHead) {
                head.add(component);
                continue;
            }
            body.add(component);
        }
    }

    protected String generateComponentId(UIComponent component) {
        StringBuilder id = new StringBuilder();
        Map attributes = component.getAttributes();
        Object libraryObject = attributes.get("library");
        Object nameObject = attributes.get("name");
        if (null != libraryObject) {
            id.append(libraryObject);
            id.append(':');
        }
        if (null != nameObject) {
            id.append(nameObject);
        }
        return id.toString();
    }

    protected List<UIComponent> buildComponentAddSequence(UIComponent uiComponent, FacesContext facesContext) {
        List headComponentResources = facesContext.getViewRoot().getComponentResources(facesContext, HEAD);
        ArrayList<UIComponent> headStylesheetComponentResources = null;
        ArrayList<UIComponent> headScriptComponentResources = null;
        for (UIComponent headComponentResource : headComponentResources) {
            String resourceName = (String)headComponentResource.getAttributes().get("name");
            if (null != resourceName && resourceName.endsWith("css")) {
                if (null == headStylesheetComponentResources) {
                    headStylesheetComponentResources = new ArrayList<UIComponent>();
                }
                headStylesheetComponentResources.add(headComponentResource);
                continue;
            }
            if (null == headScriptComponentResources) {
                headScriptComponentResources = new ArrayList<UIComponent>();
            }
            headScriptComponentResources.add(headComponentResource);
        }
        ArrayList<UIComponent> aggregatedComponentResources = new ArrayList<UIComponent>();
        if (null != headStylesheetComponentResources) {
            aggregatedComponentResources.addAll(headStylesheetComponentResources);
        }
        if (null != headScriptComponentResources) {
            aggregatedComponentResources.addAll(headScriptComponentResources);
        }
        return aggregatedComponentResources;
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
    }
}

