/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portletbridge.context;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.faces.FacesException;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.portlet.BaseURL;
import javax.portlet.ClientDataRequest;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletResponse;
import javax.portlet.PortletSession;
import javax.portlet.faces.BridgeDefaultViewNotSpecifiedException;
import javax.servlet.http.Cookie;
import org.jboss.portletbridge.bridge.context.BridgeContext;
import org.jboss.portletbridge.bridge.logger.BridgeLogger;
import org.jboss.portletbridge.bridge.scope.BridgeRequestScope;
import org.jboss.portletbridge.context.AbstractExternalContext;
import org.jboss.portletbridge.context.PortalActionURL;
import org.jboss.portletbridge.context.RenderPortletExternalContextImpl;
import org.jboss.portletbridge.context.map.EnumerationIterator;

public abstract class PortletExternalContextImpl
extends AbstractExternalContext {
    public static final String SERVLET_PATH_ATTRIBUTE = "javax.servlet.include.servlet_path";
    public static final String PATH_INFO_ATTRIBUTE = "javax.servlet.include.path_info";
    public static final String ACTION_URL_DO_NOTHITG = "/JBossPortletBridge/actionUrl/do/nothing";
    public static final String RESOURCE_URL_DO_NOTHITG = "/JBossPortletBridge/resourceUrl/do/nothing";
    public static final String PARTIAL_URL_DO_NOTHITG = "/JBossPortletBridge/resourceUrl/do/nothing";
    public static final String WSRP_REWRITE = "wsrp_rewrite";
    public static final String WSRP_REWRITE_WITH_QUESTION = "wsrp_rewrite?";
    public static final String NAMESPACE_PREFIX = "pb";
    private String namespace;
    private String servletPath = null;
    private String pathInfo = null;
    private String servletMappingSuffix;
    private String defaultJsfSuffix;
    private String servletMappingPrefix;
    private String viewId;
    private boolean hasNavigationRedirect = false;
    protected final Map<String, Map<String, String[]>> encodedActionUrlParameters = new HashMap<String, Map<String, String[]>>();
    private Map<String, String[]> extraRequestParameters = new HashMap<String, String[]>();
    protected BridgeContext bridgeContext = BridgeContext.getCurrentInstance();
    protected String acceptHeader;
    protected String acceptLangHeader;
    protected String contentType;
    protected String contentLength;

    public PortletExternalContextImpl(PortletContext context, PortletRequest request, PortletResponse response) {
        super(context, request, response);
        Map params;
        BridgeRequestScope scope;
        if (null == this.bridgeContext) {
            throw new FacesException("No BridgeContext instance found");
        }
        String defaultRenderKitId = this.bridgeContext.getBridgeConfig().getDefaultRenderKitId();
        if (null != defaultRenderKitId && null == request.getParameter("javax.faces.RenderKitId")) {
            this.extraRequestParameters.put("javax.faces.RenderKitId", new String[]{defaultRenderKitId});
        }
        if (null != (scope = this.bridgeContext.getBridgeScope()) && null != (params = (Map)scope.get((Object)"org.jboss.portletbridge.actionParameters")) && params.size() > 0) {
            this.extraRequestParameters.putAll(params);
        }
    }

    public void setResponseCharacterEncoding(String encoding) {
    }

    public void setRequestCharacterEncoding(String encoding) throws UnsupportedEncodingException {
    }

    public void setResponseStatus(int statusCode) {
    }

    @Override
    public void setRequest(Object request) {
        super.setRequest(request);
        if (null != this.viewId) {
            this.calculateViewId();
        }
    }

    public void redirect(String url) throws IOException {
    }

    public String getResponseCharacterEncoding() {
        throw new IllegalStateException("PortletExternalContextImpl.getResponseCharacterEncoding(): Response must be a MimeResponse");
    }

    public String getResponseContentType() {
        throw new IllegalStateException("PortletExternalContextImpl.getResponseContentType(): Response must be a MimeResponse");
    }

    public String getRequestContentType() {
        return null;
    }

    public PortletContext getContext() {
        return (PortletContext)super.getContext();
    }

    public PortletRequest getPortletRequest() {
        return (PortletRequest)super.getRequest();
    }

    public PortletResponse getPortletResponse() {
        return (PortletResponse)super.getResponse();
    }

    public String getInitParameter(String name) {
        return this.getContext().getInitParameter(name);
    }

    @Override
    protected String getNamespace() {
        if (null == this.namespace) {
            this.namespace = this.getPortletResponse().getNamespace();
            if (this.namespace.startsWith(WSRP_REWRITE)) {
                this.namespace = this.bridgeContext.getBridgeConfig().getPortletConfig().getPortletName() + this.bridgeContext.getPortletContext().getPortletContextName();
            }
            if (this.bridgeContext.getBridgeConfig().isComponentNamespaceShortened()) {
                String hashString;
                int hashStringLen;
                int hash = this.namespace.hashCode();
                if (hash < 0) {
                    hash *= -1;
                }
                if ((hashStringLen = (hashString = Integer.toString(hash)).length()) > 5) {
                    hashString = hashString.substring(hashStringLen - 5);
                }
                this.namespace = hashString;
            }
            this.namespace = NAMESPACE_PREFIX + this.namespace;
        }
        return this.namespace;
    }

    public URL getResource(String path) throws MalformedURLException {
        return this.getContext().getResource(path);
    }

    public InputStream getResourceAsStream(String path) {
        return this.getContext().getResourceAsStream(path);
    }

    public Set<String> getResourcePaths(String path) {
        return this.getContext().getResourcePaths(path);
    }

    @Override
    protected Enumeration<String> enumerateRequestParameterNames() {
        ArrayList<String> names = new ArrayList<String>();
        Enumeration paramNames = this.getPortletRequest().getParameterNames();
        while (paramNames.hasMoreElements()) {
            String name = (String)paramNames.nextElement();
            names.add(name);
        }
        if (!names.contains("javax.faces.ViewState")) {
            names.add("javax.faces.ViewState");
        }
        names.addAll(this.extraRequestParameters.keySet());
        return Collections.enumeration(names);
    }

    @Override
    protected Object getContextAttribute(String name) {
        return this.getContext().getAttribute(name);
    }

    @Override
    protected Enumeration<String> getContextAttributeNames() {
        return this.getContext().getAttributeNames();
    }

    @Override
    protected Enumeration<String> getInitParametersNames() {
        return this.getContext().getInitParameterNames();
    }

    @Override
    protected Object getRequestAttribute(String name) {
        if (PATH_INFO_ATTRIBUTE.equals(name)) {
            return this.getRequestPathInfo();
        }
        if (SERVLET_PATH_ATTRIBUTE.equals(name)) {
            return this.getRequestServletPath();
        }
        return this.getPortletRequest().getAttribute(name);
    }

    @Override
    protected Enumeration<String> getRequestAttributeNames() {
        return this.getPortletRequest().getAttributeNames();
    }

    @Override
    protected String[] getRequestParameterValues(String name) {
        String[] temp = this.getPortletRequest().getParameterValues(name);
        if (null == temp || temp.length == 0) {
            if ("javax.faces.ViewState".equals(name)) {
                BridgeRequestScope scope = this.bridgeContext.getBridgeScope();
                if (null != scope) {
                    temp = new String[]{(String)scope.get((Object)"org.jboss.portletbridge.faces.ViewState")};
                }
            } else {
                temp = this.extraRequestParameters.get(name);
            }
        }
        return temp;
    }

    protected void constructAcceptLanguageHeader() {
        Enumeration locales = this.getPortletRequest().getLocales();
        StringBuilder acceptLangHeader = new StringBuilder(64);
        boolean found = false;
        while (locales.hasMoreElements()) {
            String temp;
            Locale locale = (Locale)locales.nextElement();
            if (locale == null) continue;
            if (found) {
                acceptLangHeader.append(',');
            } else {
                found = true;
            }
            if ((temp = locale.getLanguage()).length() <= 0) continue;
            acceptLangHeader.append(temp);
            temp = locale.getCountry();
            if (temp.length() <= 0) continue;
            acceptLangHeader.append('-');
            acceptLangHeader.append(temp);
        }
        this.acceptLangHeader = found ? acceptLangHeader.toString() : null;
    }

    protected void constructAcceptHeader() {
        Enumeration contentTypes = this.getPortletRequest().getResponseContentTypes();
        StringBuilder acceptHeader = new StringBuilder(64);
        boolean found = false;
        while (contentTypes.hasMoreElements()) {
            String type = (String)contentTypes.nextElement();
            if (type == null) continue;
            if (found) {
                acceptHeader.append(',');
            } else {
                found = true;
            }
            acceptHeader.append(type);
        }
        this.acceptHeader = found ? acceptHeader.toString() : null;
    }

    protected void constructContentType() {
        StringBuilder contentTypeBuilder = new StringBuilder(64);
        String contentType = ((ClientDataRequest)this.getRequest()).getContentType();
        String charset = ((ClientDataRequest)this.getRequest()).getCharacterEncoding();
        if (null != contentType) {
            int index = contentType.indexOf(59);
            if (index < 0) {
                contentTypeBuilder.append(contentType);
            } else {
                contentTypeBuilder.append(contentType, 0, index);
            }
            if (null != charset) {
                contentTypeBuilder.append("; charset=");
                contentTypeBuilder.append(charset);
            }
            this.contentType = contentTypeBuilder.toString();
        }
    }

    protected void constructContentLength() {
        int contentLength = ((ClientDataRequest)this.getRequest()).getContentLength();
        if (contentLength != -1) {
            this.contentLength = String.valueOf(contentLength);
        }
    }

    @Override
    protected String getRequestHeader(String name) {
        if ("ACCEPT".equalsIgnoreCase(name)) {
            if (null == this.acceptHeader) {
                this.constructAcceptHeader();
            }
            return this.acceptHeader;
        }
        if ("ACCEPT-LANGUAGE".equalsIgnoreCase(name)) {
            if (null == this.acceptLangHeader) {
                this.constructAcceptLanguageHeader();
            }
            return this.acceptLangHeader;
        }
        if ("CONTENT-TYPE".equalsIgnoreCase(name)) {
            return null;
        }
        if ("CONTENT-LENGTH".equalsIgnoreCase(name)) {
            return null;
        }
        String headerValue = this.getPortletRequest().getProperty(name);
        if (null == headerValue) {
            headerValue = this.getPortletRequest().getProperty(name.toLowerCase());
        }
        return headerValue;
    }

    @Override
    protected Enumeration<String> getRequestHeaderNames() {
        ArrayList<String> names = new ArrayList<String>();
        Enumeration propNames = this.getPortletRequest().getPropertyNames();
        while (propNames.hasMoreElements()) {
            String name = (String)propNames.nextElement();
            if ("CONTENT-TYPE".equalsIgnoreCase(name) || "CONTENT-LENGTH".equalsIgnoreCase(name)) continue;
            names.add(name);
        }
        names.add("ACCEPT");
        names.add("ACCEPT-LANGUAGE");
        return Collections.enumeration(names);
    }

    @Override
    protected String[] getRequestHeaderValues(String name) {
        if ("ACCEPT".equalsIgnoreCase(name)) {
            if (null == this.acceptHeader) {
                this.constructAcceptHeader();
            }
            return new String[]{this.acceptHeader};
        }
        if ("ACCEPT-LANGUAGE".equalsIgnoreCase(name)) {
            if (null == this.acceptLangHeader) {
                this.constructAcceptLanguageHeader();
            }
            return new String[]{this.acceptLangHeader};
        }
        if ("CONTENT-TYPE".equalsIgnoreCase(name)) {
            return null;
        }
        if ("CONTENT-LENGTH".equalsIgnoreCase(name)) {
            return null;
        }
        Enumeration properties = this.getPortletRequest().getProperties(name);
        if (!properties.hasMoreElements()) {
            properties = this.getPortletRequest().getProperties(name.toLowerCase());
        }
        if (properties.hasMoreElements()) {
            ArrayList<String> values = new ArrayList<String>();
            while (properties.hasMoreElements()) {
                String value = (String)properties.nextElement();
                values.add(value);
            }
            return values.toArray(EMPTY_STRING_ARRAY);
        }
        return null;
    }

    @Override
    protected String getRequestParameter(String name) {
        String temp = this.getPortletRequest().getParameter(name);
        if (null == temp) {
            if ("javax.faces.ViewState".equals(name)) {
                BridgeRequestScope scope = this.bridgeContext.getBridgeScope();
                if (null != scope) {
                    temp = (String)scope.get((Object)"org.jboss.portletbridge.faces.ViewState");
                }
            } else {
                String[] tempArray = this.extraRequestParameters.get(name);
                if (null != tempArray && tempArray.length > 0) {
                    temp = this.extraRequestParameters.get(name)[0];
                }
            }
        }
        return temp;
    }

    @Override
    protected Object getSessionAttribute(String name) {
        return this.getSessionAttribute(name, this.getScopeForName(name));
    }

    protected int getScopeForName(String name) {
        return 2;
    }

    protected Object getSessionAttribute(String name, int scope) {
        return this.getPortletRequest().getPortletSession(true).getAttribute(name, scope);
    }

    @Override
    protected Enumeration<String> getSessionAttributeNames() {
        class AttributeEnumeration
        implements Enumeration<String> {
            int scope = 2;
            Enumeration<String> attributes;

            public AttributeEnumeration() {
                this.attributes = PortletExternalContextImpl.this.getSessionAttributeNames(this.scope);
                if (!this.attributes.hasMoreElements()) {
                    this.scope = 1;
                    this.attributes = PortletExternalContextImpl.this.getSessionAttributeNames(this.scope);
                }
            }

            @Override
            public boolean hasMoreElements() {
                return this.attributes.hasMoreElements();
            }

            @Override
            public String nextElement() {
                String result = this.attributes.nextElement();
                if (!this.attributes.hasMoreElements() && this.scope == 2) {
                    this.scope = 1;
                    this.attributes = PortletExternalContextImpl.this.getSessionAttributeNames(this.scope);
                }
                return result;
            }
        }
        return new AttributeEnumeration();
    }

    protected Enumeration<String> getSessionAttributeNames(int scope) {
        return this.getPortletRequest().getPortletSession(true).getAttributeNames(scope);
    }

    @Override
    protected void removeContextAttribute(String name) {
        this.getContext().removeAttribute(name);
    }

    @Override
    protected void removeRequestAttribute(String name) {
        this.getPortletRequest().removeAttribute(name);
    }

    @Override
    protected void removeSessionAttribute(String name) {
        this.removeSessionAttribute(name, this.getScopeForName(name));
    }

    protected void removeSessionAttribute(String name, int scope) {
        this.getPortletRequest().getPortletSession(true).removeAttribute(name, scope);
    }

    @Override
    protected void setContextAttribute(String name, Object value) {
        this.getContext().setAttribute(name, value);
    }

    @Override
    protected void setRequestAttribute(String name, Object value) {
        this.getPortletRequest().setAttribute(name, value);
    }

    @Override
    protected void setSessionAttribute(String name, Object value) {
        this.setSessionAttribute(name, value, this.getScopeForName(name));
    }

    protected void setSessionAttribute(String name, Object value, int scope) {
        this.getPortletRequest().getPortletSession(true).setAttribute(name, value, scope);
    }

    protected String encodeURL(String url) {
        return this.getPortletResponse().encodeURL(url);
    }

    protected String replaceUrlWhitespace(String url) {
        return url.replace(" ", "%20");
    }

    public String getAuthType() {
        return this.getPortletRequest().getAuthType();
    }

    public String getRemoteUser() {
        Principal userPrincipal;
        String user = this.getPortletRequest().getRemoteUser();
        if (user == null && null != (userPrincipal = this.getUserPrincipal())) {
            user = userPrincipal.getName();
        }
        return user;
    }

    public String getRequestContextPath() {
        return this.getPortletRequest().getContextPath();
    }

    public Locale getRequestLocale() {
        return this.getPortletRequest().getLocale();
    }

    public Iterator<Locale> getRequestLocales() {
        return new EnumerationIterator<Locale>(this.getPortletRequest().getLocales());
    }

    public String getRequestPathInfo() {
        if (null == this.viewId) {
            this.calculateViewId();
        }
        return this.pathInfo;
    }

    public String getRequestServletPath() {
        if (null == this.viewId) {
            this.calculateViewId();
        }
        return this.servletPath;
    }

    public Object getSession(boolean create) {
        return this.getPortletRequest().getPortletSession(create);
    }

    public Principal getUserPrincipal() {
        return this.getPortletRequest().getUserPrincipal();
    }

    public boolean isUserInRole(String role) {
        return this.getPortletRequest().isUserInRole(role);
    }

    public void log(String message) {
        this.getContext().log(message);
    }

    public void log(String message, Throwable exception) {
        this.getContext().log(message, exception);
    }

    protected void calculateViewId() {
        String newViewId = this.bridgeContext.getFacesViewIdFromRequest(false);
        if (null == newViewId && null == (newViewId = this.bridgeContext.getDefaultFacesViewIdForRequest(false))) {
            throw new BridgeDefaultViewNotSpecifiedException();
        }
        if (null != newViewId) {
            newViewId = this.processViewParameters(newViewId);
        }
        if (null != newViewId && newViewId.equals(this.viewId)) {
            return;
        }
        this.viewId = newViewId;
        this.calculateServletPath(this.viewId, this.bridgeContext.getBridgeConfig().getFacesServletMappings());
    }

    protected String processViewParameters(String newViewId) {
        try {
            PortalActionURL portalUrl = new PortalActionURL(newViewId);
            if (portalUrl.parametersSize() > 0) {
                Map<String, String[]> params = portalUrl.getParameters();
                for (Map.Entry<String, String[]> entry : params.entrySet()) {
                    this.extraRequestParameters.put(entry.getKey(), entry.getValue());
                }
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return newViewId;
    }

    protected void calculateServletPath(String viewId, List<String> servletMappings) {
        if (null != servletMappings && servletMappings.size() > 0) {
            String mapping = servletMappings.get(0);
            if (mapping.startsWith("*")) {
                this.servletMappingSuffix = mapping.substring(mapping.indexOf(46));
                this.servletPath = viewId = viewId.substring(0, viewId.lastIndexOf(46)) + this.servletMappingSuffix;
                this.pathInfo = null;
                this.getPortletRequest().setAttribute(SERVLET_PATH_ATTRIBUTE, (Object)this.servletPath);
                this.getPortletRequest().setAttribute("com.sun.faces.INVOCATION_PATH", (Object)this.servletMappingSuffix);
            } else if (mapping.endsWith("*")) {
                if ((mapping = mapping.substring(0, mapping.length() - 1)).endsWith("/")) {
                    mapping = mapping.substring(0, mapping.length() - 1);
                }
                this.servletMappingPrefix = this.servletPath = mapping;
                this.pathInfo = viewId;
                this.getPortletRequest().setAttribute("com.sun.faces.INVOCATION_PATH", (Object)this.servletMappingSuffix);
            } else {
                this.servletPath = null;
                this.pathInfo = viewId;
            }
        } else {
            this.servletPath = null;
            this.pathInfo = viewId;
        }
    }

    protected void internalRedirect(PortalActionURL actionURL) {
        String viewId = actionURL.getParameter("_jsfBridgeViewId");
        if (null != viewId) {
            this.bridgeContext.setRenderRedirect(true);
            this.bridgeContext.setRedirectViewId(viewId);
            Map<String, String[]> requestParameters = actionURL.getParameters();
            if (requestParameters.size() > 0) {
                this.bridgeContext.setRenderRedirectQueryString(actionURL.getQueryString());
            }
        }
    }

    public String getServletMappingSuffix() {
        return this.servletMappingSuffix;
    }

    public String getDefaultJsfSuffix() {
        return this.defaultJsfSuffix;
    }

    public String getServletMappingPrefix() {
        return this.servletMappingPrefix;
    }

    protected String getViewIdFromUrl(PortalActionURL url) {
        String viewId = url.getParameter("_jsfBridgeViewId");
        if (null == viewId) {
            viewId = url.getPath();
            if (viewId.startsWith(this.getRequestContextPath())) {
                viewId = viewId.substring(this.getRequestContextPath().length());
            }
            viewId = this.bridgeContext.getFacesViewIdFromPath(viewId);
        }
        return viewId;
    }

    public void dispatch(String path) throws IOException {
        if (null == path) {
            throw new IllegalArgumentException("Path to new view is null");
        }
        PortletRequestDispatcher dispatcher = this.getContext().getRequestDispatcher(path);
        if (null == dispatcher) {
            throw new IllegalStateException("Dispatcher for render request is not created");
        }
        try {
            boolean hasRenderRedirectedAfterForward = this.bridgeContext.hasRenderRedirectAfterDispatch();
            if (!hasRenderRedirectedAfterForward) {
                dispatcher.forward(this.getPortletRequest(), this.getPortletResponse());
            } else {
                dispatcher.include(this.getPortletRequest(), this.getPortletResponse());
            }
        }
        catch (PortletException e) {
            throw new FacesException((Throwable)e);
        }
    }

    public String getMimeType(String file) {
        String mimeType = this.getContext().getMimeType(file);
        if (mimeType == null) {
            mimeType = this.getFallbackMimeType(file);
        }
        return mimeType;
    }

    public String getContextName() {
        return this.getContext().getPortletContextName();
    }

    public String getRealPath(String path) {
        return this.getContext().getRealPath(path);
    }

    public String getRequestScheme() {
        return this.getPortletRequest().getScheme();
    }

    public String getRequestServerName() {
        return this.getPortletRequest().getServerName();
    }

    public int getRequestServerPort() {
        return this.getPortletRequest().getServerPort();
    }

    @Override
    protected Object getRequestCookie(String key) {
        Cookie value = null;
        Cookie[] cookies = this.getPortletRequest().getCookies();
        if (null != key && null != cookies) {
            for (Cookie cookie : cookies) {
                if (!key.equalsIgnoreCase(cookie.getName())) continue;
                value = cookie;
                break;
            }
        }
        return value;
    }

    @Override
    protected Enumeration<String> getRequestCookieNames() {
        Cookie[] cookies = this.getPortletRequest().getCookies();
        ArrayList<String> names = null;
        if (null != cookies) {
            names = new ArrayList<String>();
            for (Cookie cookie : cookies) {
                names.add(cookie.getName());
            }
        }
        return Collections.enumeration(names);
    }

    public void invalidateSession() {
        PortletSession session = this.getPortletRequest().getPortletSession(false);
        if (session != null) {
            session.invalidate();
        }
    }

    public boolean isSecure() {
        return this.getPortletRequest().isSecure();
    }

    boolean isHasNavigationRedirect() {
        return this.hasNavigationRedirect;
    }

    void setHasNavigationRedirect(boolean hasNavigationRedirect) {
        this.hasNavigationRedirect = hasNavigationRedirect;
    }

    public String encodeActionURL(String url) {
        Map<Object, Object> actionParameters;
        if (null == url) {
            this.getLogger().log(BridgeLogger.Level.WARNING, "Unable to encode ActionURL for url=[null]");
            return null;
        }
        String actionUrl = null;
        if ((url = this.bridgeContext.appendClientWindowId(url)).startsWith("#")) {
            actionUrl = url;
            actionParameters = Collections.emptyMap();
        } else if (url.startsWith(WSRP_REWRITE_WITH_QUESTION)) {
            actionUrl = url;
            actionParameters = Collections.emptyMap();
        } else {
            try {
                boolean escapedUrl = this.isStrictEscaped(url);
                PortalActionURL portalUrl = new PortalActionURL(escapedUrl ? this.unescapeUrl(url) : url, escapedUrl);
                if (!this.isInContext(portalUrl)) {
                    if ("portlet:".equals(portalUrl.getProtocol())) {
                        try {
                            Scheme scheme = Scheme.valueOf(portalUrl.getPath());
                            actionUrl = this.createPortletUrl(scheme, portalUrl, escapedUrl);
                        }
                        catch (IllegalArgumentException e) {
                            actionUrl = url;
                        }
                    } else {
                        String directLink = portalUrl.getParameter("javax.portlet.faces.DirectLink");
                        if (null != directLink && Boolean.parseBoolean(directLink)) {
                            PortletRequest request = this.getPortletRequest();
                            portalUrl.setProtocol(request.getScheme() + ":");
                            portalUrl.setHost("//" + request.getServerName());
                            portalUrl.setPort(request.getServerPort());
                        }
                        actionUrl = this.escapeUrl(escapedUrl, portalUrl.toString());
                    }
                } else {
                    String directLink = portalUrl.getParameter("javax.portlet.faces.DirectLink");
                    if (null != directLink && Boolean.parseBoolean(directLink)) {
                        PortletRequest request = this.getPortletRequest();
                        portalUrl.setProtocol(request.getScheme() + ":");
                        portalUrl.setHost("//" + request.getServerName());
                        portalUrl.setPort(request.getServerPort());
                        String directUrl = portalUrl.toString();
                        return this.escapeUrl(escapedUrl, directUrl);
                    }
                    if (!this.isInContext(portalUrl)) {
                        actionUrl = this.escapeUrl(escapedUrl, portalUrl.toString());
                    } else {
                        String pathInContext = this.calculatePathInContext(portalUrl);
                        if (this.isFacesPath(pathInContext)) {
                            portalUrl.setParameter("_jsfBridgeViewId", this.bridgeContext.getFacesViewIdFromPath(pathInContext));
                            actionUrl = this.createActionUrl(portalUrl, escapedUrl);
                        } else {
                            portalUrl.setParameter("_jsfBridgeNonFacesView", pathInContext);
                            pathInContext = this.calculatePathInContext(portalUrl);
                            portalUrl.setParameter("_jsfBridgeNonFacesView", pathInContext);
                            actionUrl = this.createRenderUrl(portalUrl, escapedUrl, Collections.<String, List<String>>emptyMap());
                        }
                    }
                }
                actionParameters = portalUrl.getParameters();
            }
            catch (MalformedURLException e) {
                actionUrl = url;
                actionParameters = Collections.emptyMap();
            }
        }
        this.encodedActionUrlParameters.put(actionUrl, actionParameters);
        return actionUrl;
    }

    public String encodePartialActionURL(String url) {
        if (null == url) {
            throw new IllegalArgumentException();
        }
        String actionUrl = url = this.bridgeContext.appendClientWindowId(url);
        if (!actionUrl.startsWith("#")) {
            try {
                PortalActionURL portalUrl = new PortalActionURL(url);
                boolean inContext = this.isInContext(portalUrl);
                if (!inContext) {
                    return this.encodeURL(portalUrl.toString());
                }
                actionUrl = this.createPartialActionUrl(portalUrl);
            }
            catch (MalformedURLException e) {
                throw new FacesException((Throwable)e);
            }
        }
        return actionUrl.replaceAll("\\&amp\\;", "&");
    }

    public String encodeResourceURL(String url) {
        try {
            boolean escapedUrl = this.isStrictEscaped(url);
            PortalActionURL portalUrl = new PortalActionURL(url, escapedUrl);
            String path = portalUrl.getPath();
            if (null != portalUrl.getProtocol() && "portlet:".equalsIgnoreCase(portalUrl.getProtocol())) {
                portalUrl.removeParameter("javax.portlet.faces.ViewLink");
                this.encodeBackLink(portalUrl);
                return this.replaceUrlWhitespace(this.encodeActionURL(portalUrl.toString()));
            }
            if (url.startsWith(WSRP_REWRITE_WITH_QUESTION)) {
                url = this.encodeURL(url);
                return url;
            }
            if (this.isOpaqueURL(url)) {
                return url;
            }
            if (!this.isInContext(portalUrl)) {
                portalUrl.removeParameter("javax.portlet.faces.ViewLink");
                this.encodeBackLink(portalUrl);
                return this.replaceUrlWhitespace(this.encodeURL(portalUrl.toString()).replace("&amp;", "&"));
            }
            if ("true".equalsIgnoreCase(portalUrl.getParameter("javax.portlet.faces.ViewLink"))) {
                portalUrl.removeParameter("javax.portlet.faces.ViewLink");
                this.encodeBackLink(portalUrl);
                return this.replaceUrlWhitespace(this.encodeActionURL(portalUrl.toString()));
            }
            portalUrl.removeParameter("javax.portlet.faces.ViewLink");
            this.encodeBackLink(portalUrl);
            if (path.startsWith("/")) {
                if (null == portalUrl.getParameter("_jsfBridgeNonFacesView")) {
                    portalUrl.setPath(path.substring(this.getRequestContextPath().length()));
                }
            } else {
                FacesContext facesContext = FacesContext.getCurrentInstance();
                UIViewRoot viewRoot = facesContext.getViewRoot();
                if (null != viewRoot && null != viewRoot.getViewId() && viewRoot.getViewId().length() > 0) {
                    String viewId = viewRoot.getViewId();
                    int indexOfSlash = viewId.lastIndexOf(47);
                    if (indexOfSlash >= 0) {
                        portalUrl.setPath(viewId.substring(0, indexOfSlash + 1) + path);
                    } else {
                        portalUrl.setPath('/' + path);
                    }
                } else {
                    portalUrl.setPath('/' + path);
                }
            }
            portalUrl.setPath(URI.create(portalUrl.getPath()).normalize().getPath());
            String facesViewId = this.getViewIdFromUrl(portalUrl);
            if (null != portalUrl.getParameter("javax.portlet.faces.InProtocolResourceLink")) {
                portalUrl.removeParameter("javax.portlet.faces.InProtocolResourceLink");
                url = this.createResourceUrl(portalUrl, escapedUrl);
            } else if (portalUrl.getPath().contains("/javax.faces.resource")) {
                this.setupJSFResourceParameters(portalUrl);
                url = this.createResourceUrl(portalUrl, escapedUrl);
            } else if (null != facesViewId) {
                portalUrl.setParameter("_jsfBridgeViewId", facesViewId);
                url = this.createResourceUrl(portalUrl, escapedUrl);
            } else {
                portalUrl.setPath(this.getRequestContextPath() + portalUrl.getPath());
                url = this.encodeURL(portalUrl.toString());
            }
        }
        catch (MalformedURLException e) {
            throw new FacesException((Throwable)e);
        }
        return url;
    }

    protected void setupJSFResourceParameters(PortalActionURL portalUrl) {
        String path = portalUrl.getPath();
        int pos = path.indexOf("/javax.faces.resource");
        if (pos >= 0) {
            String resourceName = path.substring(pos + 1);
            int slash = resourceName.indexOf(47);
            if (slash >= 0) {
                resourceName = resourceName.substring(slash + 1);
            }
            List servletMappings = BridgeContext.getCurrentInstance().getBridgeConfig().getFacesServletMappings();
            for (String mapping : servletMappings) {
                if (!mapping.startsWith("*.") || !resourceName.endsWith(mapping = mapping.substring(1))) continue;
                resourceName = resourceName.substring(0, resourceName.indexOf(mapping));
                break;
            }
            portalUrl.setPath(null);
            portalUrl.addParameter("/javax.faces.resource".substring(1), resourceName);
        }
    }

    public String encodeBookmarkableURL(String baseUrl, Map<String, List<String>> parameters) {
        if (null == baseUrl) {
            throw new IllegalArgumentException();
        }
        String actionUrl = baseUrl = this.bridgeContext.appendClientWindowId(baseUrl);
        if (!actionUrl.startsWith("#")) {
            try {
                PortalActionURL portalUrl = new PortalActionURL(baseUrl);
                boolean inContext = this.isInContext(portalUrl);
                if (!inContext) {
                    return this.encodeURL(portalUrl.toString());
                }
                actionUrl = this.createRenderUrl(portalUrl, this.isStrictEscaped(baseUrl), parameters);
            }
            catch (MalformedURLException e) {
                throw new FacesException((Throwable)e);
            }
        }
        return actionUrl.replaceAll("\\&amp\\;", "&");
    }

    public String encodeRedirectURL(String baseUrl, Map<String, List<String>> parameters) {
        baseUrl = this.bridgeContext.appendClientWindowId(baseUrl);
        try {
            PortalActionURL portalUrl = new PortalActionURL(baseUrl);
            if (null != parameters && !parameters.isEmpty()) {
                for (Map.Entry<String, List<String>> entry : parameters.entrySet()) {
                    for (String value : entry.getValue()) {
                        portalUrl.addParameter(entry.getKey(), value);
                    }
                }
            }
            return this.encodeURL(portalUrl.toString());
        }
        catch (MalformedURLException e) {
            throw new FacesException((Throwable)e);
        }
    }

    protected boolean isAbsoluteURL(String url) {
        if ((url = url.toLowerCase()).startsWith("http:") || url.startsWith("https:")) {
            return true;
        }
        int i = url.indexOf(58);
        if (i == -1) {
            return false;
        }
        String scheme = url.substring(0, i);
        if (scheme.indexOf(59) != -1) {
            return false;
        }
        if (scheme.indexOf(47) != -1) {
            return false;
        }
        if (scheme.indexOf(35) != -1) {
            return false;
        }
        if (scheme.indexOf(63) != -1) {
            return false;
        }
        return scheme.indexOf(32) == -1;
    }

    protected boolean isOpaqueURL(String url) {
        if (!this.isAbsoluteURL(url)) {
            return false;
        }
        return !url.startsWith("portlet:") && url.indexOf(58) != url.indexOf(47) - 1;
    }

    protected String unescapeUrl(String actionUrl) {
        return actionUrl.replaceAll("\\&amp\\;", "&");
    }

    protected boolean isStrictEscaped(String url) {
        int queryStart = url.indexOf(63);
        if (queryStart < 0) {
            return false;
        }
        return url.indexOf("&amp;", queryStart) > 0;
    }

    protected String escapeUrl(boolean escapedUrl, String directUrl) {
        if (escapedUrl) {
            directUrl = directUrl.replaceAll("\\&", "&amp;");
        }
        return directUrl;
    }

    protected boolean isInContext(PortalActionURL portalUrl) {
        String directLink = portalUrl.getParameter("javax.portlet.faces.DirectLink");
        if (null != directLink) {
            if (Boolean.parseBoolean(directLink)) {
                return false;
            }
            portalUrl.removeParameter("javax.portlet.faces.DirectLink");
        }
        return portalUrl.isInContext(this.getRequestContextPath());
    }

    protected boolean isFacesPath(String pathInContext) {
        List mappings = this.bridgeContext.getBridgeConfig().getFacesServletMappings();
        if (null != this.getServletMappingPrefix()) {
            boolean isPrefixMapped = pathInContext.startsWith(this.getServletMappingPrefix());
            if (!isPrefixMapped) {
                for (String mapping : mappings) {
                    if (!mapping.startsWith("*.") || !(isPrefixMapped = pathInContext.endsWith(mapping.substring(2)))) continue;
                    return isPrefixMapped;
                }
            }
            return isPrefixMapped;
        }
        if (null != this.getServletMappingSuffix()) {
            boolean isSuffixMapped = pathInContext.endsWith(this.getServletMappingSuffix());
            if (!isSuffixMapped) {
                for (String mapping : mappings) {
                    if (!mapping.endsWith("*")) continue;
                    if ((mapping = mapping.substring(0, mapping.length() - 1)).endsWith("/")) {
                        mapping = mapping.substring(0, mapping.length() - 1);
                    }
                    if (!(isSuffixMapped = pathInContext.startsWith(mapping))) continue;
                    return isSuffixMapped;
                }
            }
            return isSuffixMapped;
        }
        return true;
    }

    protected String calculatePathInContext(PortalActionURL portalURL) {
        String inContextPath;
        String path = portalURL.getPath();
        if (path.startsWith("/")) {
            if (portalURL.getParameter("_jsfBridgeNonFacesView") != null) {
                return path;
            }
            inContextPath = path.substring(this.getRequestContextPath().length());
            int index = inContextPath.lastIndexOf(";" + this.bridgeContext.getBridgeConfig().getSessionIdParameterName());
            if (index != -1) {
                inContextPath = inContextPath.substring(0, index);
            }
        } else {
            String viewId;
            int indexOfSlash;
            FacesContext facesContext = FacesContext.getCurrentInstance();
            UIViewRoot viewRoot = facesContext.getViewRoot();
            inContextPath = null != viewRoot && null != viewRoot.getViewId() && viewRoot.getViewId().length() > 0 ? ((indexOfSlash = (viewId = viewRoot.getViewId()).lastIndexOf(47)) >= 0 ? viewId.substring(0, indexOfSlash + 1) + path : '/' + path) : '/' + path;
        }
        inContextPath = URI.create(inContextPath).normalize().getPath();
        return inContextPath;
    }

    protected String createPortletUrl(Scheme protocol, PortalActionURL portalUrl, boolean escape) {
        this.processJsfViewParameter(portalUrl, "_jsfBridgeViewId");
        this.processJsfViewParameter(portalUrl, "_jsfBridgeViewPath");
        switch (protocol) {
            case action: {
                return this.createActionUrl(portalUrl, escape);
            }
            case resource: {
                return this.createResourceUrl(portalUrl, escape);
            }
            case render: {
                return this.createRenderUrl(portalUrl, escape, Collections.<String, List<String>>emptyMap());
            }
        }
        return portalUrl.toString();
    }

    protected void processJsfViewParameter(PortalActionURL portalUrl, String facesViewParameter) {
        if (portalUrl.hasParameter(facesViewParameter) && "_jsfBridgeCurrentView".equals(portalUrl.getParameter("_jsfBridgeViewId"))) {
            portalUrl.removeParameter("_jsfBridgeViewId");
            if (this instanceof RenderPortletExternalContextImpl) {
                portalUrl.getParameters().putAll(this.getPortletRequest().getPrivateParameterMap());
                portalUrl.getParameters().putAll(this.getPortletRequest().getPublicParameterMap());
            }
        }
    }

    protected void encodeBackLink(PortalActionURL portalUrl) {
        String backLink = portalUrl.getParameter("javax.portlet.faces.BackLink");
        if (null != backLink) {
            String viewId;
            portalUrl.removeParameter("javax.portlet.faces.BackLink");
            FacesContext facesContext = FacesContext.getCurrentInstance();
            if (null != facesContext.getViewRoot() && null != (viewId = facesContext.getViewRoot().getViewId())) {
                ViewHandler viewHandler = facesContext.getApplication().getViewHandler();
                String actionURL = viewHandler.getActionURL(facesContext, viewId);
                try {
                    portalUrl.addParameter(backLink, URLEncoder.encode(this.encodeActionURL(actionURL), "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    protected String encodePortletUrl(BaseURL portletURL, boolean escape) {
        StringWriter out = new StringWriter();
        try {
            portletURL.write((Writer)out, escape);
            return this.encodeURL(out.toString());
        }
        catch (IOException e) {
            throw new FacesException((Throwable)e);
        }
    }

    protected BridgeLogger getLogger() {
        return this.bridgeContext.getBridgeConfig().getLogger();
    }

    protected abstract String createRenderUrl(PortalActionURL var1, boolean var2, Map<String, List<String>> var3);

    protected abstract String createResourceUrl(PortalActionURL var1, boolean var2);

    protected abstract String createPartialActionUrl(PortalActionURL var1);

    protected abstract String createActionUrl(PortalActionURL var1, boolean var2);

    static enum Scheme {
        action,
        render,
        resource;

    }
}

