/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portletbridge.context;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.portlet.BaseURL;
import javax.portlet.MimeResponse;
import javax.portlet.PortletContext;
import javax.portlet.PortletMode;
import javax.portlet.PortletModeException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletSecurityException;
import javax.portlet.PortletURL;
import javax.portlet.ResourceURL;
import javax.portlet.WindowState;
import javax.portlet.WindowStateException;
import org.jboss.portletbridge.context.PortalActionURL;
import org.jboss.portletbridge.context.PortletExternalContextImpl;

public abstract class MimeExternalContextImpl
extends PortletExternalContextImpl {
    private static final String[] STRINGS = new String[0];

    public MimeExternalContextImpl(PortletContext context, PortletRequest request, MimeResponse response) {
        super(context, request, (PortletResponse)response);
    }

    @Override
    public PortletRequest getPortletRequest() {
        return (PortletRequest)super.getRequest();
    }

    public MimeResponse getMimeResponse() {
        return (MimeResponse)super.getResponse();
    }

    @Override
    protected String createActionUrl(PortalActionURL url, boolean escape) {
        MimeResponse renderResponse = this.getMimeResponse();
        PortletURL portletURL = renderResponse.createActionURL();
        this.setPortletUrlParameters(url, portletURL);
        for (String key : url.getParameters().keySet()) {
            String value = url.getParameter(key);
            portletURL.setParameter(key, value);
        }
        return this.encodePortletUrl((BaseURL)portletURL, escape);
    }

    @Override
    protected String createResourceUrl(PortalActionURL portalUrl, boolean escape) {
        MimeResponse renderResponse = this.getMimeResponse();
        ResourceURL resourceURL = renderResponse.createResourceURL();
        this.setBaseUrlParameters(portalUrl, (BaseURL)resourceURL);
        String path = portalUrl.getPath();
        if (!(null == path || path.length() <= 0 || portalUrl.hasParameter("_jsfBridgeViewId") || portalUrl.hasParameter("_jsfBridgeViewPath") || portalUrl.hasParameter("_jsfBridgeNonFacesView"))) {
            resourceURL.setResourceID(path);
        }
        resourceURL.setParameters(portalUrl.getParameters());
        return this.encodePortletUrl((BaseURL)resourceURL, escape);
    }

    @Override
    protected String createRenderUrl(PortalActionURL portalUrl, boolean escape, Map<String, List<String>> parameters) {
        MimeResponse renderResponse = this.getMimeResponse();
        PortletURL renderURL = renderResponse.createRenderURL();
        this.setPortletUrlParameters(portalUrl, renderURL);
        renderURL.setParameters(portalUrl.getParameters());
        for (String paramName : parameters.keySet()) {
            renderURL.setParameter(paramName, parameters.get(paramName).toArray(STRINGS));
        }
        String viewId = this.getViewIdFromUrl(portalUrl);
        if (null != viewId) {
            renderURL.setParameter("_jsfBridgeViewId", viewId);
        }
        return this.encodePortletUrl((BaseURL)renderURL, escape);
    }

    protected void setPortletUrlParameters(PortalActionURL portalUrl, PortletURL portletURL) {
        String windowParameter;
        String modeParameter = portalUrl.removeParameter("javax.portlet.faces.PortletMode");
        if (null != modeParameter) {
            try {
                PortletMode mode = new PortletMode(modeParameter);
                portletURL.setPortletMode(mode);
            }
            catch (PortletModeException e) {
                // empty catch block
            }
        }
        if (null != (windowParameter = portalUrl.removeParameter("javax.portlet.faces.WindowState"))) {
            try {
                WindowState state = new WindowState(windowParameter);
                portletURL.setWindowState(state);
            }
            catch (WindowStateException e) {
                // empty catch block
            }
        }
        this.setBaseUrlParameters(portalUrl, (BaseURL)portletURL);
    }

    protected void setBaseUrlParameters(PortalActionURL portalUrl, BaseURL resourceURL) {
        portalUrl.removeParameter("javax.portlet.faces.PortletMode");
        portalUrl.removeParameter("javax.portlet.faces.WindowState");
        String secure = portalUrl.getParameter("javax.portlet.faces.Secure");
        if (null != secure) {
            try {
                if ("true".equalsIgnoreCase(secure)) {
                    resourceURL.setSecure(true);
                } else if ("false".equalsIgnoreCase(secure)) {
                    resourceURL.setSecure(false);
                }
            }
            catch (PortletSecurityException e) {
                // empty catch block
            }
            portalUrl.removeParameter("javax.portlet.faces.Secure");
        }
    }

    @Override
    protected String createPartialActionUrl(PortalActionURL portalUrl) {
        MimeResponse renderResponse = this.getMimeResponse();
        ResourceURL resourceURL = renderResponse.createResourceURL();
        this.setBaseUrlParameters(portalUrl, (BaseURL)resourceURL);
        resourceURL.setParameters(portalUrl.getParameters());
        resourceURL.setParameter("_jsfBridgeViewId", this.getViewIdFromUrl(portalUrl));
        resourceURL.setParameter("_pbrAjax", Boolean.TRUE.toString());
        return this.encodeURL(resourceURL.toString());
    }

    @Override
    public String getResponseCharacterEncoding() {
        return this.getMimeResponse().getCharacterEncoding();
    }

    @Override
    public String getResponseContentType() {
        return this.getMimeResponse().getContentType();
    }

    public void setResponseContentType(String contentType) {
        this.getMimeResponse().setContentType(contentType);
    }

    public void setResponseContentLength(int length) {
    }

    public int getResponseBufferSize() {
        return this.getMimeResponse().getBufferSize();
    }

    public void setResponseBufferSize(int size) {
        this.getMimeResponse().setBufferSize(size);
    }

    public OutputStream getResponseOutputStream() throws IOException {
        return this.getMimeResponse().getPortletOutputStream();
    }

    public Writer getResponseOutputWriter() throws IOException {
        return this.getMimeResponse().getWriter();
    }

    public boolean isResponseCommitted() {
        boolean committed;
        if (this.isServletResponseRequiredForFlash()) {
            this.overrideHttpResponseForFlash = true;
            committed = this.getMimeResponse().isCommitted();
            this.overrideHttpResponseForFlash = false;
        } else {
            committed = this.getMimeResponse().isCommitted();
        }
        return committed;
    }

    public void responseFlushBuffer() throws IOException {
        this.getPortletFlash().doLastPhaseActions(FacesContext.getCurrentInstance(), false);
        this.getMimeResponse().flushBuffer();
    }

    public void responseReset() {
        this.getMimeResponse().reset();
    }

    public void addResponseHeader(String name, String value) {
        this.getMimeResponse().addProperty(name, value);
    }

    public void setResponseHeader(String name, String value) {
        this.getMimeResponse().setProperty(name, value);
    }

    public void responseSendError(int statusCode, String message) throws IOException {
    }

    public String getRequestCharacterEncoding() {
        return null;
    }

    public int getRequestContentLength() {
        return 0;
    }
}

