/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portletbridge.context;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import javax.faces.context.FacesContext;
import javax.faces.context.PartialResponseWriter;
import javax.faces.context.ResponseWriter;
import javax.portlet.MimeResponse;
import javax.portlet.PortletContext;
import javax.portlet.PortletRequest;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import org.jboss.portletbridge.context.MimeExternalContextImpl;

public class ResourceRequestExternalContextImpl
extends MimeExternalContextImpl {
    protected String facesRequest = null;
    protected boolean facesRequestSet = false;

    public ResourceRequestExternalContextImpl(PortletContext context, ResourceRequest request, ResourceResponse response) {
        super(context, (PortletRequest)request, (MimeResponse)response);
    }

    @Override
    public String getRequestCharacterEncoding() {
        return this.getResourceRequest().getCharacterEncoding();
    }

    @Override
    public void setRequestCharacterEncoding(String encoding) throws UnsupportedEncodingException {
        try {
            this.getResourceRequest().setCharacterEncoding(encoding);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Override
    public int getRequestContentLength() {
        return this.getResourceRequest().getContentLength();
    }

    @Override
    protected String getRequestHeader(String name) {
        if ("CONTENT-TYPE".equalsIgnoreCase(name)) {
            if (null == this.contentType) {
                this.constructContentType();
            }
            return this.contentType;
        }
        if ("CONTENT-LENGTH".equalsIgnoreCase(name)) {
            if (null == this.contentLength) {
                this.constructContentLength();
            }
            return this.contentLength;
        }
        if ("Faces-Request".equals(name)) {
            if (!this.facesRequestSet) {
                this.constructFacesRequest();
            }
            return this.facesRequest;
        }
        return super.getRequestHeader(name);
    }

    protected void constructFacesRequest() {
        String facesReq = super.getRequestHeader("Faces-Request");
        if (null != facesReq) {
            this.facesRequest = facesReq;
        } else {
            String isAjaxParam = this.getRequestParameterMap().get("_pbrAjax");
            if (null != isAjaxParam && Boolean.parseBoolean(isAjaxParam)) {
                this.facesRequest = "partial/ajax";
            }
        }
        this.facesRequestSet = true;
    }

    @Override
    protected Enumeration<String> getRequestHeaderNames() {
        ArrayList<String> names = new ArrayList<String>();
        Enumeration<String> propNames = super.getRequestHeaderNames();
        while (propNames.hasMoreElements()) {
            String name = propNames.nextElement();
            names.add(name);
        }
        names.add("CONTENT-TYPE");
        names.add("CONTENT-LENGTH");
        names.add("Faces-Request");
        return Collections.enumeration(names);
    }

    @Override
    protected String[] getRequestHeaderValues(String name) {
        if ("CONTENT-TYPE".equalsIgnoreCase(name)) {
            if (null == this.contentType) {
                this.constructContentType();
            }
            return new String[]{this.contentType};
        }
        if ("CONTENT-LENGTH".equalsIgnoreCase(name)) {
            if (null == this.contentLength) {
                this.constructContentLength();
            }
            return new String[]{this.contentLength};
        }
        if ("Faces-Request".equals(name)) {
            if (!this.facesRequestSet) {
                this.constructFacesRequest();
            }
            return new String[]{this.facesRequest};
        }
        return super.getRequestHeaderValues(name);
    }

    @Override
    public void redirect(String url) throws IOException {
        if (null == url || url.length() < 0) {
            throw new IllegalArgumentException("Path to redirect is null");
        }
        FacesContext facesContext = FacesContext.getCurrentInstance();
        this.getPortletFlash().doLastPhaseActions(facesContext, true);
        if (!facesContext.getPartialViewContext().isPartialRequest()) {
            throw new UnsupportedEncodingException("Can only redirect during RESOURCE_PHASE if a JSF partial/Ajax request has been triggered");
        }
        ResourceResponse resourceResponse = this.getResourceResponse();
        resourceResponse.setContentType("text/xml");
        resourceResponse.setCharacterEncoding("UTF-8");
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        PartialResponseWriter partialResponseWriter = responseWriter instanceof PartialResponseWriter ? (PartialResponseWriter)responseWriter : facesContext.getPartialViewContext().getPartialResponseWriter();
        partialResponseWriter.startDocument();
        partialResponseWriter.redirect(url);
        partialResponseWriter.endDocument();
        facesContext.responseComplete();
    }

    @Override
    public String encodeNamespace(String name) {
        if ("org.richfaces.extension".equalsIgnoreCase(name)) {
            return name;
        }
        return super.encodeNamespace(name);
    }

    public ResourceRequest getResourceRequest() {
        return (ResourceRequest)super.getRequest();
    }

    public ResourceResponse getResourceResponse() {
        return (ResourceResponse)super.getResponse();
    }

    @Override
    public void setResponseStatus(int statusCode) {
        ResourceResponse resourceResponse = (ResourceResponse)this.getResponse();
        resourceResponse.setProperty("portlet.http-status-code", Integer.toString(statusCode));
    }
}

