/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.server.reactor.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Predicate;
import org.jboss.resteasy.plugins.server.reactor.netty.ReactorNettyHttpResponse;
import org.jboss.resteasy.plugins.server.reactor.netty.ReactorNettySendException;
import org.jboss.resteasy.plugins.server.reactor.netty.SinkSubscriber;
import org.jboss.resteasy.plugins.server.reactor.netty.i18n.Messages;
import org.jboss.resteasy.spi.AsyncOutputStream;
import org.jboss.resteasy.spi.WriterException;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Sinks;
import reactor.netty.NettyOutbound;
import reactor.netty.http.server.HttpServerResponse;

class ChunkOutputStream
extends AsyncOutputStream {
    private final Sinks.Empty<Void> completionSink;
    private volatile boolean started;
    private final NettyOutbound nettyOutbound;
    private static final Predicate<ByteBuf> FLUSH_ON_EACH_WRITE = bb -> true;
    private final ReactorNettyHttpResponse parentResponse;

    ChunkOutputStream(ReactorNettyHttpResponse parentResponse, HttpServerResponse reactorNettyResponse, Sinks.Empty<Void> completionSink) {
        this.completionSink = Objects.requireNonNull(completionSink);
        this.parentResponse = Objects.requireNonNull(parentResponse);
        this.nettyOutbound = (NettyOutbound)Objects.requireNonNull(reactorNettyResponse);
    }

    public void write(int b) {
        this.write(new byte[]{(byte)b}, 0, 1);
    }

    public void write(byte[] bs, int off, int len) {
        try {
            ((CompletableFuture)this.asyncWrite(bs, off, len)).toCompletableFuture().get();
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw new ReactorNettySendException(ie);
        }
        catch (ExecutionException ee) {
            throw new ReactorNettySendException(ee);
        }
    }

    public void flush() {
        try {
            ((CompletableFuture)this.asyncFlush()).get();
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw new ReactorNettySendException(ie);
        }
        catch (ExecutionException ee) {
            throw new ReactorNettySendException(ee);
        }
    }

    public CompletableFuture<Void> asyncFlush() {
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<Void> asyncWrite(byte[] bs, int offset, int length) {
        try {
            if (!this.started) {
                this.parentResponse.committed();
                this.started = true;
            }
            byte[] bytes = bs;
            if (offset != 0 || length != bs.length) {
                bytes = Arrays.copyOfRange(bs, offset, offset + length);
            }
            return this.nettyOutbound.send((Publisher)Mono.just((Object)Unpooled.wrappedBuffer((byte[])bytes)), FLUSH_ON_EACH_WRITE).then().doOnError(err -> this.completionSink.emitError(err, Sinks.EmitFailureHandler.FAIL_FAST)).doOnCancel(() -> this.completionSink.emitError((Throwable)new WriterException(Messages.MESSAGES.responseWriteAborted()), Sinks.EmitFailureHandler.FAIL_FAST)).doOnDiscard(ByteBuf.class, byteBuf -> this.completionSink.emitError((Throwable)new WriterException(Messages.MESSAGES.responseWriteAborted()), Sinks.EmitFailureHandler.FAIL_FAST)).toFuture();
        }
        catch (Exception e) {
            this.completionSink.emitError((Throwable)e, Sinks.EmitFailureHandler.FAIL_FAST);
            CompletableFuture<Void> cf = new CompletableFuture<Void>();
            cf.completeExceptionally(e);
            return cf;
        }
    }

    public void close() throws IOException {
        SinkSubscriber.subscribe(this.completionSink, (Mono<Void>)Mono.empty());
    }
}

