/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.sasl.util;

import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.SaslException;
import org.jboss.sasl.util.SaslState;
import org.jboss.sasl.util.SaslStateContext;
import org.jboss.sasl.util.SaslWrapper;

public abstract class AbstractSaslParticipant {
    public static final byte[] NO_BYTES = new byte[0];
    private final SaslStateContext context = new SaslStateContext(){

        @Override
        public void setNegotiationState(SaslState newState) {
            AbstractSaslParticipant.this.state = newState;
        }

        @Override
        public void negotiationComplete() {
            AbstractSaslParticipant.this.state = SaslState.COMPLETE;
        }
    };
    private final String mechanismName;
    private final CallbackHandler callbackHandler;
    private final String protocol;
    private final String serverName;
    private SaslState state;
    private SaslWrapper wrapper;

    protected AbstractSaslParticipant(String mechanismName, String protocol, String serverName, CallbackHandler callbackHandler) {
        this.callbackHandler = callbackHandler;
        this.mechanismName = mechanismName;
        this.protocol = protocol;
        this.serverName = serverName;
    }

    protected void handleCallbacks(Callback ... callbacks) throws SaslException {
        try {
            this.tryHandleCallbacks(callbacks);
        }
        catch (UnsupportedCallbackException e) {
            throw new SaslException("Callback handler cannot support callback " + e.getCallback().getClass(), e);
        }
    }

    protected void tryHandleCallbacks(Callback ... callbacks) throws SaslException, UnsupportedCallbackException {
        try {
            this.callbackHandler.handle(callbacks);
        }
        catch (SaslException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new SaslException("Callback handler invocation failed", t);
        }
    }

    public void init() {
    }

    public String getMechanismName() {
        return this.mechanismName;
    }

    protected String getProtocol() {
        return this.protocol;
    }

    protected String getServerName() {
        return this.serverName;
    }

    protected CallbackHandler getCallbackHandler() {
        return this.callbackHandler;
    }

    protected SaslWrapper getWrapper() {
        return this.wrapper;
    }

    public SaslStateContext getContext() {
        return this.context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] evaluateMessage(byte[] message) throws SaslException {
        boolean ok = true;
        try {
            byte[] result = this.state.evaluateMessage(this.context, message);
            ok = true;
            byte[] byArray = result;
            return byArray;
        }
        finally {
            if (!ok) {
                this.state = SaslState.FAILED;
            }
        }
    }

    protected void setWrapper(SaslWrapper wrapper) {
        this.wrapper = wrapper;
    }

    public byte[] wrap(byte[] outgoing, int offset, int len) throws SaslException {
        SaslWrapper wrapper = this.wrapper;
        if (wrapper == null) {
            throw new IllegalStateException("Wrapping is not configured");
        }
        return wrapper.wrap(outgoing, offset, len);
    }

    public byte[] unwrap(byte[] incoming, int offset, int len) throws SaslException {
        SaslWrapper wrapper = this.wrapper;
        if (wrapper == null) {
            throw new IllegalStateException("Wrapping is not configured");
        }
        return wrapper.unwrap(incoming, offset, len);
    }

    public boolean isComplete() {
        return this.state == SaslState.COMPLETE;
    }

    public Object getNegotiatedProperty(String propName) {
        return null;
    }

    public void dispose() throws SaslException {
    }
}

