/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.ioc;

import java.lang.reflect.Proxy;
import java.util.Set;
import javassist.util.proxy.MethodHandler;
import javassist.util.proxy.ProxyObject;
import org.jboss.seam.Component;
import org.jboss.seam.ComponentType;
import org.jboss.seam.intercept.JavaBeanInterceptor;
import org.jboss.seam.ioc.IoCComponent;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;

public class ProxyUtils {
    private static final LogProvider log = Logging.getLogProvider(ProxyUtils.class);

    public static boolean isProxy(Class clazz) {
        return Proxy.isProxyClass(clazz);
    }

    public static Object enhance(Object bean, Set<Class> interfaces, IoCComponent component) throws Exception {
        Class<?> beanClass = bean.getClass();
        if (ProxyUtils.isProxy(beanClass)) {
            throw new RuntimeException("Seam cannot wrap JDK proxied IoC beans. Please use CGLib or Javassist proxying instead");
        }
        if (ProxyUtils.isCglibProxyClass(beanClass) || ProxyUtils.isJavassistProxyClass(beanClass)) {
            beanClass = beanClass.getSuperclass();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Creating proxy for " + component.getIoCName() + " Seam component '" + component.getName() + "' using class: " + beanClass.getName()));
        }
        JavaBeanInterceptor interceptor = new JavaBeanInterceptor(bean, (Component)component);
        ProxyObject po = (ProxyObject)Component.createProxyFactory((ComponentType)ComponentType.JAVA_BEAN, beanClass, interfaces).newInstance();
        po.setHandler((MethodHandler)interceptor);
        interceptor.postConstruct();
        return po;
    }

    public static boolean isCglibProxyClass(Class clazz) {
        return clazz != null && clazz.getName().contains("$$");
    }

    public static boolean isJavassistProxyClass(Class clazz) {
        return false;
    }
}

