/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.cache;

import java.lang.reflect.Method;
import org.jboss.cache.Cache;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.Fqn;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.AutoCreate;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Destroy;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.cache.AbstractJBossCacheProvider;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;
import org.jboss.seam.util.Reflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Name(value="org.jboss.seam.cache.cacheProvider")
@Scope(value=ScopeType.APPLICATION)
@BypassInterceptors
@Install(value=false, precedence=0, classDependencies={"org.jboss.cache.Cache", "org.jgroups.MembershipListener"})
@AutoCreate
public class JbossCache2Provider
extends AbstractJBossCacheProvider<Cache> {
    private Cache cache;
    private static final LogProvider log = Logging.getLogProvider(JbossCache2Provider.class);
    private static Method GET;
    private static Method PUT;
    private static Method REMOVE;
    private static Method REMOVE_NODE;

    @Create
    public void create() {
        log.debug("Starting JBoss Cache");
        try {
            DefaultCacheFactory factory = new DefaultCacheFactory();
            this.cache = factory.createCache(this.getConfigurationAsStream());
            this.cache.create();
            this.cache.start();
        }
        catch (Exception e) {
            throw new IllegalStateException("Error starting JBoss Cache", e);
        }
    }

    @Destroy
    public void destroy() {
        log.debug("Stopping JBoss Cache");
        try {
            this.cache.stop();
            this.cache.destroy();
            this.cache = null;
        }
        catch (Exception e) {
            throw new IllegalStateException("Error stopping JBoss Cache", e);
        }
    }

    @Override
    public Object get(String region, String key) {
        return Reflections.invokeAndWrap(GET, this.cache, this.getFqn(region), key);
    }

    @Override
    public void put(String region, String key, Object object) {
        Reflections.invokeAndWrap(PUT, this.cache, this.getFqn(region), key, object);
    }

    @Override
    public void remove(String region, String key) {
        Reflections.invokeAndWrap(REMOVE, this.cache, this.getFqn(region), key);
    }

    @Override
    public void clear() {
        Reflections.invokeAndWrap(REMOVE_NODE, this.cache, this.getFqn(null));
    }

    @Override
    public Cache getDelegate() {
        return this.cache;
    }

    static {
        try {
            GET = Cache.class.getDeclaredMethod("get", Fqn.class, Object.class);
            PUT = Cache.class.getDeclaredMethod("put", Fqn.class, Object.class, Object.class);
            REMOVE = Cache.class.getDeclaredMethod("remove", Fqn.class, Object.class);
            REMOVE_NODE = Cache.class.getDeclaredMethod("removeNode", Fqn.class);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to use JBoss Cache 2", e);
        }
    }
}

