/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.jcr.repository;

import javax.jcr.Credentials;
import javax.jcr.LoginException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.observation.EventListener;
import javax.jcr.observation.ObservationManager;
import org.jboss.seam.jcr.EventListenerConfig;
import org.jboss.seam.jcr.JcrCDIEventListener;
import org.jboss.seam.jcr.repository.AbstractSeamRepositoryImpl;

public class SeamEventRepositoryImpl
extends AbstractSeamRepositoryImpl {
    private JcrCDIEventListener eventListener;
    private EventListenerConfig eventConfig;

    public SeamEventRepositoryImpl(Repository delegated, EventListenerConfig eventConfig, JcrCDIEventListener eventListener) {
        super(delegated);
        this.eventListener = eventListener;
        this.eventConfig = eventConfig;
    }

    @Override
    public Session login() throws LoginException, RepositoryException {
        Session session = super.login();
        this.registerListener(session.getWorkspace().getObservationManager());
        return session;
    }

    @Override
    public Session login(Credentials credentials) throws LoginException, RepositoryException {
        Session session = super.login(credentials);
        this.registerListener(session.getWorkspace().getObservationManager());
        return session;
    }

    @Override
    public Session login(String workspaceName) throws LoginException, NoSuchWorkspaceException, RepositoryException {
        Session session = super.login(workspaceName);
        this.registerListener(session.getWorkspace().getObservationManager());
        return session;
    }

    @Override
    public Session login(Credentials credentials, String workspaceName) throws LoginException, NoSuchWorkspaceException, RepositoryException {
        Session session = super.login(credentials, workspaceName);
        this.registerListener(session.getWorkspace().getObservationManager());
        return session;
    }

    private void registerListener(ObservationManager obsManager) throws RepositoryException {
        if (this.eventConfig != null) {
            obsManager.addEventListener((EventListener)this.eventListener, this.eventConfig.getEventTypes(), this.eventConfig.getAbsPath(), this.eventConfig.isDeep(), this.eventConfig.getUuid(), this.eventConfig.getNodeTypeName(), this.eventConfig.isNoLocal());
        }
    }
}

