/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.persistence.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.jboss.seam.persistence.util.EjbApi;
import org.jboss.seam.transaction.SeamApplicationException;

public class ExceptionUtil {
    private ExceptionUtil() {
    }

    public static boolean exceptionCausesRollback(Exception e) {
        Class<?> exClass;
        boolean defaultRollback = false;
        if (e instanceof RuntimeException) {
            defaultRollback = true;
        }
        if ((exClass = e.getClass()).isAnnotationPresent(SeamApplicationException.class)) {
            SeamApplicationException sae = exClass.getAnnotation(SeamApplicationException.class);
            return sae.rollback();
        }
        if (exClass.isAnnotationPresent(EjbApi.APPLICATION_EXCEPTION)) {
            Annotation ae = exClass.getAnnotation(EjbApi.APPLICATION_EXCEPTION);
            try {
                Method rollback = EjbApi.APPLICATION_EXCEPTION.getMethod("rollback", new Class[0]);
                return (Boolean)rollback.invoke((Object)ae, new Object[0]);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        return defaultRollback;
    }
}

