/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.rest.exceptions;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.servlet.ServletContext;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.jboss.logging.Logger;
import org.jboss.seam.rest.SeamRestConfiguration;
import org.jboss.seam.rest.exceptions.ErrorMessageWrapper;
import org.jboss.seam.rest.exceptions.ExceptionMappingExtension;
import org.jboss.seam.rest.exceptions.Mapping;
import org.jboss.seam.rest.exceptions.RestResource;
import org.jboss.seam.rest.exceptions.UnhandledException;
import org.jboss.seam.rest.validation.ValidationException;
import org.jboss.seam.rest.validation.ValidationExceptionHandler;
import org.jboss.seam.solder.el.Expressions;

@Provider
@ApplicationScoped
public class SeamExceptionMapper
implements ExceptionMapper<Throwable> {
    @Inject
    @RestResource
    private Response.ResponseBuilder responseBuilder;
    @Inject
    @RestResource
    private Instance<Response> response;
    @Inject
    private Expressions expressions;
    @Inject
    private ValidationExceptionHandler validationExceptionHandler;
    private Map<Class<? extends Throwable>, Mapping> mappings = new HashMap<Class<? extends Throwable>, Mapping>();
    private static final Logger log = Logger.getLogger(SeamExceptionMapper.class);

    @Inject
    public void init(Instance<SeamRestConfiguration> configuration, ExceptionMappingExtension extension) {
        log.info((Object)"Processing exception mapping configuration.");
        if (!configuration.isAmbiguous() && !configuration.isUnsatisfied()) {
            Set exceptionMappings = ((SeamRestConfiguration)configuration.get()).getMappings();
            for (Mapping mapping : exceptionMappings) {
                this.addExceptionMapping(mapping);
            }
        }
        for (Mapping mapping : extension.getExceptionMappings()) {
            this.addExceptionMapping(mapping);
        }
    }

    protected void addExceptionMapping(Mapping mapping) {
        this.mappings.put(mapping.getExceptionType(), mapping);
        log.infov("Registered {0}", (Object)mapping);
    }

    public void init(@Observes @RestResource ServletContext ctx) {
    }

    public Response toResponse(Throwable e) {
        log.debugv("Handling {0}", e.getClass());
        for (Throwable exception = e; exception != null; exception = exception.getCause()) {
            Class<?> exceptionType = exception.getClass();
            if (this.mappings.containsKey(exceptionType)) {
                this.produceResponse(exception, this.responseBuilder);
                return (Response)this.response.get();
            }
            if (exception instanceof ValidationException) {
                this.validationExceptionHandler.handleValidationException((ValidationException)exception, this.responseBuilder);
                return (Response)this.response.get();
            }
            log.debugv("Unwrapping {0}", exception.getClass());
        }
        throw new UnhandledException(e);
    }

    protected void produceResponse(Throwable exception, Response.ResponseBuilder builder) {
        Mapping mapping = this.mappings.get(exception.getClass());
        log.debugv("Found exception mapping {0} for {1}", (Object)mapping, exception.getClass());
        builder.status(mapping.getStatusCode());
        String message = this.createMessage(mapping.getMessage(), mapping.isInterpolateMessageBody(), mapping.isUseExceptionMessage(), exception, this.expressions);
        if (message != null) {
            builder.entity(this.createEntityBody(mapping, message));
        }
    }

    protected String createMessage(String message, boolean interpolate, boolean useExceptionMessage, Throwable e, Expressions expressions) {
        String msg = message;
        if (msg == null || msg.length() == 0) {
            if (useExceptionMessage) {
                msg = e.getMessage();
            } else {
                return null;
            }
        }
        if (interpolate && msg != null) {
            return (String)expressions.evaluateValueExpression(msg, String.class);
        }
        return msg;
    }

    protected Object createEntityBody(Mapping mapping, String message) {
        if (mapping.isUseJaxb()) {
            return new ErrorMessageWrapper(message);
        }
        return message;
    }

    public Map<Class<? extends Throwable>, Mapping> getMappings() {
        return this.mappings;
    }
}

