/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.rest.validation;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.HashSet;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import javax.validation.Valid;
import javax.validation.Validator;
import org.jboss.logging.Logger;
import org.jboss.seam.rest.util.Annotations;
import org.jboss.seam.rest.validation.MethodMetadata;
import org.jboss.seam.rest.validation.ValidateRequest;
import org.jboss.seam.rest.validation.ValidationException;
import org.jboss.seam.rest.validation.ValidationMetadata;
import org.jboss.seam.solder.reflection.AnnotationInspector;
import org.jboss.seam.solder.reflection.PrimitiveTypes;

@Interceptor
@ValidateRequest
public class ValidationInterceptor
implements Serializable {
    private static final long serialVersionUID = -5804986456381504613L;
    private static final ValidateRequest DEFAULT_INTERCEPTOR_BINDING = new ValidateRequest.ValidateLiteral();
    private static final Logger log = Logger.getLogger(ValidationInterceptor.class);
    @Inject
    private Validator validator;
    @Inject
    private ValidationMetadata metadata;
    @Inject
    private BeanManager manager;

    @AroundInvoke
    public Object intercept(InvocationContext ctx) throws Exception {
        log.debugv("Validating {0}", (Object)ctx.getMethod().toGenericString());
        if (!this.metadata.containsMethodMetadata(ctx.getMethod())) {
            this.scanMethod(ctx.getMethod());
        }
        HashSet violations = new HashSet();
        MethodMetadata method = this.metadata.getMethodMetadata(ctx.getMethod());
        ValidateRequest interceptorBinding = method.getInterceptorBinding();
        Class[] groups = interceptorBinding.groups();
        if (interceptorBinding.validateResourceFields()) {
            log.debugv("Validating JAX-RS resource {0}", ctx.getTarget());
            violations.addAll(this.validator.validate(ctx.getTarget(), groups));
        }
        if (interceptorBinding.validateMessageBody() && method.getMessageBody() != null) {
            Object parameter = ctx.getParameters()[method.getMessageBody()];
            log.debugv("Validating HTTP message body {0}", parameter);
            violations.addAll(this.validator.validate(parameter, groups));
        }
        for (Integer parameterIndex : method.getValidatedParameters()) {
            Object parameter = ctx.getParameters()[parameterIndex];
            log.debugv("Validating parameter {0}", parameter);
            violations.addAll(this.validator.validate(parameter, groups));
        }
        if (violations.isEmpty()) {
            log.debug((Object)"Validation completed. No violations found.");
            return ctx.proceed();
        }
        log.debugv("Validation completed. {0} violations found.", (Object)violations.size());
        throw new ValidationException(violations);
    }

    private void scanMethod(Method method) {
        Integer messageBodyIndex = null;
        HashSet<Integer> otherValidatedParameters = new HashSet<Integer>();
        ValidateRequest interceptorBinding = this.getInterceptorBinding(method);
        log.debugv("This is the first time {0} is invoked. Scanning.", (Object)method);
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        for (int i = 0; i < parameterAnnotations.length; ++i) {
            if (parameterAnnotations[i].length == 0) {
                log.debugv("{0} identified as the message body.", method.getParameterTypes()[i]);
                messageBodyIndex = i;
                continue;
            }
            if (!this.isValidatedParameter(method.getParameterTypes()[i], method.getParameterAnnotations()[i])) continue;
            log.debugv("{0} identified as a validated parameter.", method.getParameterTypes()[i]);
            otherValidatedParameters.add(i);
        }
        this.metadata.addMethodMetadata(new MethodMetadata(method, messageBodyIndex, otherValidatedParameters, interceptorBinding));
    }

    private ValidateRequest getInterceptorBinding(Method method) {
        ValidateRequest interceptorBinding = (ValidateRequest)AnnotationInspector.getAnnotation((AnnotatedElement)method, ValidateRequest.class, (BeanManager)this.manager);
        if (interceptorBinding == null) {
            interceptorBinding = (ValidateRequest)AnnotationInspector.getAnnotation(method.getDeclaringClass(), ValidateRequest.class, (BeanManager)this.manager);
        }
        if (interceptorBinding == null) {
            log.debugv("Unable to find @ValidateRequest interceptor binding for {0}", (Object)method.toGenericString());
            return DEFAULT_INTERCEPTOR_BINDING;
        }
        return interceptorBinding;
    }

    private boolean isValidatedParameter(Class<?> parameterType, Annotation[] annotations) {
        if (Annotations.getAnnotation(annotations, Valid.class) == null) {
            return false;
        }
        if (PrimitiveTypes.allPrimitiveTypes().contains(parameterType) || PrimitiveTypes.allWrapperTypes().contains(parameterType) || String.class.isAssignableFrom(parameterType)) {
            log.warnv("Parameter {0} will not be validated as it is not a JavaBean.", parameterType);
            return false;
        }
        return true;
    }
}

