/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.security.external.dialogues;

import java.lang.annotation.Annotation;
import java.util.UUID;
import javax.enterprise.context.ContextNotActiveException;
import javax.enterprise.context.spi.Context;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.servlet.ServletContext;
import org.jboss.seam.security.external.contexts.ContextualInstance;
import org.jboss.seam.security.external.contexts.HashMapBeanStore;
import org.jboss.seam.security.external.dialogues.api.DialogueScoped;

public class DialogueContext
implements Context {
    private static final String BEAN_STORE_ATTRIBUTE_NAME_PREFIX = "DialogueContextBeanStore";
    private ServletContext servletContext;
    private final ThreadLocal<String> dialogueIdThreadLocal = new ThreadLocal();

    protected HashMapBeanStore getBeanStore() {
        return this.getBeanStore(this.dialogueIdThreadLocal.get());
    }

    private HashMapBeanStore getBeanStore(String dialogueId) {
        HashMapBeanStore beanStore = (HashMapBeanStore)this.servletContext.getAttribute(this.getAttributeName(dialogueId));
        return beanStore;
    }

    private void createBeanStore(String dialogueId) {
        HashMapBeanStore beanStore = new HashMapBeanStore();
        this.servletContext.setAttribute(this.getAttributeName(dialogueId), (Object)beanStore);
    }

    private void removeBeanStore(String dialogueId) {
        this.servletContext.removeAttribute(this.getAttributeName(dialogueId));
    }

    private String getAttributeName(String dialogueId) {
        return "DialogueContextBeanStore_" + dialogueId;
    }

    public void initialize(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public void destroy() {
        this.servletContext = null;
    }

    public String create() {
        String dialogueId;
        if (this.dialogueIdThreadLocal.get() != null) {
            throw new RuntimeException("Already attached to a dialogue");
        }
        while (this.getBeanStore(dialogueId = UUID.randomUUID().toString()) != null) {
        }
        this.dialogueIdThreadLocal.set(dialogueId);
        this.createBeanStore(dialogueId);
        return dialogueId;
    }

    public void remove() {
        this.getBeanStore().clear();
        this.removeBeanStore(this.dialogueIdThreadLocal.get());
        this.dialogueIdThreadLocal.set(null);
    }

    public boolean isExistingDialogue(String dialogueId) {
        return this.getBeanStore(dialogueId) != null;
    }

    public void attach(String dialogueId) {
        if (this.dialogueIdThreadLocal.get() != null) {
            throw new RuntimeException("Already attached to a dialogue");
        }
        if (!this.isExistingDialogue(dialogueId)) {
            throw new RuntimeException("There is no active context with request id " + dialogueId);
        }
        this.dialogueIdThreadLocal.set(dialogueId);
    }

    public void detach() {
        this.dialogueIdThreadLocal.set(null);
    }

    public boolean isAttached() {
        return this.dialogueIdThreadLocal.get() != null;
    }

    public <T> T get(Contextual<T> contextual, CreationalContext<T> creationalContext) {
        if (!this.isActive()) {
            throw new ContextNotActiveException();
        }
        ContextualInstance<Object> beanInstance = this.getBeanStore().get(contextual);
        if (beanInstance != null) {
            return beanInstance.getInstance();
        }
        if (creationalContext != null) {
            Object instance = contextual.create(creationalContext);
            if (instance != null) {
                beanInstance = new ContextualInstance<Object>(contextual, creationalContext, instance);
                this.getBeanStore().put(contextual, beanInstance);
            }
            return (T)instance;
        }
        return null;
    }

    public <T> T get(Contextual<T> contextual) {
        return this.get(contextual, null);
    }

    public Class<? extends Annotation> getScope() {
        return DialogueScoped.class;
    }

    public boolean isActive() {
        return this.dialogueIdThreadLocal.get() != null;
    }
}

