/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.security.external.dialogues;

import java.io.IOException;
import javax.inject.Inject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletResponse;
import org.jboss.seam.security.external.dialogues.api.DialogueManager;

@WebFilter(filterName="DialogueFilter", urlPatterns={"/*"})
public class DialogueFilter
implements Filter {
    public static final String DIALOGUE_ID_PARAM = "dialogueId";
    @Inject
    private DialogueManager manager;

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String dialogueId;
        if (this.manager.isAttached()) {
            this.manager.detachDialogue();
        }
        if ((dialogueId = request.getParameter(DIALOGUE_ID_PARAM)) != null) {
            if (!this.manager.isExistingDialogue(dialogueId)) {
                ((HttpServletResponse)response).sendError(400, "dialogue " + dialogueId + " does not exist");
                return;
            }
            this.manager.attachDialogue(dialogueId);
        }
        chain.doFilter(request, response);
        if (this.manager.isAttached()) {
            this.manager.detachDialogue();
        }
    }

    public void destroy() {
    }
}

