/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.security.external.saml;

import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.jboss.seam.security.external.dialogues.api.Dialogue;
import org.jboss.seam.security.external.jaxb.samlv2.assertion.AssertionType;
import org.jboss.seam.security.external.jaxb.samlv2.assertion.AudienceRestrictionType;
import org.jboss.seam.security.external.jaxb.samlv2.assertion.AuthnContextType;
import org.jboss.seam.security.external.jaxb.samlv2.assertion.AuthnStatementType;
import org.jboss.seam.security.external.jaxb.samlv2.assertion.ConditionsType;
import org.jboss.seam.security.external.jaxb.samlv2.assertion.NameIDType;
import org.jboss.seam.security.external.jaxb.samlv2.assertion.ObjectFactory;
import org.jboss.seam.security.external.jaxb.samlv2.assertion.SubjectConfirmationDataType;
import org.jboss.seam.security.external.jaxb.samlv2.assertion.SubjectConfirmationType;
import org.jboss.seam.security.external.jaxb.samlv2.assertion.SubjectType;
import org.jboss.seam.security.external.jaxb.samlv2.protocol.AuthnRequestType;
import org.jboss.seam.security.external.jaxb.samlv2.protocol.LogoutRequestType;
import org.jboss.seam.security.external.jaxb.samlv2.protocol.RequestAbstractType;
import org.jboss.seam.security.external.jaxb.samlv2.protocol.ResponseType;
import org.jboss.seam.security.external.jaxb.samlv2.protocol.StatusCodeType;
import org.jboss.seam.security.external.jaxb.samlv2.protocol.StatusResponseType;
import org.jboss.seam.security.external.jaxb.samlv2.protocol.StatusType;
import org.jboss.seam.security.external.saml.SamlDialogue;
import org.jboss.seam.security.external.saml.SamlEndpoint;
import org.jboss.seam.security.external.saml.SamlEntityBean;
import org.jboss.seam.security.external.saml.SamlServiceType;
import org.jboss.seam.security.external.saml.SamlUtils;
import org.jboss.seam.security.external.saml.api.SamlIdpSession;
import org.jboss.seam.security.external.saml.api.SamlNameId;
import org.jboss.seam.security.external.saml.idp.SamlIdpSessionImpl;

@ApplicationScoped
public class SamlMessageFactory {
    private static final int ASSERTION_VALIDITY_IN_MINUTES = 5;
    @Inject
    private Instance<SamlEntityBean> samlEntityBean;
    @Inject
    private Dialogue dialogue;
    @Inject
    private Instance<SamlDialogue> samlDialogue;
    private org.jboss.seam.security.external.jaxb.samlv2.protocol.ObjectFactory objectFactory = new org.jboss.seam.security.external.jaxb.samlv2.protocol.ObjectFactory();
    private ObjectFactory assertionObjectFactory = new ObjectFactory();

    public StatusResponseType createStatusResponse(String statusCode, String statusMessage) {
        StatusResponseType response = this.objectFactory.createStatusResponseType();
        this.fillStatusResponseFields(response, statusCode, statusMessage);
        return response;
    }

    public AuthnRequestType createAuthnRequest() {
        AuthnRequestType authnRequest = this.objectFactory.createAuthnRequestType();
        this.fillRequestAbstractTypeFields(authnRequest);
        authnRequest.setAssertionConsumerServiceURL(((SamlEntityBean)this.samlEntityBean.get()).getServiceURL(SamlServiceType.SAML_ASSERTION_CONSUMER_SERVICE));
        authnRequest.setProtocolBinding("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
        return authnRequest;
    }

    public ResponseType createResponse(SamlIdpSession session, SamlEndpoint externalSamlEndpoint) {
        ResponseType response = this.objectFactory.createResponseType();
        this.fillStatusResponseFields(response, "urn:oasis:names:tc:SAML:2.0:status:Success", null);
        AssertionType assertion = this.assertionObjectFactory.createAssertionType();
        response.getAssertionOrEncryptedAssertion().add(assertion);
        SubjectType subject = this.assertionObjectFactory.createSubjectType();
        assertion.setSubject(subject);
        NameIDType nameID = this.assertionObjectFactory.createNameIDType();
        subject.getContent().add(this.assertionObjectFactory.createNameID(nameID));
        nameID.setValue(session.getPrincipal().getNameId().getValue());
        nameID.setFormat(session.getPrincipal().getNameId().getFormat());
        nameID.setNameQualifier(session.getPrincipal().getNameId().getQualifier());
        SubjectConfirmationType subjectConfirmation = this.assertionObjectFactory.createSubjectConfirmationType();
        subject.getContent().add(this.assertionObjectFactory.createSubjectConfirmation(subjectConfirmation));
        subjectConfirmation.setMethod("urn:oasis:names:tc:SAML:2.0:cm:bearer");
        subjectConfirmation.setNameID(nameID);
        SubjectConfirmationDataType subjectConfirmationData = this.assertionObjectFactory.createSubjectConfirmationDataType();
        subjectConfirmation.setSubjectConfirmationData(subjectConfirmationData);
        subjectConfirmationData.setRecipient(externalSamlEndpoint.getLocation());
        subjectConfirmationData.setNotOnOrAfter(SamlUtils.getXMLGregorianCalendarNowPlusDuration(12, 5));
        subjectConfirmationData.setInResponseTo(((SamlDialogue)this.samlDialogue.get()).getExternalProviderMessageId());
        ConditionsType conditions = this.assertionObjectFactory.createConditionsType();
        assertion.setConditions(conditions);
        AudienceRestrictionType audienceRestriction = this.assertionObjectFactory.createAudienceRestrictionType();
        conditions.getConditionOrAudienceRestrictionOrOneTimeUse().add(audienceRestriction);
        audienceRestriction.getAudience().add(((SamlDialogue)this.samlDialogue.get()).getExternalProvider().getEntityId());
        AuthnStatementType authnStatement = this.assertionObjectFactory.createAuthnStatementType();
        assertion.getStatementOrAuthnStatementOrAuthzDecisionStatement().add(authnStatement);
        authnStatement.setAuthnInstant(SamlUtils.getXMLGregorianCalendarNow());
        authnStatement.setSessionIndex(((SamlIdpSessionImpl)session).getSessionIndex());
        AuthnContextType authnContext = this.assertionObjectFactory.createAuthnContextType();
        authnStatement.setAuthnContext(authnContext);
        authnContext.getContent().add(this.assertionObjectFactory.createAuthnContextDeclRef("urn:oasis:names:tc:SAML:2.0:ac:classes:PasswordProtectedTransport"));
        return response;
    }

    public LogoutRequestType createLogoutRequest(SamlNameId samlNameId, String sessionIndex) {
        LogoutRequestType logoutRequest = this.objectFactory.createLogoutRequestType();
        this.fillRequestAbstractTypeFields(logoutRequest);
        NameIDType nameID = this.assertionObjectFactory.createNameIDType();
        nameID.setValue(samlNameId.getValue());
        nameID.setFormat(samlNameId.getFormat());
        nameID.setNameQualifier(samlNameId.getQualifier());
        logoutRequest.setNameID(nameID);
        logoutRequest.getSessionIndex().add(sessionIndex);
        return logoutRequest;
    }

    private void fillRequestAbstractTypeFields(RequestAbstractType request) {
        request.setID(this.dialogue.getId());
        request.setIssueInstant(SamlUtils.getXMLGregorianCalendarNow());
        NameIDType issuer = this.assertionObjectFactory.createNameIDType();
        issuer.setValue(((SamlEntityBean)this.samlEntityBean.get()).getEntityId());
        request.setIssuer(issuer);
        request.setVersion("2.0");
    }

    private void fillStatusResponseFields(StatusResponseType response, String statusCode, String statusMessage) {
        response.setID(this.dialogue.getId());
        response.setIssueInstant(SamlUtils.getXMLGregorianCalendarNow());
        NameIDType issuer = this.assertionObjectFactory.createNameIDType();
        issuer.setValue(((SamlEntityBean)this.samlEntityBean.get()).getEntityId());
        response.setIssuer(issuer);
        response.setVersion("2.0");
        response.setInResponseTo(((SamlDialogue)this.samlDialogue.get()).getExternalProviderMessageId());
        StatusCodeType statusCodeJaxb = this.objectFactory.createStatusCodeType();
        statusCodeJaxb.setValue(statusCode);
        StatusType statusType = this.objectFactory.createStatusType();
        statusType.setStatusCode(statusCodeJaxb);
        if (statusMessage != null) {
            statusType.setStatusMessage(statusMessage);
        }
        response.setStatus(statusType);
    }
}

