/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.security.extension;

import java.lang.annotation.Annotation;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.seam.security.AuthorizationException;
import org.jboss.seam.security.events.AuthorizationCheckEvent;
import org.jboss.seam.security.extension.SecurityExtension;

@ApplicationScoped
public class AuthorizationObserver {
    @Inject
    SecurityExtension extension;

    public void observeAuthorizationCheckEvent(@Observes AuthorizationCheckEvent event) {
        boolean failed = false;
        for (Annotation annotation : event.getBindings()) {
            try {
                this.extension.checkAuthorization(annotation);
            }
            catch (AuthorizationException ex) {
                failed = true;
            }
        }
        if (!failed) {
            event.setPassed(true);
        }
    }
}

