/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.social.core;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessBean;
import javax.enterprise.inject.spi.ProcessManagedBean;
import org.jboss.logging.Logger;
import org.jboss.seam.social.core.OAuthService;
import org.jboss.seam.social.core.OAuthServiceSettings;
import org.jboss.seam.social.core.RelatedTo;

@ApplicationScoped
public class SeamSocialExtension
implements Extension {
    private Set<String> servicesNames = new HashSet<String>();
    private Map<AnnotatedType<? extends OAuthService>, String> servicesBean = new HashMap<AnnotatedType<? extends OAuthService>, String>();
    private static final Logger log = Logger.getLogger(SeamSocialExtension.class);

    public void processSettingsBeans(@Observes ProcessBean<OAuthServiceSettings> pbean) {
        log.info((Object)"Starting enumeration of existing service settings");
        Annotated annotated = pbean.getAnnotated();
        if (annotated.isAnnotationPresent(RelatedTo.class)) {
            RelatedTo related = (RelatedTo)annotated.getAnnotation(RelatedTo.class);
            String name = related.value();
            log.infof("Found configuration for service %s", (Object)name);
            this.servicesNames.add(name);
        }
    }

    public void processServicesBeans(@Observes ProcessManagedBean<OAuthService> pbean) {
        Annotated annotated = pbean.getAnnotated();
        if (annotated.isAnnotationPresent(RelatedTo.class)) {
            RelatedTo related = (RelatedTo)annotated.getAnnotation(RelatedTo.class);
            String name = related.value();
            this.servicesBean.put((AnnotatedType<? extends OAuthService>)pbean.getAnnotatedBeanClass(), name);
        }
    }

    public Set<String> getSocialRelated() {
        return this.servicesNames;
    }
}

