/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.social;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessBean;
import org.apache.commons.lang3.StringUtils;
import org.jboss.seam.social.ServiceConfiguration;
import org.jboss.seam.social.ServiceRelated;
import org.jboss.seam.social.oauth.OAuthApplication;
import org.jboss.seam.social.oauth.OAuthService;
import org.jboss.solder.logging.Logger;
import org.jboss.solder.reflection.AnnotationInspector;

@ApplicationScoped
public class SeamSocialExtension
implements Extension {
    private Set<String> servicesNames = Sets.newHashSet();
    private Set<Annotation> servicesQualifiersConfigured = Sets.newHashSet();
    private static Set<Annotation> servicesQualifiersAvailable = Sets.newHashSet();
    private static BiMap<Annotation, String> servicesToQualifier = HashBiMap.create();
    private boolean multiSession = false;
    private static final Logger log = Logger.getLogger(SeamSocialExtension.class);

    public void processSettingsBeans(@Observes ProcessBean<OAuthService> pbean, BeanManager beanManager) {
        log.info((Object)"Starting enumeration of existing service settings");
        Annotated annotated = pbean.getAnnotated();
        if (annotated.isAnnotationPresent(OAuthApplication.class)) {
            this.servicesQualifiersConfigured.addAll(AnnotationInspector.getAnnotations((Annotated)annotated, ServiceRelated.class));
        }
    }

    public void processServicesBeans(@Observes ProcessBean<ServiceConfiguration> pbean) throws InstantiationException, IllegalAccessException {
        Set qualifiers = AnnotationInspector.getAnnotations((Annotated)pbean.getAnnotated(), ServiceRelated.class);
        servicesQualifiersAvailable.addAll(qualifiers);
    }

    public Set<String> getSocialRelated() {
        return this.servicesNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processAfterDeploymentValidation(@Observes AfterDeploymentValidation adv) {
        log.info((Object)"validation phase");
        for (Annotation qual : servicesQualifiersAvailable) {
            String path = qual.annotationType().getName();
            String name = "";
            log.infof("Found service qualifier : %s", (Object)path);
            try {
                ResourceBundle bundle = ResourceBundle.getBundle(path);
                name = bundle.getString("service.name");
            }
            catch (MissingResourceException e) {
                log.warnf("No properties configuration file found for %s creating default service name", (Object)path);
                name = StringUtils.substringAfterLast((String)path, (String)".");
            }
            finally {
                servicesToQualifier.put((Object)qual, (Object)name);
            }
        }
        for (Annotation annot : this.servicesQualifiersConfigured) {
            this.servicesNames.add((String)servicesToQualifier.get((Object)annot));
        }
    }

    public static BiMap<Annotation, String> getServicesToQualifier() {
        return servicesToQualifier;
    }

    public static Set<Annotation> getServicesQualifiersAvailable() {
        return servicesQualifiersAvailable;
    }

    public boolean isMultiSession() {
        return this.multiSession;
    }

    public void setMultiSession(boolean multiSession) {
        this.multiSession = multiSession;
    }
}

