/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.solder.logging.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.jboss.seam.solder.logging.internal.BasicLogger;
import org.jboss.seam.solder.logging.internal.LogMessage;
import org.jboss.seam.solder.logging.internal.Logger;
import org.jboss.seam.solder.logging.internal.Message;
import org.jboss.seam.solder.logging.internal.MessageBundleInvocationHandler;
import org.jboss.seam.solder.logging.internal.MessageLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MessageLoggerInvocationHandler
extends MessageBundleInvocationHandler {
    private final Logger logger;

    MessageLoggerInvocationHandler(Class<?> type, String category) {
        this(type.getAnnotation(MessageLogger.class), category);
    }

    private MessageLoggerInvocationHandler(MessageLogger messageLogger, String category) {
        super(messageLogger.projectCode());
        this.logger = Logger.getLogger(category);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getDeclaringClass().equals(BasicLogger.class)) {
            return method.invoke((Object)this.logger, args);
        }
        Message message = method.getAnnotation(Message.class);
        if (message == null) {
            return null;
        }
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        LogMessage logMessage = method.getAnnotation(LogMessage.class);
        if (logMessage != null) {
            try {
                Logger.Level level = logMessage.level();
                if (this.logger.isEnabled(level)) {
                    String formatString = this.getFormatString(message);
                    if (formatString == null) {
                        return null;
                    }
                    ArrayList<Object> newArgs = new ArrayList<Object>();
                    Throwable cause = MessageLoggerInvocationHandler.extractCause(parameterAnnotations, args, newArgs);
                    Message.Format format = message.format();
                    switch (format) {
                        case PRINTF: {
                            this.logger.logf(level, cause, formatString, newArgs.toArray());
                            return null;
                        }
                        case MESSAGE_FORMAT: {
                            this.logger.logv(level, cause, formatString, newArgs.toArray());
                            return null;
                        }
                    }
                    return null;
                }
            }
            catch (Throwable ignored) {}
        } else {
            return super.invoke(proxy, method, args);
        }
        return null;
    }
}

