/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.solder.messages;

import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashSet;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.ProcessProducerMethod;
import org.jboss.seam.solder.bean.NarrowingBeanBuilder;
import org.jboss.seam.solder.literal.MessageBundleLiteral;
import org.jboss.seam.solder.messages.MessageBundle;
import org.jboss.seam.solder.messages.TypedMessageBundle;
import org.jboss.seam.solder.messages.TypedMessageBundleProducer;

public class TypedMessageBundleExtension
implements Extension {
    private final Collection<AnnotatedType<?>> messageBundleTypes = new HashSet();
    private Bean<Object> bundleProducerBean;

    void detectInterfaces(@Observes ProcessAnnotatedType<?> event, BeanManager beanManager) {
        AnnotatedType type = event.getAnnotatedType();
        if (type.isAnnotationPresent(MessageBundle.class)) {
            this.messageBundleTypes.add(type);
        }
    }

    void detectProducers(@Observes ProcessProducerMethod<Object, TypedMessageBundleProducer> event) {
        this.captureProducers(event.getAnnotatedProducerMethod(), event.getBean());
    }

    @Deprecated
    void detectProducersInverted(@Observes ProcessProducerMethod<TypedMessageBundleProducer, Object> event) {
        this.captureProducers(event.getAnnotatedProducerMethod(), event.getBean());
    }

    void captureProducers(AnnotatedMethod<?> method, Bean<?> bean) {
        if (method.isAnnotationPresent(TypedMessageBundle.class)) {
            this.bundleProducerBean = bean;
        }
    }

    void installBeans(@Observes AfterBeanDiscovery event, BeanManager beanManager) {
        for (AnnotatedType<?> type : this.messageBundleTypes) {
            event.addBean(TypedMessageBundleExtension.createMessageBundleBean(this.bundleProducerBean, type, beanManager));
        }
    }

    private static <T> Bean<T> createMessageBundleBean(Bean<Object> delegate, AnnotatedType<T> type, BeanManager beanManager) {
        return new NarrowingBeanBuilder<T>(delegate, beanManager).readFromType(type).types(new Type[]{type.getBaseType(), Object.class}).addQualifier(MessageBundleLiteral.INSTANCE).create();
    }

    void cleanup(@Observes AfterDeploymentValidation event) {
        this.messageBundleTypes.clear();
    }
}

