/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.solder.resourceLoader;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import javax.annotation.PreDestroy;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import org.jboss.seam.solder.core.Veto;
import org.jboss.seam.solder.reflection.AnnotationInstanceProvider;
import org.jboss.seam.solder.resourceLoader.Resource;

@Veto
public class ResourceProvider
implements Serializable {
    private static final long serialVersionUID = -4463427096501401965L;
    private final transient AnnotationInstanceProvider annotationInstanceProvider = new AnnotationInstanceProvider();
    private final Instance<URL> urlProvider;
    private final Instance<InputStream> inputStreamProvider;
    private final Instance<Properties> propertiesBundleProvider;
    private final Instance<Collection<URL>> urlsProvider;
    private final Instance<Collection<InputStream>> inputStreamsProvider;
    private final Instance<Collection<Properties>> propertiesBundlesProvider;
    private final Set<InputStream> streamsCache;

    ResourceProvider(@Any Instance<InputStream> inputStreamProvider, @Any Instance<URL> urlProvider, @Any Instance<Collection<InputStream>> inputStreamsProvider, @Any Instance<Collection<URL>> urlsProvider, @Any Instance<Properties> propertiesBundleProvider, @Any Instance<Collection<Properties>> propertiesBundlesProvider) {
        this.inputStreamProvider = inputStreamProvider;
        this.urlProvider = urlProvider;
        this.urlsProvider = urlsProvider;
        this.inputStreamsProvider = inputStreamsProvider;
        this.propertiesBundleProvider = propertiesBundleProvider;
        this.propertiesBundlesProvider = propertiesBundlesProvider;
        this.streamsCache = new HashSet<InputStream>();
    }

    public InputStream loadResourceStream(String name) {
        if (name == null || name.equals("")) {
            throw new IllegalArgumentException("You must specify the name of the resource to load");
        }
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("value", name);
        InputStream stream = (InputStream)this.inputStreamProvider.select(new Annotation[]{this.annotationInstanceProvider.get(Resource.class, values)}).get();
        this.streamsCache.add(stream);
        return stream;
    }

    public Collection<InputStream> loadResourcesStreams(String name) {
        if (name == null || name.equals("")) {
            throw new IllegalArgumentException("You must specify the name of the resource to load");
        }
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("value", name);
        Collection streams = (Collection)this.inputStreamsProvider.select(new Annotation[]{this.annotationInstanceProvider.get(Resource.class, values)}).get();
        this.streamsCache.addAll(streams);
        return streams;
    }

    public URL loadResource(String name) {
        if (name == null || name.equals("")) {
            throw new IllegalArgumentException("You must specify the name of the resource to load");
        }
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("value", name);
        return (URL)this.urlProvider.select(new Annotation[]{this.annotationInstanceProvider.get(Resource.class, values)}).get();
    }

    public Collection<URL> loadResources(String name) {
        if (name == null || name.equals("")) {
            throw new IllegalArgumentException("You must specify the name of the resource to load");
        }
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("value", name);
        return (Collection)this.urlsProvider.select(new Annotation[]{this.annotationInstanceProvider.get(Resource.class, values)}).get();
    }

    public Properties loadPropertiesBundle(String name) {
        if (name == null || name.equals("")) {
            throw new IllegalArgumentException("You must specify the name of the properties bundle to load");
        }
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("value", name);
        return (Properties)this.propertiesBundleProvider.select(new Annotation[]{this.annotationInstanceProvider.get(Resource.class, values)}).get();
    }

    public Collection<Properties> loadPropertiesBundles(String name) {
        if (name == null || name.equals("")) {
            throw new IllegalArgumentException("You must specify the name of the properties bundles to load");
        }
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("value", name);
        return (Collection)this.propertiesBundlesProvider.select(new Annotation[]{this.annotationInstanceProvider.get(Resource.class, values)}).get();
    }

    @PreDestroy
    private void cleanup() {
        for (InputStream stream : this.streamsCache) {
            try {
                stream.close();
            }
            catch (IOException iOException) {}
        }
    }
}

