/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.solder.util.collections;

import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import org.jboss.seam.solder.util.collections.AbstractMultimap;
import org.jboss.seam.solder.util.collections.Platform;
import org.jboss.seam.solder.util.collections.WrappedCollection;
import org.jboss.seam.solder.util.collections.WrappedListIterator;

class WrappedList<K, V>
extends WrappedCollection<K, V>
implements List<V> {
    private final AbstractMultimap<K, V> abstractMultimap;

    WrappedList(AbstractMultimap<K, V> abstractMultimap, K key, List<V> delegate, WrappedCollection<K, V> ancestor) {
        super(abstractMultimap, key, delegate, ancestor);
        this.abstractMultimap = abstractMultimap;
    }

    List<V> getListDelegate() {
        return (List)this.getDelegate();
    }

    @Override
    public boolean addAll(int index, Collection<? extends V> c) {
        if (c.isEmpty()) {
            return false;
        }
        int oldSize = this.size();
        boolean changed = this.getListDelegate().addAll(index, c);
        if (changed) {
            int newSize = this.getDelegate().size();
            this.abstractMultimap.totalSize += newSize - oldSize;
            if (oldSize == 0) {
                this.addToMap();
            }
        }
        return changed;
    }

    @Override
    public V get(int index) {
        this.refreshIfEmpty();
        return this.getListDelegate().get(index);
    }

    @Override
    public V set(int index, V element) {
        this.refreshIfEmpty();
        return this.getListDelegate().set(index, element);
    }

    @Override
    public void add(int index, V element) {
        this.refreshIfEmpty();
        boolean wasEmpty = this.getDelegate().isEmpty();
        this.getListDelegate().add(index, element);
        ++this.abstractMultimap.totalSize;
        if (wasEmpty) {
            this.addToMap();
        }
    }

    @Override
    public V remove(int index) {
        this.refreshIfEmpty();
        V value = this.getListDelegate().remove(index);
        --this.abstractMultimap.totalSize;
        this.removeIfEmpty();
        return value;
    }

    @Override
    public int indexOf(Object o) {
        this.refreshIfEmpty();
        return this.getListDelegate().indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        this.refreshIfEmpty();
        return this.getListDelegate().lastIndexOf(o);
    }

    @Override
    public ListIterator<V> listIterator() {
        this.refreshIfEmpty();
        return new WrappedListIterator(this);
    }

    @Override
    public ListIterator<V> listIterator(int index) {
        this.refreshIfEmpty();
        return new WrappedListIterator(index, this);
    }

    @Override
    public List<V> subList(int fromIndex, int toIndex) {
        this.refreshIfEmpty();
        return this.abstractMultimap.wrapList(this.getKey(), Platform.subList(this.getListDelegate(), fromIndex, toIndex), this.getAncestor() == null ? this : this.getAncestor());
    }
}

